/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch;

import java.awt.Color;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.sketch.XMLUtility;
import net.sourceforge.napkinlaf.sketch.geometry.SketchShape;
import net.sourceforge.napkinlaf.sketch.geometry.XMLShape;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;

public class TemplateItem
implements Cloneable {
    private boolean drawStroke = true;
    private boolean drawFill = false;
    private Color strokeColor = null;
    private float strokeWeight = 1.0f;
    private Color fillColor = null;
    private SketchShape shape = null;

    public Color getStrokeColor() {
        if (this.strokeColor == null) {
            return NapkinTheme.Manager.getCurrentTheme().getPenColor();
        }
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
    }

    public float getStrokeWeight() {
        return this.strokeWeight;
    }

    public void setStrokeWeight(float strokeWeight) {
        this.strokeWeight = strokeWeight;
    }

    public Color getFillColor() {
        if (this.fillColor == null) {
            return NapkinTheme.Manager.getCurrentTheme().getHighlightColor();
        }
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public SketchShape getShape() {
        return this.shape;
    }

    public void setShape(SketchShape shape) {
        if (shape == null) {
            throw new NullPointerException();
        }
        this.shape = shape;
    }

    public boolean isDrawFill() {
        return this.drawFill;
    }

    public void setDrawFill(boolean drawFill) {
        this.drawFill = drawFill;
    }

    public boolean isDrawStroke() {
        return this.drawStroke;
    }

    public void setDrawStroke(boolean drawStroke) {
        this.drawStroke = drawStroke;
    }

    public Element produceXML() {
        if (this.shape instanceof XMLShape) {
            DefaultJDOMFactory f = new DefaultJDOMFactory();
            Element ret = f.element("templateItem");
            if (this.strokeColor != null) {
                ret.addContent(XMLUtility.colorToXML(this.strokeColor, "strokeColor"));
            }
            if (this.strokeWeight != 1.0f) {
                Element t = f.element("strokeWeight");
                t.addContent(f.text(Float.toString(this.strokeWeight)));
                ret.addContent(t);
            }
            if (this.fillColor != null) {
                ret.addContent(XMLUtility.colorToXML(this.fillColor, "fillColor"));
            }
            ret.addContent(((XMLShape)this.shape).produceXML());
            return ret;
        }
        return null;
    }

    public TemplateItem clone() {
        try {
            TemplateItem item = (TemplateItem)super.clone();
            item.drawFill = this.drawFill;
            item.drawStroke = this.drawStroke;
            item.fillColor = this.fillColor;
            item.shape = this.shape.clone();
            item.strokeColor = this.strokeColor;
            item.strokeWeight = this.strokeWeight;
            return item;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("cannot clone?", e);
        }
    }
}

