/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.borders;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import net.sourceforge.napkinlaf.borders.AbstractNapkinBorder;
import net.sourceforge.napkinlaf.borders.NapkinBevelBorder;
import net.sourceforge.napkinlaf.borders.NapkinEtchedBorder;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinWrappedBorder
extends AbstractNapkinBorder {
    private final Border origBorder;
    private static final Map<Border, Border> borders = new WeakHashMap<Border, Border>(3);

    public NapkinWrappedBorder(Border origBorder) {
        this.origBorder = origBorder;
    }

    protected Insets doGetBorderInsets(Component c, Insets insets) {
        Insets result = this.origBorder.getBorderInsets(c);
        insets.set(result.top, result.left, result.bottom, result.right);
        return insets;
    }

    public boolean isBorderOpaque() {
        return this.origBorder.isBorderOpaque();
    }

    protected void doPaintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g = NapkinUtil.defaultGraphics(g, c);
        NapkinUtil.syncWithTheme(this.origBorder, c);
        this.origBorder.paintBorder(c, g, x, y, width, height);
        NapkinUtil.finishGraphics(g, c);
    }

    public Border getOrigBorder() {
        return this.origBorder;
    }

    public static NapkinWrappedBorder wrap(Border origBorder) {
        BevelBorder bb;
        AbstractBorder toWrap;
        EtchedBorder eb;
        Border brd = borders.get(origBorder);
        if (brd instanceof NapkinWrappedBorder) {
            return (NapkinWrappedBorder)brd;
        }
        if (origBorder instanceof EtchedBorder && ((eb = (EtchedBorder)origBorder).getHighlightColor() == null || eb.getShadowColor() == null)) {
            toWrap = new NapkinEtchedBorder(eb);
            borders.put(origBorder, toWrap);
        }
        if (origBorder instanceof BevelBorder && ((bb = (BevelBorder)origBorder).getHighlightInnerColor() == null || bb.getHighlightOuterColor() == null || bb.getShadowInnerColor() == null || bb.getShadowOuterColor() == null)) {
            toWrap = new NapkinBevelBorder(bb);
            borders.put(origBorder, toWrap);
        }
        return new NapkinWrappedBorder(origBorder);
    }
}

