/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.borders;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.InsetsUIResource;
import net.sourceforge.napkinlaf.borders.AbstractNapkinBorder;
import net.sourceforge.napkinlaf.shapes.DrawnBoxHolder;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinBoxBorder
extends AbstractNapkinBorder {
    private static final int SMALL_BORDER = 3;
    private static final int LARGE_BORDER = 4;
    public static final Insets SMALL_DEFAULT_INSETS = new InsetsUIResource(3, 3, 3, 3);
    public static final Insets LARGE_DEFAULT_INSETS = new InsetsUIResource(4, 4, 4, 4);
    private static final NapkinUtil.PropertyFactory BOX_FACTORY = new NapkinUtil.PropertyFactory(){

        public Object createPropertyValue() {
            return new DrawnBoxHolder();
        }
    };

    protected void doPaintBorder(Component c, Graphics g1, int x, int y, int width, int height) {
        DrawnBoxHolder box = (DrawnBoxHolder)NapkinUtil.getProperty((JComponent)c, "net.sourceforge.napkinlaf.border", BOX_FACTORY);
        Rectangle passed = new Rectangle(x, y, width, height);
        box.shapeUpToDate(passed);
        Graphics2D g = (Graphics2D)g1;
        g.translate(x, y);
        box.draw(g);
        g.translate(-x, -y);
    }

    public static Insets getDefaultInsets(Rectangle bounds, Insets insets) {
        int wi = bounds.height <= 100 ? 3 : 4;
        int hi = bounds.width <= 100 ? 3 : 4;
        insets.set(hi, wi, hi, wi);
        return insets;
    }

    public static Insets getDefaultInsets(Rectangle bounds) {
        return NapkinBoxBorder.getDefaultInsets(bounds, new Insets(0, 0, 0, 0));
    }

    public static int getDelta(int num) {
        return num > 3 ? num >> 1 : num;
    }

    public static int getWidthDelta(Insets in) {
        return NapkinBoxBorder.getDelta(in.left) + NapkinBoxBorder.getDelta(in.right);
    }

    public static int getHeightDelta(Insets in) {
        return NapkinBoxBorder.getDelta(in.top) + NapkinBoxBorder.getDelta(in.bottom);
    }

    public Insets doGetBorderInsets(Component c, Insets insets) {
        return NapkinBoxBorder.getDefaultInsets(c.getBounds(), insets);
    }
}

