/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.shapes.DrawnLineHolder;
import net.sourceforge.napkinlaf.util.NapkinPainter;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinTreeUI
extends BasicTreeUI
implements NapkinPainter {
    private final LineCache linesFor = new LineCache();

    public static ComponentUI createUI(JComponent c) {
        return new NapkinTreeUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        NapkinUtil.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        super.uninstallUI(c);
    }

    public void update(Graphics g, JComponent c) {
        NapkinUtil.update(g, c, this);
    }

    public void superPaint(Graphics g, JComponent c, NapkinTheme theme) {
        super.update(g, c);
    }

    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        this.paintLine(g, x, top, x, bottom);
    }

    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
        this.paintLine(g, left, y, right, y);
    }

    private void paintLine(Graphics g, int x1, int y1, int x2, int y2) {
        int w = x2 - x1;
        int h = y2 - y1;
        Rectangle rect = new Rectangle(x1, y1, w, h);
        DrawnLineHolder holder = (DrawnLineHolder)this.linesFor.get(rect);
        if (holder == null) {
            holder = new DrawnLineHolder(Math.max(w, h), w == 0);
            this.linesFor.put(rect, holder);
        }
        DrawnLineHolder line = holder;
        line.shapeUpToDate(rect, null);
        line.draw(g);
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        Rectangle rect = this.tree.getBounds();
        rect.x = 0;
        rect.y = 0;
        super.paintVerticalPartOfLeg(g, rect, insets, path);
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        Rectangle rect = this.tree.getBounds();
        rect.x = 0;
        rect.y = 0;
        super.paintHorizontalPartOfLeg(g, rect, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    protected Color getHashColor() {
        return NapkinUtil.currentTheme(this.tree).getPenColor();
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultNapkinTreeCellRender();
    }

    public static class DefaultNapkinTreeCellRender
    extends DefaultTreeCellRenderer
    implements NapkinPainter {
        public void paint(Graphics g) {
            NapkinUtil.update(g, this, this);
        }

        public void superPaint(Graphics g, JComponent c, NapkinTheme theme) {
            super.paint(g);
        }

        public Icon getOpenIcon() {
            return this.getDefaultOpenIcon();
        }

        public Icon getLeafIcon() {
            return this.getDefaultLeafIcon();
        }

        public Icon getClosedIcon() {
            return this.getDefaultClosedIcon();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LineCache
    extends LinkedHashMap<Rectangle, DrawnLineHolder> {
        private static final int MAX_NUM_OF_LINES = 100;

        public LineCache() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Rectangle, DrawnLineHolder> eldest) {
            return this.size() > 100;
        }
    }
}

