/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.borders.NapkinBoxBorder;
import net.sourceforge.napkinlaf.shapes.DrawnBoxHolder;
import net.sourceforge.napkinlaf.shapes.DrawnTabHolder;
import net.sourceforge.napkinlaf.util.NapkinPainter;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinTabbedPaneUI
extends BasicTabbedPaneUI
implements NapkinPainter {
    private DrawnTabHolder[] tabs = new DrawnTabHolder[0];
    private final DrawnBoxHolder contentBorder = new DrawnBoxHolder();
    private Insets origInsets;

    public static ComponentUI createUI(JComponent c) {
        return new NapkinTabbedPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        NapkinUtil.installUI(c);
        this.origInsets = this.contentBorderInsets;
        this.contentBorderInsets = NapkinBoxBorder.LARGE_DEFAULT_INSETS;
    }

    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        this.contentBorderInsets = this.origInsets;
        super.uninstallUI(c);
    }

    public void paint(Graphics g, JComponent c) {
        int count = ((JTabbedPane)c).getTabCount();
        DrawnTabHolder[] newTabs = new DrawnTabHolder[count];
        System.arraycopy(this.tabs, 0, newTabs, 0, Math.min(this.tabs.length, newTabs.length));
        this.tabs = newTabs;
        super.paint(g, c);
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        DrawnTabHolder tabHolder = this.tabs[tabIndex];
        if (tabHolder == null) {
            tabHolder = this.tabs[tabIndex] = new DrawnTabHolder(tabPlacement);
        }
        tabHolder.shapeUpToDate(tabPlacement, x, y, w, h);
        g.setColor(this.tabPane.getForeground());
        tabHolder.draw(g);
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        this.calcRect.x = x;
        this.calcRect.y = y;
        this.calcRect.width = w;
        this.calcRect.height = h;
        if (selectedIndex < 0) {
            this.contentBorder.shapeUpToDate(this.calcRect);
        } else {
            DrawnTabHolder tab = this.tabs[selectedIndex];
            if (tab == null) {
                this.contentBorder.shapeUpToDate(this.calcRect);
            } else {
                Point2D beg = tab.getBreakBeg();
                Point2D end = tab.getBreakEnd();
                this.contentBorder.shapeUpToDate(this.calcRect, tabPlacement, beg.getX(), beg.getY(), end.getX(), end.getY());
            }
        }
        g.setColor(this.tabPane.getForeground());
        g.translate(this.calcRect.x, this.calcRect.y);
        this.contentBorder.draw(g);
        g.translate(-this.calcRect.x, -this.calcRect.y);
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    public void update(Graphics g, JComponent c) {
        NapkinUtil.update(g, c, this);
    }

    public void superPaint(Graphics g, JComponent c, NapkinTheme theme) {
        super.update(g, c);
    }
}

