/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import net.sourceforge.napkinlaf.NapkinSplitPaneUI;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.util.NapkinIconFactory;
import net.sourceforge.napkinlaf.util.NapkinPainter;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinSplitPaneDivider
extends BasicSplitPaneDivider
implements NapkinPainter {
    private JButton left;
    private JButton right;
    private static final int ARROW_SIZE = 5;
    static final int SIZE = 9;
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);

    public NapkinSplitPaneDivider(NapkinSplitPaneUI ui) {
        super(ui);
    }

    public void update(Graphics g) {
        NapkinUtil.update(g, this.splitPane, this);
    }

    public void superPaint(Graphics g, JComponent c, NapkinTheme theme) {
        super.update(g);
    }

    protected JButton createLeftOneTouchButton() {
        int dir = this.orientation == 1 ? 7 : 1;
        this.left = this.createOneTouchButton(dir);
        return this.left;
    }

    protected JButton createRightOneTouchButton() {
        int dir = this.orientation == 1 ? 3 : 5;
        this.right = this.createOneTouchButton(dir);
        return this.right;
    }

    protected JButton createOneTouchButton(int dir) {
        JButton b = NapkinUtil.createArrowButton(dir, 5);
        b.setFocusable(false);
        b.setMinimumSize(new Dimension(9, 9));
        b.setCursor(DEFAULT_CURSOR);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    protected void setOrientation(int orientation) {
        if (this.left == null) {
            return;
        }
        if (orientation == 1) {
            this.left.setIcon(NapkinIconFactory.createArrowIcon(7, 5));
            this.right.setIcon(NapkinIconFactory.createArrowIcon(3, 5));
        } else {
            this.left.setIcon(NapkinIconFactory.createArrowIcon(1, 5));
            this.right.setIcon(NapkinIconFactory.createArrowIcon(5, 5));
        }
    }
}

