/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.shapes.DrawnBoxHolder;
import net.sourceforge.napkinlaf.shapes.DrawnScribbleHolder;
import net.sourceforge.napkinlaf.util.NapkinPainter;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class NapkinProgressBarUI
extends BasicProgressBarUI
implements NapkinPainter {
    private final DrawnScribbleHolder scribble = new DrawnScribbleHolder();
    private final Rectangle sz = new Rectangle(0, 0, 0, 0);
    private DrawnBoxHolder box;
    private Image curImage;
    private Color selectionForeground;
    private Color selectionBackground;

    public static ComponentUI createUI(JComponent c) {
        return new NapkinProgressBarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        NapkinUtil.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        NapkinUtil.uninstallUI(c);
        super.uninstallUI(c);
    }

    protected void paintIndeterminate(Graphics g1, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Graphics2D g = (Graphics2D)g1;
        this.boxRect = this.getBox(this.boxRect);
        if (this.boxRect == null) {
            return;
        }
        if (this.box == null) {
            this.box = new DrawnBoxHolder();
            this.box.setWidth(2.0f);
        }
        this.box.shapeUpToDate(this.boxRect);
        Graphics2D lineG = NapkinUtil.copy(g);
        lineG.setColor(NapkinUtil.currentTheme(c).getCheckColor());
        lineG.translate(this.boxRect.x, this.boxRect.y);
        this.box.draw(lineG);
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.width, b);
            } else {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.height, b);
            }
        }
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        boolean backwards;
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        c.getBounds(this.sz);
        int orientation = this.progressBar.getOrientation();
        boolean bl = backwards = !NapkinUtil.isLeftToRight(c);
        if (this.scribble.shapeUpToDate(c, this.sz, orientation, amountFull, backwards)) {
            NapkinTheme theme = NapkinUtil.currentTheme(c);
            this.curImage = new BufferedImage(this.sz.x + this.sz.width, this.sz.y + this.sz.height, 2);
            Graphics2D imgG = (Graphics2D)this.curImage.getGraphics();
            this.selectionForeground = theme.getRadioColor();
            this.selectionBackground = theme.getCheckColor();
            imgG.setColor(theme.getCheckColor());
            this.scribble.draw(imgG);
        }
        g.drawImage(this.curImage, 0, 0, c);
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    public void update(Graphics g, JComponent c) {
        NapkinUtil.update(g, c, this);
    }

    public void superPaint(Graphics g, JComponent c, NapkinTheme theme) {
        super.update(g, c);
    }

    protected Color getSelectionBackground() {
        return this.selectionBackground;
    }

    protected Color getSelectionForeground() {
        return this.selectionForeground;
    }
}

