/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf;

import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.swing.UIDefaults;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.borders.NapkinBoxBorder;
import net.sourceforge.napkinlaf.borders.NapkinLineBorder;
import net.sourceforge.napkinlaf.borders.NapkinSelectedBorder;
import net.sourceforge.napkinlaf.util.AlphaColorUIResource;
import net.sourceforge.napkinlaf.util.ComponentWalker;
import net.sourceforge.napkinlaf.util.NapkinConstants;
import net.sourceforge.napkinlaf.util.NapkinDebug;
import net.sourceforge.napkinlaf.util.NapkinIconFactory;
import net.sourceforge.napkinlaf.util.NapkinUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NapkinLookAndFeel
extends BasicLookAndFeel {
    private static final String[] UI_TYPES = new String[]{"ButtonUI", "CheckBoxMenuItemUI", "CheckBoxUI", "ColorChooserUI", "ComboBoxUI", "DesktopIconUI", "DesktopPaneUI", "EditorPaneUI", "FileChooserUI", "FormattedTextFieldUI", "InternalFrameUI", "LabelUI", "ListUI", "MenuBarUI", "MenuItemUI", "MenuUI", "OptionPaneUI", "PanelUI", "PasswordFieldUI", "PopupMenuSeparatorUI", "PopupMenuUI", "ProgressBarUI", "RadioButtonMenuItemUI", "RadioButtonUI", "RootPaneUI", "ScrollBarUI", "ScrollPaneUI", "SeparatorUI", "SliderUI", "SpinnerUI", "SplitPaneUI", "TabbedPaneUI", "TableHeaderUI", "TableUI", "TextAreaUI", "TextFieldUI", "TextPaneUI", "ToggleButtonUI", "ToolBarSeparatorUI", "ToolBarUI", "ToolTipUI", "TreeUI", "ViewportUI"};

    @Override
    public String getDescription() {
        return "The Napkin Look and Feel";
    }

    @Override
    public String getID() {
        return "Napkin";
    }

    @Override
    public String getName() {
        return this.getID();
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String cName = NapkinLookAndFeel.class.getName();
        String basicPackageName = cName.replace("NapkinLookAndFeel", "Napkin");
        for (String uiType : UI_TYPES) {
            String uiClass = basicPackageName + uiType;
            table.put(uiType, uiClass);
        }
        HashSet keys = new HashSet(table.keySet());
        keys.removeAll(Arrays.asList(UI_TYPES));
        if (keys.size() != 0) {
            System.out.println("keys we didn't overwrite: " + keys);
        }
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        table.put("textHighlight", theme.getHighlightColor());
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        NapkinLookAndFeel.overrideComponentDefaults(table);
        UIDefaults.ActiveValue checkBoxButtonIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createCheckBoxIcon();
            }
        };
        UIDefaults.ActiveValue checkedMenuItemIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createCheckedMenuItemIcon();
            }
        };
        UIDefaults.ActiveValue radioButtonIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createRadioButtonIcon();
            }
        };
        UIDefaults.ActiveValue underlineBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinLineBorder(false);
            }
        };
        UIDefaults.ActiveValue selectBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinSelectedBorder();
            }
        };
        UIDefaults.ActiveValue downArrowIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(5, 8);
            }
        };
        UIDefaults.ActiveValue rightArrowIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(3, 8);
            }
        };
        UIDefaults.ActiveValue closeIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createXIcon(15);
            }
        };
        UIDefaults.ActiveValue minIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(1, 10);
            }
        };
        UIDefaults.ActiveValue iconIcon = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createArrowIcon(5, 10);
            }
        };
        NapkinLookAndFeel.setupActions(table);
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        NapkinTheme popupTheme = theme.getPopupTheme();
        Object[] napkinDefaults = new Object[]{"RadioButton.textIconGap", 0, "RadioButton.icon", radioButtonIcon, "RadioButtonMenuItem.textIconGap", 0, "RadioButtonMenuItem.checkIcon", radioButtonIcon, "CheckBox.textIconGap", 0, "CheckBox.icon", checkBoxButtonIcon, "CheckBoxMenuItem.textIconGap", 0, "CheckBoxMenuItem.checkIcon", checkedMenuItemIcon, "Menu.arrowIcon", rightArrowIcon, "OptionPane.messageAreaBorder", null, "TabbedPane.contentBorderInsets", NapkinBoxBorder.LARGE_DEFAULT_INSETS, "Tree.openIcon", downArrowIcon, "Tree.closedIcon", rightArrowIcon, "Tree.hash", theme.getPenColor(), "Tree.collapsedIcon", null, "Tree.expandedIcon", null, "Tree.leafIcon", null, "Tree.selectionBorderColor", null, "TextField.caretForeground", theme.getPenColor(), "TextArea.caretForeground", theme.getPenColor(), "TextField.border", underlineBorder, "PasswordField.border", underlineBorder, "Menu.border", null, "MenuBar.border", null, "PopupMenu.border", null, "ToolTip.border", null, "DesktopIcon.border", null, "ToggleButton.border", selectBorder, "InternalFrame.border", new BorderUIResource(new EmptyBorder(3, 3, 3, 3)), "PopupMenu.foreground", popupTheme.getPenColor(), "ToolTip.foreground", popupTheme.getPenColor(), "CheckBoxMenuItem.foreground", popupTheme.getPenColor(), "CheckBoxMenuItem.selectionForeground", popupTheme.getSelectionColor(), "RadioButtonMenuItem.foreground", popupTheme.getPenColor(), "RadioButtonMenuItem.selectionForeground", popupTheme.getSelectionColor(), "MenuItem.foreground", popupTheme.getPenColor(), "MenuItem.selectionForeground", popupTheme.getSelectionColor(), "InternalFrame.maximizeIcon", null, "InternalFrame.minimizeIcon", minIcon, "InternalFrame.iconifyIcon", iconIcon, "InternalFrame.closeIcon", closeIcon, "InternalFrame.closeButtonToolTip", "Close", "InternalFrame.iconButtonToolTip", "Minimise", "InternalFrame.restoreButtonToolTip", "Restore", "InternalFrame.maxButtonToolTip", "Maximise", "InternalFrame.activeTitleForeground", popupTheme.getSelectionColor(), "InternalFrame.inactiveTitleForeground", popupTheme.getPenColor(), "SplitPaneDivider.border", null, "SplitPane.dividerSize", 9, "FileChooser.upFolderIcon", NapkinLookAndFeel.sketchedIcon("UpFolder"), "FileChooser.detailsViewIcon", NapkinLookAndFeel.sketchedIcon("DetailsView"), "FileChooser.listViewIcon", NapkinLookAndFeel.sketchedIcon("ListView"), "FileChooser.newFolderIcon", NapkinLookAndFeel.sketchedIcon("NewFolder"), "FileChooser.homeFolderIcon", NapkinLookAndFeel.sketchedIcon("HomeFolder"), "FileChooser.lookInLabelText", "Look in:", "FileChooser.saveInLabelText", "Save in:", "FileChooser.fileNameLabelText", "File Name(s):", "FileChooser.filesOfTypeLabelText", "Of Type(s):", "FileChooser.upFolderToolTipText", "Up One Level", "FileChooser.homeFolderToolTipText", "Home Folder", "FileChooser.newFolderToolTipText", "New Folder", "FileChooser.listViewButtonToolTipText", "List View", "FileChooser.detailsViewButtonToolTipText", "Details View", "FileView.directoryIcon", NapkinLookAndFeel.sketchedIcon("Directory"), "FileView.fileIcon", NapkinLookAndFeel.sketchedIcon("File"), "FileView.computerIcon", NapkinLookAndFeel.sketchedIcon("Computer"), "FileView.hardDriveIcon", NapkinLookAndFeel.sketchedIcon("HardDrive"), "FileView.floppyDriveIcon", NapkinLookAndFeel.sketchedIcon("FloppyDrive"), "OptionPane.errorIcon", NapkinLookAndFeel.sketchedIcon("Error"), "OptionPane.informationIcon", NapkinLookAndFeel.sketchedIcon("Information"), "OptionPane.warningIcon", NapkinLookAndFeel.sketchedIcon("Warning"), "OptionPane.questionIcon", NapkinLookAndFeel.sketchedIcon("Question")};
        table.putDefaults(napkinDefaults);
    }

    private static Object sketchedIcon(final String templateName) {
        return new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return NapkinIconFactory.createSketchedIcon(templateName);
            }
        };
    }

    private static void setupActions(UIDefaults table) {
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        Object[] actionDefaults = new Object[]{"TextField.focusInputMap", fieldInputMap, "PasswordField.focusInputMap", fieldInputMap, "TextArea.focusInputMap", multilineInputMap, "TextPane.focusInputMap", multilineInputMap, "EditorPane.focusInputMap", multilineInputMap};
        table.putDefaults(actionDefaults);
    }

    private static void overrideComponentDefaults(UIDefaults table) {
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        Map<String, Font> fontMap = NapkinLookAndFeel.fontNameMap(theme);
        UIDefaults.ActiveValue drawnBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new NapkinBoxBorder();
            }
        };
        UIDefaults.ActiveValue compoundBorder = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                NapkinBoxBorder outside = new NapkinBoxBorder();
                BasicBorders.MarginBorder inside = new BasicBorders.MarginBorder();
                return new CompoundBorder(outside, inside);
            }
        };
        AlphaColorUIResource clear = new AlphaColorUIResource(NapkinConstants.CLEAR);
        for (Map.Entry entry : table.entrySet()) {
            Object val;
            String key = (String)entry.getKey();
            Object res = NapkinLookAndFeel.propVal(key, "font", val = entry.getValue(), table);
            if (res != null) {
                if (!(res instanceof FontUIResource)) continue;
                FontUIResource resource = (FontUIResource)res;
                String name = resource.getFontName();
                Font font = fontMap.get(name);
                if (font != null) {
                    entry.setValue(font);
                    continue;
                }
                System.err.println("unknown font: " + name + " for " + key);
                continue;
            }
            res = NapkinLookAndFeel.propVal(key, "border", val, table);
            if (res != null) {
                if (!(res instanceof UIResource) && (!(val instanceof UIResource) || !(res instanceof BevelBorder) && !(res instanceof EtchedBorder) && !(res instanceof LineBorder) && !(res instanceof CompoundBorder))) continue;
                if (!(res instanceof CompoundBorder)) {
                    entry.setValue(drawnBorder);
                    continue;
                }
                entry.setValue(compoundBorder);
                continue;
            }
            if (key.contains("Text") || key.startsWith("Password") || key.startsWith("Editor")) continue;
            if (key.endsWith(".foreground") || key.endsWith("BorderColor") || key.endsWith(".caretForeground") || key.endsWith(".acceleratorForeground") || key.endsWith(".disabledForeground") || key.endsWith(".inactiveForeground") || key.endsWith(".inactiveTitleForeground") || key.endsWith(".textForeground")) {
                entry.setValue(theme.getPenColor());
                continue;
            }
            if (key.endsWith(".background") || key.endsWith(".selectionBackground") || key.endsWith(".textBackground")) {
                entry.setValue(clear);
                continue;
            }
            if (!key.endsWith(".selectionForeground") && !key.endsWith(".activeTitleForeground") && !key.endsWith("SelectionForeground")) continue;
            entry.setValue(theme.getSelectionColor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Font> fontNameMap(NapkinTheme theme) {
        Font dialogPlain = theme.getTextFont();
        Font dialogBold = theme.getBoldTextFont();
        Font serifPlain = theme.getTextFont();
        Font sansSerifPlain = theme.getTextFont();
        Font monospacedPlain = theme.getFixedFont();
        HashMap<String, Font> fromName = new HashMap<String, Font>();
        fromName.put("dialogBold", dialogBold);
        fromName.put("dialogPlain", dialogPlain);
        fromName.put("monospacedPlain", monospacedPlain);
        fromName.put("sansSerifPlain", sansSerifPlain);
        fromName.put("serifPlain", serifPlain);
        fromName.put("Dialog.plain", dialogPlain);
        fromName.put("Dialog.bold", dialogBold);
        fromName.put("Serif.plain", serifPlain);
        fromName.put("SansSerif.plain", sansSerifPlain);
        fromName.put("MonoSpaced.plain", monospacedPlain);
        fromName.put("Monospaced.plain", monospacedPlain);
        InputStream fonts = NapkinLookAndFeel.class.getResourceAsStream("resources/fonts.properties");
        if (fonts != null) {
            try {
                Properties props = new Properties();
                props.load(fonts);
                fonts.close();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String fontName = (String)entry.getKey();
                    Font font = (Font)fromName.get(entry.getValue());
                    if (font == null) {
                        System.err.println("unknown font: " + fontName);
                        continue;
                    }
                    fromName.put(fontName, font);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                NapkinUtil.tryClose(fonts);
            }
        }
        return fromName;
    }

    private static Object propVal(String key, String prop, Object val, UIDefaults table) {
        int propLen;
        int keyLen = key.length();
        int prePos = keyLen - (propLen = prop.length()) - 1;
        if (prePos <= 0) {
            return null;
        }
        boolean match = false;
        if (key.endsWith(prop) && key.charAt(prePos) == '.') {
            match = true;
        } else if (key.endsWith(prop.substring(1)) && key.charAt(prePos + 1) == Character.toUpperCase(prop.charAt(0))) {
            match = true;
        }
        if (!match) {
            return null;
        }
        return NapkinLookAndFeel.extractVal(val, table);
    }

    private static Object extractVal(Object val, UIDefaults table) {
        if (val instanceof UIDefaults.LazyValue) {
            val = ((UIDefaults.LazyValue)val).createValue(table);
        } else if (val instanceof UIDefaults.ActiveValue) {
            val = ((UIDefaults.ActiveValue)val).createValue(table);
        }
        return val;
    }

    static class DumpVisitor
    implements ComponentWalker.Visitor {
        private final PrintStream out;

        DumpVisitor(PrintStream out) {
            this.out = out;
        }

        public boolean visit(Component c, int depth) {
            for (int i = 0; i < depth; ++i) {
                this.out.print(i % 2 == 0 ? (char)'|' : '.');
                this.out.print(' ');
            }
            String desc = NapkinDebug.descFor(c);
            this.out.print(desc);
            this.out.print(": ");
            this.out.print(c.isOpaque());
            this.out.println();
            return true;
        }
    }
}

