/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;

public class SubstanceColorUtilities {
    public static Color getTopBorderColor(SubstanceColorScheme scheme1, SubstanceColorScheme scheme2, double cycleCoef) {
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getUltraDarkColor(), scheme2.getUltraDarkColor(), cycleCoef);
    }

    public static Color getMidBorderColor(SubstanceColorScheme scheme1, SubstanceColorScheme scheme2, double cycleCoef) {
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getDarkColor(), scheme2.getDarkColor(), cycleCoef);
    }

    public static Color getBottomBorderColor(SubstanceColorScheme scheme1, SubstanceColorScheme scheme2, double cycleCoef) {
        Color c1 = SubstanceColorUtilities.getInterpolatedColor(scheme1.getDarkColor(), scheme1.getMidColor(), 0.5);
        Color c2 = SubstanceColorUtilities.getInterpolatedColor(scheme2.getDarkColor(), scheme2.getMidColor(), 0.5);
        return SubstanceColorUtilities.getInterpolatedColor(c1, c2, cycleCoef);
    }

    public static Color getTopFillColor(SubstanceColorScheme scheme1, SubstanceColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        if (!useCyclePosAsInterpolation) {
            Color c = SubstanceColorUtilities.getInterpolatedColor(scheme1.getDarkColor(), scheme1.getMidColor(), 0.4);
            return SubstanceColorUtilities.getInterpolatedColor(c, scheme2.getLightColor(), cycleCoef);
        }
        Color c1 = SubstanceColorUtilities.getInterpolatedColor(scheme1.getDarkColor(), scheme1.getMidColor(), 0.4);
        Color c2 = SubstanceColorUtilities.getInterpolatedColor(scheme2.getDarkColor(), scheme2.getMidColor(), 0.4);
        return SubstanceColorUtilities.getInterpolatedColor(c1, c2, cycleCoef);
    }

    public static Color getMidFillColor(SubstanceColorScheme scheme1, SubstanceColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        if (!useCyclePosAsInterpolation) {
            return SubstanceColorUtilities.getInterpolatedColor(scheme1.getMidColor(), scheme2.getLightColor(), cycleCoef);
        }
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getMidColor(), scheme2.getMidColor(), cycleCoef);
    }

    public static Color getBottomFillColor(SubstanceColorScheme scheme1, SubstanceColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        if (!useCyclePosAsInterpolation) {
            return SubstanceColorUtilities.getInterpolatedColor(scheme1.getUltraLightColor(), scheme2.getExtraLightColor(), cycleCoef);
        }
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getUltraLightColor(), scheme2.getUltraLightColor(), cycleCoef);
    }

    public static Color getTopShineColor(SubstanceColorScheme scheme1, SubstanceColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return SubstanceColorUtilities.getBottomFillColor(scheme1, scheme2, cycleCoef, useCyclePosAsInterpolation);
    }

    public static Color getBottomShineColor(SubstanceColorScheme scheme1, SubstanceColorScheme scheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        if (!useCyclePosAsInterpolation) {
            return SubstanceColorUtilities.getInterpolatedColor(scheme1.getLightColor(), scheme2.getUltraLightColor(), cycleCoef);
        }
        return SubstanceColorUtilities.getInterpolatedColor(scheme1.getLightColor(), scheme2.getLightColor(), cycleCoef);
    }

    public static int getInterpolatedRGB(Color color1, Color color2, double color1Likeness) {
        if (color1Likeness < 0.0 || color1Likeness > 1.0) {
            throw new IllegalArgumentException("Color likeness should be in 0.0-1.0 range [is " + color1Likeness + "]");
        }
        int lr = color1.getRed();
        int lg = color1.getGreen();
        int lb = color1.getBlue();
        int la = color1.getAlpha();
        int dr = color2.getRed();
        int dg = color2.getGreen();
        int db = color2.getBlue();
        int da = color2.getAlpha();
        int r = (int)(color1Likeness * (double)lr + (1.0 - color1Likeness) * (double)dr);
        int g = (int)(color1Likeness * (double)lg + (1.0 - color1Likeness) * (double)dg);
        int b = (int)(color1Likeness * (double)lb + (1.0 - color1Likeness) * (double)db);
        int a = (int)(color1Likeness * (double)la + (1.0 - color1Likeness) * (double)da);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static Color getInterpolatedColor(Color color1, Color color2, double color1Likeness) {
        if (color1.equals(color2)) {
            return color1;
        }
        if (color1Likeness == 1.0) {
            return color1;
        }
        if (color1Likeness == 0.0) {
            return color2;
        }
        return new Color(SubstanceColorUtilities.getInterpolatedRGB(color1, color2, color1Likeness), true);
    }

    public static Color invertColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static Color getNegativeColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static int getNegativeColor(int rgb) {
        int transp = rgb >>> 24 & 0xFF;
        int r = rgb >>> 16 & 0xFF;
        int g = rgb >>> 8 & 0xFF;
        int b = rgb >>> 0 & 0xFF;
        return transp << 24 | 255 - r << 16 | 255 - g << 8 | 255 - b;
    }

    public static Color getAlphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color getSaturatedColor(Color color, double factor) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        float sat = hsbvals[1];
        sat = factor > 0.0 ? (sat += (float)factor * (1.0f - sat)) : (sat += (float)factor * sat);
        return new Color(Color.HSBtoRGB(hsbvals[0], sat, hsbvals[2]));
    }

    public static Color getHueShiftedColor(Color color, double hueShift) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        float hue = hsbvals[0];
        hue = (float)((double)hue + hueShift);
        if ((double)hue < 0.0) {
            hue = (float)((double)hue + 1.0);
        }
        if ((double)hue > 1.0) {
            hue = (float)((double)hue - 1.0);
        }
        return new Color(Color.HSBtoRGB(hue, hsbvals[1], hsbvals[2]));
    }

    public static Color deriveByBrightness(Color original, Color brightnessSource) {
        float[] hsbvalsOrig = new float[3];
        Color.RGBtoHSB(original.getRed(), original.getGreen(), original.getBlue(), hsbvalsOrig);
        float[] hsbvalsBrightnessSrc = new float[3];
        Color.RGBtoHSB(brightnessSource.getRed(), brightnessSource.getGreen(), brightnessSource.getBlue(), hsbvalsBrightnessSrc);
        return new Color(Color.HSBtoRGB(hsbvalsOrig[0], hsbvalsOrig[1], (hsbvalsBrightnessSrc[2] + hsbvalsOrig[2]) / 2.0f));
    }

    public static ColorUIResource getForegroundColor(SubstanceColorScheme scheme) {
        return new ColorUIResource(scheme.getForegroundColor());
    }

    public static Color getLighterColor(Color color, double diff) {
        int r = color.getRed() + (int)(diff * (double)(255 - color.getRed()));
        int g = color.getGreen() + (int)(diff * (double)(255 - color.getGreen()));
        int b = color.getBlue() + (int)(diff * (double)(255 - color.getBlue()));
        return new Color(r, g, b);
    }

    public static Color getDarkerColor(Color color, double diff) {
        int r = (int)((1.0 - diff) * (double)color.getRed());
        int g = (int)((1.0 - diff) * (double)color.getGreen());
        int b = (int)((1.0 - diff) * (double)color.getBlue());
        return new Color(r, g, b);
    }

    public static int getColorBrightness(int rgb) {
        int oldR = rgb >>> 16 & 0xFF;
        int oldG = rgb >>> 8 & 0xFF;
        int oldB = rgb >>> 0 & 0xFF;
        return (222 * oldR + 707 * oldG + 71 * oldB) / 1000;
    }

    public static Color getFocusColor(Component comp) {
        SubstanceColorScheme activeScheme = SubstanceColorSchemeUtilities.getColorScheme(comp, ComponentState.ACTIVE);
        if (comp instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)comp;
            ButtonModel model = ab.getModel();
            ComponentState currState = ComponentState.getState(model, ab);
            SubstanceColorScheme currScheme = SubstanceColorSchemeUtilities.getColorScheme(comp, currState);
            Color currColor = currScheme.getFocusRingColor();
            FadeState fadeState = SubstanceFadeUtilities.getFadeState(comp, FadeKind.PRESS, FadeKind.SELECTION, FadeKind.ROLLOVER);
            if (fadeState != null) {
                ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(ab);
                SubstanceColorScheme prevScheme = SubstanceColorSchemeUtilities.getColorScheme(comp, prevState);
                Color prevColor = prevScheme.getFocusRingColor();
                float likeness = fadeState.getFadePosition();
                if (fadeState.isFadingIn()) {
                    likeness = 1.0f - likeness;
                }
                return SubstanceColorUtilities.getInterpolatedColor(prevColor, currColor, likeness);
            }
            return currColor;
        }
        Color color = activeScheme.getFocusRingColor();
        return color;
    }

    public static float getColorStrength(Color color) {
        return (float)Math.max(SubstanceColorUtilities.getColorBrightness(color.getRGB()), SubstanceColorUtilities.getColorBrightness(SubstanceColorUtilities.getNegativeColor(color.getRGB()))) / 255.0f;
    }

    public static Color getMarkColor(SubstanceColorScheme colorScheme, boolean isEnabled) {
        if (colorScheme.isDark()) {
            if (!isEnabled) {
                return colorScheme.getDarkColor();
            }
            return SubstanceColorUtilities.getInterpolatedColor(colorScheme.getForegroundColor(), colorScheme.getUltraLightColor(), 0.9);
        }
        Color color1 = isEnabled ? colorScheme.getUltraDarkColor() : colorScheme.getUltraDarkColor();
        Color color2 = isEnabled ? colorScheme.getDarkColor() : colorScheme.getLightColor();
        return SubstanceColorUtilities.getInterpolatedColor(color1, color2, 0.9);
    }

    public static Color getForegroundColor(Component component, ComponentState state, ComponentState prevState) {
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, state);
        if (component instanceof JMenuItem) {
            return SubstanceColorUtilities.getInterpolatedForegroundColor(component, null, colorScheme, state, prevState, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS, FadeKind.ARM);
        }
        return SubstanceColorUtilities.getInterpolatedForegroundColor(component, null, colorScheme, state, prevState, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS);
    }

    public static Color getForegroundColor(JTabbedPane tabPane, int tabIndex, ComponentState state, ComponentState prevState) {
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(tabPane, tabIndex, state);
        return SubstanceColorUtilities.getInterpolatedForegroundColor(tabPane, Integer.valueOf(tabIndex), colorScheme, state, prevState, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS);
    }

    public static Color getInterpolatedForegroundColor(Component comp, Comparable<?> componentId, SubstanceColorScheme colorScheme, ComponentState state, ComponentState prevState, FadeKind ... kinds) {
        SubstanceColorScheme colorScheme2 = colorScheme;
        float cyclePos = state.getCyclePosition();
        FadeState fadeState = SubstanceFadeUtilities.getFadeState(comp, componentId, kinds);
        if (fadeState != null) {
            colorScheme = comp instanceof JTabbedPane ? SubstanceColorSchemeUtilities.getColorScheme((JTabbedPane)comp, (Integer)componentId, state) : SubstanceColorSchemeUtilities.getColorScheme(comp, state);
            colorScheme2 = comp instanceof JTabbedPane ? SubstanceColorSchemeUtilities.getColorScheme((JTabbedPane)comp, (Integer)componentId, prevState) : SubstanceColorSchemeUtilities.getColorScheme(comp, prevState);
            cyclePos = fadeState.getFadePosition();
            if (!fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
        }
        Color c1 = colorScheme.getForegroundColor();
        Color c2 = colorScheme2.getForegroundColor();
        return SubstanceColorUtilities.getInterpolatedColor(c1, c2, cyclePos);
    }

    public static Color getBackgroundFillColor(Component component) {
        if (component instanceof JCheckBox || component instanceof JRadioButton || component instanceof JSlider) {
            component = component.getParent();
        } else if (component instanceof JTextComponent && !component.isOpaque()) {
            component = component.getParent();
        }
        Color backgr = component.getBackground();
        if (SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null) {
            return backgr;
        }
        boolean isBackgroundUiResource = backgr instanceof UIResource;
        if (!isBackgroundUiResource) {
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(component, component.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
            backgr = scheme.getBackgroundFillColor();
        } else {
            ComponentState state;
            ComponentState componentState = state = component.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED;
            if (component instanceof JTextComponent && !((JTextComponent)component).isEditable()) {
                state = ComponentState.DISABLED_UNSELECTED;
            }
            if (component instanceof JMenuItem) {
                state = ComponentState.DEFAULT;
            }
            backgr = SubstanceColorUtilities.getDefaultBackgroundColor(component, state);
        }
        return backgr;
    }

    public static ColorUIResource getDefaultBackgroundColor(Class componentClass, SubstanceSkin skin, boolean isDisabled) {
        boolean useLightBackgroundColor;
        boolean bl = useLightBackgroundColor = JTextComponent.class.isAssignableFrom(componentClass) || JComboBox.class.isAssignableFrom(componentClass) || JSpinner.class.isAssignableFrom(componentClass);
        if (useLightBackgroundColor || isDisabled) {
            return new ColorUIResource(skin.getMainDefaultColorScheme().getLightBackgroundFillColor());
        }
        return new ColorUIResource(skin.getMainDefaultColorScheme().getBackgroundFillColor());
    }

    public static ColorUIResource getDefaultBackgroundColor(Component comp, ComponentState compState) {
        if (comp instanceof JTextComponent || comp instanceof JComboBox || comp instanceof JSpinner) {
            return new ColorUIResource(SubstanceColorSchemeUtilities.getColorScheme(comp, compState).getLightBackgroundFillColor());
        }
        return new ColorUIResource(SubstanceColorSchemeUtilities.getColorScheme(comp, compState).getBackgroundFillColor());
    }

    public static Color getStripedBackground(JComponent component, int rowIndex) {
        Color backgr = SubstanceColorUtilities.getBackgroundFillColor(component);
        if (backgr == null) {
            return null;
        }
        if (rowIndex % 2 == 0) {
            return backgr;
        }
        int r = backgr.getRed();
        int g = backgr.getGreen();
        int b = backgr.getBlue();
        double coef = 0.96;
        if (!component.isEnabled()) {
            coef = 1.0 - (1.0 - coef) / 2.0;
        }
        ColorUIResource darkerColor = new ColorUIResource((int)(coef * (double)r), (int)(coef * (double)g), (int)(coef * (double)b));
        return darkerColor;
    }
}

