/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.colorscheme.CharcoalColorScheme;
import org.jvnet.substance.colorscheme.ShadeColorScheme;
import org.jvnet.substance.colorscheme.ShiftColorScheme;
import org.jvnet.substance.colorscheme.SunsetColorScheme;
import org.jvnet.substance.painter.border.GlassBorderPainter;
import org.jvnet.substance.painter.decoration.ArcDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.gradient.GlassGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.shaper.ClassicButtonShaper;
import org.jvnet.substance.watermark.SubstancePlanktonWatermark;

public class MagmaSkin
extends SubstanceSkin {
    public static final String NAME = "Magma";

    public MagmaSkin() {
        ShiftColorScheme shiftRed = new ShiftColorScheme(new SunsetColorScheme(), Color.red, 0.3);
        CharcoalColorScheme defaultScheme = new CharcoalColorScheme();
        SubstanceColorScheme activeScheme = shiftRed.saturate(0.4);
        ShadeColorScheme disabledScheme = new ShadeColorScheme(new CharcoalColorScheme(), 0.5){
            Color foreColor;
            {
                this.foreColor = new Color(104, 93, 90);
            }

            @Override
            public Color getForegroundColor() {
                return this.foreColor;
            }
        };
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, disabledScheme);
        defaultSchemeBundle.registerBorderColorScheme(new CharcoalColorScheme(), ComponentState.getActiveStates());
        defaultSchemeBundle.registerColorScheme((SubstanceColorScheme)disabledScheme, 0.7f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(activeScheme.saturate(-0.2), 0.7f, ComponentState.ROLLOVER_UNSELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(activeScheme, 0.7f, ComponentState.SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(activeScheme, 0.9f, ComponentState.ROLLOVER_SELECTED);
        defaultSchemeBundle.registerHighlightColorScheme(activeScheme.saturate(-0.2), 0.7f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, DecorationAreaType.NONE);
        this.registerAsDecorationArea(defaultScheme, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.FOOTER, DecorationAreaType.GENERAL, DecorationAreaType.TOOLBAR);
        this.setSelectedTabFadeStart(1.0);
        this.setSelectedTabFadeEnd(1.0);
        this.watermarkScheme = defaultScheme.shade(0.5);
        this.buttonShaper = new ClassicButtonShaper();
        this.gradientPainter = new GlassGradientPainter();
        this.decorationPainter = new ArcDecorationPainter();
        this.watermark = new SubstancePlanktonWatermark();
        this.borderPainter = new GlassBorderPainter();
        this.highlightPainter = new ClassicHighlightPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

