/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.table.JTableHeader;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.api.ColorSchemeTransform;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceApi;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.renderers.SubstanceDefaultListCellRenderer;
import org.jvnet.substance.api.trait.SubstanceTrait;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.painter.decoration.SubstanceDecorationUtilities;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.painter.highlight.SubstanceHighlightPainter;
import org.jvnet.substance.shaper.SubstanceButtonShaper;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.border.SubstanceBorder;
import org.jvnet.substance.utils.border.SubstanceEtchedBorder;
import org.jvnet.substance.utils.border.SubstancePaneBorder;
import org.jvnet.substance.utils.border.SubstanceToolBarBorder;
import org.jvnet.substance.utils.icon.CheckBoxMenuItemIcon;
import org.jvnet.substance.utils.icon.MenuArrowIcon;
import org.jvnet.substance.utils.icon.RadioButtonMenuItemIcon;
import org.jvnet.substance.utils.icon.SubstanceIconFactory;
import org.jvnet.substance.utils.scroll.SubstanceScrollPaneBorder;
import org.jvnet.substance.watermark.SubstanceWatermark;

@SubstanceApi
public abstract class SubstanceSkin
implements SubstanceTrait,
Cloneable {
    protected Map<DecorationAreaType, SubstanceColorSchemeBundle> colorSchemeBundleMap = new EnumMap<DecorationAreaType, SubstanceColorSchemeBundle>(DecorationAreaType.class);
    protected Map<DecorationAreaType, SubstanceColorScheme> backgroundColorSchemeMap = new EnumMap<DecorationAreaType, SubstanceColorScheme>(DecorationAreaType.class);
    protected SubstanceWatermark watermark;
    protected SubstanceButtonShaper buttonShaper;
    protected SubstanceGradientPainter gradientPainter;
    protected SubstanceBorderPainter borderPainter;
    protected SubstanceHighlightPainter highlightPainter;
    protected SubstanceDecorationPainter decorationPainter;
    protected Set<DecorationAreaType> decoratedAreaSet = EnumSet.of(DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE);
    protected double selectedTabFadeStart = 0.1;
    protected double selectedTabFadeEnd = 0.3;
    protected Set<DecorationAreaType> dropShadowsSet = EnumSet.noneOf(DecorationAreaType.class);
    protected SubstanceColorScheme watermarkScheme;

    protected SubstanceSkin() {
    }

    public SubstanceColorScheme getMainActiveColorScheme() {
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getActiveColorScheme();
    }

    public SubstanceColorScheme getMainDefaultColorScheme() {
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getDefaultColorScheme();
    }

    public SubstanceColorScheme getMainDisabledColorScheme() {
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getDisabledColorScheme();
    }

    public SubstanceWatermark getWatermark() {
        return this.watermark;
    }

    public SubstanceBorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    public SubstanceButtonShaper getButtonShaper() {
        return this.buttonShaper;
    }

    public SubstanceGradientPainter getGradientPainter() {
        return this.gradientPainter;
    }

    public SubstanceHighlightPainter getHighlightPainter() {
        return this.highlightPainter;
    }

    public SubstanceDecorationPainter getDecorationPainter() {
        return this.decorationPainter;
    }

    public void addCustomEntriesToTable(UIDefaults table) {
        if (table == null) {
            return;
        }
        UIDefaults.LazyValue menuArrowIcon = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new MenuArrowIcon(null);
            }
        };
        UIDefaults.ActiveValue listCellRendererActiveValue = new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new SubstanceDefaultListCellRenderer.SubstanceUIResource();
            }
        };
        SubstanceColorScheme mainActiveScheme = this.getMainActiveColorScheme();
        SubstanceColorScheme mainDefaultScheme = this.getMainDefaultColorScheme();
        SubstanceColorScheme mainDisabledScheme = this.getMainDisabledColorScheme();
        ColorUIResource controlText = new ColorUIResource(mainActiveScheme.getLightColor());
        ColorUIResource foregroundColor = SubstanceColorUtilities.getForegroundColor(mainDefaultScheme);
        ColorUIResource backgroundActiveColor = new ColorUIResource(mainActiveScheme.getBackgroundFillColor());
        ColorUIResource backgroundDefaultColor = new ColorUIResource(mainDefaultScheme.getBackgroundFillColor());
        ColorUIResource backgroundLightColor = new ColorUIResource(mainActiveScheme.getLightBackgroundFillColor());
        ColorUIResource disabledForegroundColor = SubstanceColorUtilities.getForegroundColor(mainDisabledScheme);
        ColorUIResource lineColor = new ColorUIResource(mainActiveScheme.getLineColor());
        ColorUIResource lineColorDefault = new ColorUIResource(mainDefaultScheme.getLineColor());
        int lcb = SubstanceColorUtilities.getColorBrightness(lineColor.getRGB());
        ColorUIResource lineBwColor = new ColorUIResource(new Color(lcb, lcb, lcb));
        ColorUIResource selectionBackgroundColor = new ColorUIResource(this.getHighlightColorScheme(null, ComponentState.ACTIVE).getSelectionBackgroundColor());
        ColorUIResource selectionForegroundColor = new ColorUIResource(mainActiveScheme.getSelectionForegroundColor());
        ColorUIResource selectionCellForegroundColor = new ColorUIResource(this.getHighlightColorScheme(null, ComponentState.SELECTED).getForegroundColor());
        UIDefaults.LazyValue regularMarginBorder = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(), new BasicBorders.MarginBorder());
            }
        };
        UIDefaults.LazyValue textBorder = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getControlFontSize())), new BasicBorders.MarginBorder());
            }
        };
        UIDefaults.LazyValue tooltipBorder = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new SubstanceBorder(SubstanceSizeUtils.getToolTipBorderInsets(SubstanceSizeUtils.getControlFontSize()));
            }
        };
        UIDefaults.LazyValue comboBorder = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new SubstanceBorder(SubstanceSizeUtils.getComboBorderInsets(SubstanceSizeUtils.getControlFontSize()));
            }
        };
        UIDefaults.LazyValue spinnerBorder = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getSpinnerBorderInsets(SubstanceSizeUtils.getControlFontSize())), new BasicBorders.MarginBorder());
            }
        };
        SubstanceColorSchemeBundle titlePaneBundle = this.colorSchemeBundleMap.containsKey((Object)DecorationAreaType.PRIMARY_TITLE_PANE) ? this.colorSchemeBundleMap.get((Object)DecorationAreaType.PRIMARY_TITLE_PANE) : this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE);
        final SubstanceColorScheme titlePaneScheme = titlePaneBundle.getActiveColorScheme();
        UIDefaults.LazyValue menuItemInsets = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                int menuItemMargin = SubstanceSizeUtils.getMenuItemMargin(SubstanceSizeUtils.getComponentFontSize(null));
                return new InsetsUIResource(menuItemMargin, menuItemMargin, menuItemMargin, menuItemMargin);
            }
        };
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap passwordInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-begin-line", "ctrl KP_LEFT", "caret-begin-line", "ctrl RIGHT", "caret-end-line", "ctrl KP_RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "ctrl shift KP_LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "ctrl shift KP_RIGHT", "selection-end-line", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyValue emptyIcon = new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new IconUIResource(new Icon(){

                    @Override
                    public int getIconHeight() {
                        return 2;
                    }

                    @Override
                    public int getIconWidth() {
                        return 2;
                    }

                    @Override
                    public void paintIcon(Component c, Graphics g, int x, int y) {
                    }
                });
            }
        };
        Object[] defaults = new Object[]{"control", controlText, "TextField.focusInputMap", fieldInputMap, "PasswordField.focusInputMap", passwordInputMap, "TextArea.focusInputMap", multilineInputMap, "TextPane.focusInputMap", multilineInputMap, "EditorPane.focusInputMap", multilineInputMap, "Button.defaultButtonFollowsFocus", Boolean.FALSE, "Button.disabledText", disabledForegroundColor, "Button.foreground", foregroundColor, "Button.margin", new InsetsUIResource(0, 0, 0, 0), "CheckBox.background", SubstanceColorUtilities.getDefaultBackgroundColor(JCheckBox.class, this, false), "CheckBox.border", new BorderUIResource.CompoundBorderUIResource(SubstanceSizeUtils.getCheckBoxBorder(SubstanceSizeUtils.getControlFontSize()), new BasicBorders.MarginBorder()), "CheckBox.disabledText", disabledForegroundColor, "CheckBox.foreground", foregroundColor, "CheckBoxMenuItem.acceleratorForeground", foregroundColor, "CheckBoxMenuItem.acceleratorSelectionForeground", foregroundColor, "CheckBoxMenuItem.background", SubstanceColorUtilities.getDefaultBackgroundColor(JCheckBoxMenuItem.class, this, false), "CheckBoxMenuItem.borderPainted", Boolean.FALSE, "CheckBoxMenuItem.checkIcon", new CheckBoxMenuItemIcon(null, 1 + SubstanceSizeUtils.getMenuCheckMarkSize(SubstanceSizeUtils.getControlFontSize())), "CheckBoxMenuItem.disabledForeground", disabledForegroundColor, "CheckBoxMenuItem.foreground", foregroundColor, "CheckBoxMenuItem.margin", menuItemInsets, "CheckBoxMenuItem.selectionForeground", selectionCellForegroundColor, "ColorChooser.background", SubstanceColorUtilities.getDefaultBackgroundColor(JColorChooser.class, this, false), "ColorChooser.foreground", foregroundColor, "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}), "ComboBox.background", SubstanceColorUtilities.getDefaultBackgroundColor(JComboBox.class, this, false), "ComboBox.border", comboBorder, "ComboBox.disabledBackground", backgroundLightColor, "ComboBox.disabledForeground", disabledForegroundColor, "ComboBox.foreground", foregroundColor, "ComboBox.selectionBackground", backgroundLightColor, "ComboBox.selectionForeground", foregroundColor, "DesktopIcon.border", regularMarginBorder, "DesktopIcon.width", new Integer(140), "Desktop.background", new ColorUIResource(new Color(0, true)), "Desktop.foreground", foregroundColor, "Dialog.background", SubstanceColorUtilities.getDefaultBackgroundColor(JDialog.class, this, false), "EditorPane.background", SubstanceColorUtilities.getDefaultBackgroundColor(JEditorPane.class, this, false), "EditorPane.border", textBorder, "EditorPane.foreground", foregroundColor, "EditorPane.caretForeground", foregroundColor, "EditorPane.disabledBackground", SubstanceColorUtilities.getDefaultBackgroundColor(JEditorPane.class, this, true), "EditorPane.inactiveBackground", SubstanceColorUtilities.getDefaultBackgroundColor(JEditorPane.class, this, true), "EditorPane.inactiveForeground", disabledForegroundColor, "EditorPane.selectionBackground", selectionBackgroundColor, "EditorPane.selectionForeground", selectionForegroundColor, "FileChooser.upFolderIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/go-up.png");
            }
        }, "FileChooser.newFolderIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/folder-new.png");
            }
        }, "FileChooser.homeFolderIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/user-home.png");
            }
        }, "FileChooser.listViewIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/application_view_list.png");
            }
        }, "FileChooser.detailsViewIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/application_view_detail.png");
            }
        }, "FileChooser.viewMenuLabelText", "View", "FileChooser.refreshActionLabelText", "Refresh", "FileChooser.newFolderActionLabelText", "New Folder", "FileChooser.listViewActionLabelText", "List", "FileChooser.detailsViewActionLabelText", "Details", "FileChooser.lookInLabelMnemonic", new Integer(73), "FileChooser.fileNameLabelMnemonic", new Integer(78), "FileChooser.filesOfTypeLabelMnemonic", new Integer(84), "FileChooser.usesSingleFilePane", Boolean.TRUE, "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "F2", "editFileName", "F5", "refresh", "BACK_SPACE", "Go Up", "ENTER", "approveSelection"}), "FileView.computerIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/computer.png");
            }
        }, "FileView.directoryIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/folder.png");
            }
        }, "FileView.fileIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/text-x-generic.png");
            }
        }, "FileView.floppyDriveIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/media-floppy.png");
            }
        }, "FileView.hardDriveIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/drive-harddisk.png");
            }
        }, "FormattedTextField.background", SubstanceColorUtilities.getDefaultBackgroundColor(JFormattedTextField.class, this, false), "FormattedTextField.border", textBorder, "FormattedTextField.caretForeground", foregroundColor, "FormattedTextField.disabledBackground", SubstanceColorUtilities.getDefaultBackgroundColor(JFormattedTextField.class, this, true), "FormattedTextField.foreground", foregroundColor, "FormattedTextField.inactiveBackground", SubstanceColorUtilities.getDefaultBackgroundColor(JFormattedTextField.class, this, true), "FormattedTextField.inactiveForeground", disabledForegroundColor, "FormattedTextField.selectionBackground", selectionBackgroundColor, "FormattedTextField.selectionForeground", selectionForegroundColor, "InternalFrame.activeTitleBackground", selectionForegroundColor, "InternalFrame.inactiveTitleBackground", foregroundColor, "InternalFrame.border", new BorderUIResource(new SubstancePaneBorder()), "InternalFrame.closeIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getCloseIcon(titlePaneScheme);
            }
        }, "InternalFrame.iconifyIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getMinimizeIcon(titlePaneScheme);
            }
        }, "InternalFrame.maximizeIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getMaximizeIcon(titlePaneScheme);
            }
        }, "InternalFrame.minimizeIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getRestoreIcon(titlePaneScheme);
            }
        }, "InternalFrame.paletteCloseIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceImageCreator.getCloseIcon(titlePaneScheme);
            }
        }, "Label.background", SubstanceColorUtilities.getDefaultBackgroundColor(JLabel.class, this, false), "Label.foreground", foregroundColor, "Label.disabledText", disabledForegroundColor, "Label.disabledForeground", disabledForegroundColor, "List.background", SubstanceColorUtilities.getDefaultBackgroundColor(JList.class, this, false), "List.cellRenderer", listCellRendererActiveValue, "List.focusCellHighlightBorder", new SubstanceBorder(new Insets(1, 1, 1, 1)), "List.focusSelectedCellHighlightBorder", new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1), "List.foreground", foregroundColor, "List.selectionBackground", new ColorUIResource(this.getHighlightColorScheme(null, ComponentState.SELECTED).getLightColor()), "List.selectionForeground", selectionCellForegroundColor, "Menu.arrowIcon", menuArrowIcon, "Menu.background", SubstanceColorUtilities.getDefaultBackgroundColor(JMenu.class, this, false), "Menu.borderPainted", Boolean.FALSE, "Menu.checkIcon", null, "Menu.disabledForeground", disabledForegroundColor, "Menu.foreground", foregroundColor, "Menu.margin", menuItemInsets, "Menu.selectionForeground", selectionCellForegroundColor, "MenuBar.background", this.isRegisteredAsDecorationArea(DecorationAreaType.HEADER) ? new ColorUIResource(this.getMainActiveColorScheme(DecorationAreaType.HEADER).getMidColor()) : SubstanceColorUtilities.getDefaultBackgroundColor(JMenuBar.class, this, false), "MenuBar.foreground", new ColorUIResource(this.getMainActiveColorScheme(DecorationAreaType.HEADER).getForegroundColor()), "MenuBar.border", null, "MenuItem.acceleratorForeground", foregroundColor, "MenuItem.acceleratorSelectionForeground", foregroundColor, "MenuItem.background", SubstanceColorUtilities.getDefaultBackgroundColor(JMenuItem.class, this, false), "MenuItem.borderPainted", Boolean.FALSE, "MenuItem.checkIcon", null, "MenuItem.disabledForeground", disabledForegroundColor, "MenuItem.foreground", foregroundColor, "MenuItem.margin", menuItemInsets, "MenuItem.selectionForeground", selectionCellForegroundColor, "OptionPane.background", SubstanceColorUtilities.getDefaultBackgroundColor(JOptionPane.class, this, false), "OptionPane.errorIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-error.png");
            }
        }, "OptionPane.foreground", foregroundColor, "OptionPane.informationIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-information.png");
            }
        }, "OptionPane.messageForeground", foregroundColor, "OptionPane.questionIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/32/help-browser.png");
            }
        }, "OptionPane.warningIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-warning.png");
            }
        }, "Panel.background", SubstanceColorUtilities.getDefaultBackgroundColor(JPanel.class, this, false), "Panel.foreground", foregroundColor, "PasswordField.background", SubstanceColorUtilities.getDefaultBackgroundColor(JPasswordField.class, this, false), "PasswordField.border", textBorder, "PasswordField.caretForeground", foregroundColor, "PasswordField.disabledBackground", SubstanceColorUtilities.getDefaultBackgroundColor(JPasswordField.class, this, true), "PasswordField.foreground", foregroundColor, "PasswordField.inactiveBackground", SubstanceColorUtilities.getDefaultBackgroundColor(JPasswordField.class, this, true), "PasswordField.inactiveForeground", disabledForegroundColor, "PasswordField.selectionBackground", selectionBackgroundColor, "PasswordField.selectionForeground", selectionForegroundColor, "PopupMenu.background", SubstanceColorUtilities.getDefaultBackgroundColor(JPopupMenu.class, this, false), "PopupMenu.border", regularMarginBorder, "ProgressBar.border", new BorderUIResource(new SubstanceBorder()), "ProgressBar.cycleTime", new Integer(1000), "ProgressBar.repaintInterval", new Integer(50), "ProgressBar.horizontalSize", new DimensionUIResource(146, SubstanceSizeUtils.getControlFontSize()), "ProgressBar.verticalSize", new DimensionUIResource(SubstanceSizeUtils.getControlFontSize(), 146), "ProgressBar.selectionBackground", foregroundColor, "ProgressBar.selectionForeground", foregroundColor, "RadioButton.background", SubstanceColorUtilities.getDefaultBackgroundColor(JRadioButton.class, this, false), "RadioButton.border", new BorderUIResource.CompoundBorderUIResource(SubstanceSizeUtils.getRadioButtonBorder(SubstanceSizeUtils.getControlFontSize()), new BasicBorders.MarginBorder()), "RadioButton.foreground", foregroundColor, "RadioButton.disabledText", disabledForegroundColor, "RadioButtonMenuItem.acceleratorForeground", foregroundColor, "RadioButtonMenuItem.acceleratorSelectionForeground", foregroundColor, "RadioButtonMenuItem.background", SubstanceColorUtilities.getDefaultBackgroundColor(JRadioButtonMenuItem.class, this, false), "RadioButtonMenuItem.borderPainted", Boolean.FALSE, "RadioButtonMenuItem.checkIcon", new RadioButtonMenuItemIcon(null, SubstanceSizeUtils.getMenuCheckMarkSize(SubstanceSizeUtils.getControlFontSize())), "RadioButtonMenuItem.disabledForeground", disabledForegroundColor, "RadioButtonMenuItem.foreground", foregroundColor, "RadioButtonMenuItem.margin", menuItemInsets, "RadioButtonMenuItem.selectionForeground", selectionCellForegroundColor, "RootPane.background", SubstanceColorUtilities.getDefaultBackgroundColor(JRootPane.class, this, false), "RootPane.border", new SubstancePaneBorder(), "ScrollBar.background", SubstanceColorUtilities.getDefaultBackgroundColor(JScrollBar.class, this, false), "ScrollBar.width", new Integer(SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getControlFontSize())), "ScrollBar.minimumThumbSize", new DimensionUIResource(SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getControlFontSize()) - 2, SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getControlFontSize()) - 2), "ScrollPane.background", SubstanceColorUtilities.getDefaultBackgroundColor(JScrollPane.class, this, false), "ScrollPane.foreground", foregroundColor, "ScrollPane.border", new SubstanceScrollPaneBorder(), "Separator.background", backgroundDefaultColor, "Separator.foreground", lineBwColor, "Slider.altTrackColor", lineColor, "Slider.background", SubstanceColorUtilities.getDefaultBackgroundColor(JSlider.class, this, false), "Slider.darkShadow", lineColor, "Slider.focus", lineColor, "Slider.focusInsets", new InsetsUIResource(2, 2, 0, 2), "Slider.foreground", lineColor, "Slider.highlight", backgroundLightColor, "Slider.shadow", lineColor, "Slider.tickColor", foregroundColor, "Spinner.arrowButtonInsets", SubstanceSizeUtils.getSpinnerArrowButtonInsets(SubstanceSizeUtils.getControlFontSize()), "Spinner.background", SubstanceColorUtilities.getDefaultBackgroundColor(JSpinner.class, this, false), "Spinner.border", spinnerBorder, "Spinner.disableOnBoundaryValues", Boolean.TRUE, "Spinner.foreground", foregroundColor, "Spinner.editorBorderPainted", Boolean.TRUE, "SplitPane.background", SubstanceColorUtilities.getDefaultBackgroundColor(JSplitPane.class, this, false), "SplitPane.foreground", foregroundColor, "SplitPane.dividerFocusColor", backgroundDefaultColor, "SplitPaneDivider.draggingColor", backgroundActiveColor, "SplitPane.border", new BorderUIResource(new EmptyBorder(0, 0, 0, 0)), "SplitPane.dividerSize", (int)(SubstanceSizeUtils.getArrowIconWidth(SubstanceSizeUtils.getControlFontSize()) + (float)SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getControlFontSize(), -1, 6, -1, true)), "SplitPaneDivider.border", new BorderUIResource(new EmptyBorder(1, 1, 1, 1)), "TabbedPane.tabAreaBackground", backgroundDefaultColor, "TabbedPane.unselectedBackground", backgroundDefaultColor, "TabbedPane.background", SubstanceColorUtilities.getDefaultBackgroundColor(JTabbedPane.class, this, false), "TabbedPane.borderHightlightColor", new ColorUIResource(mainActiveScheme.getMidColor()), "TabbedPane.contentAreaColor", null, "TabbedPane.contentBorderInsets", new InsetsUIResource(4, 4, 4, 4), "TabbedPane.contentOpaque", Boolean.FALSE, "TabbedPane.darkShadow", new ColorUIResource(this.getBorderColorScheme(null, ComponentState.SELECTED).getLineColor()), "TabbedPane.focus", foregroundColor, "TabbedPane.foreground", foregroundColor, "TabbedPane.highlight", new ColorUIResource(mainActiveScheme.getLightColor()), "TabbedPane.light", mainDefaultScheme.isDark() ? new ColorUIResource(SubstanceColorUtilities.getAlphaColor(mainDefaultScheme.getUltraDarkColor(), 100)) : new ColorUIResource(mainDefaultScheme.getLightColor()), "TabbedPane.selected", new ColorUIResource(mainActiveScheme.getExtraLightColor()), "TabbedPane.selectedForeground", foregroundColor, "TabbedPane.selectHighlight", new ColorUIResource(mainActiveScheme.getMidColor()), "TabbedPane.shadow", new ColorUIResource(SubstanceColorUtilities.getInterpolatedColor(mainDefaultScheme.getExtraLightColor(), mainDefaultScheme.getLightColor(), 0.5)), "TabbedPane.tabRunOverlay", new Integer(0), "Table.background", SubstanceColorUtilities.getDefaultBackgroundColor(JTable.class, this, false), "Table.focusCellBackground", backgroundActiveColor, "Table.focusCellForeground", foregroundColor, "Table.focusCellHighlightBorder", new SubstanceBorder(), "Table.foreground", foregroundColor, "Table.gridColor", lineColorDefault, "Table.scrollPaneBorder", new SubstanceScrollPaneBorder(), "Table.selectionBackground", selectionBackgroundColor, "Table.selectionForeground", selectionCellForegroundColor, "TableHeader.cellBorder", null, "TableHeader.foreground", foregroundColor, "TableHeader.background", SubstanceColorUtilities.getDefaultBackgroundColor(JTableHeader.class, this, false), "TextArea.background", SubstanceColorUtilities.getDefaultBackgroundColor(JTextArea.class, this, false), "TextArea.border", textBorder, "TextArea.caretForeground", foregroundColor, "TextArea.disabledBackground", SubstanceColorUtilities.getDefaultBackgroundColor(JTextArea.class, this, true), "TextArea.foreground", foregroundColor, "TextArea.inactiveBackground", SubstanceColorUtilities.getDefaultBackgroundColor(JTextArea.class, this, true), "TextArea.inactiveForeground", disabledForegroundColor, "TextArea.selectionBackground", selectionBackgroundColor, "TextArea.selectionForeground", selectionForegroundColor, "TextField.background", SubstanceColorUtilities.getDefaultBackgroundColor(JTextField.class, this, false), "TextField.border", textBorder, "TextField.caretForeground", foregroundColor, "TextField.disabledBackground", SubstanceColorUtilities.getDefaultBackgroundColor(JTextField.class, this, true), "TextField.foreground", foregroundColor, "TextField.inactiveBackground", SubstanceColorUtilities.getDefaultBackgroundColor(JTextField.class, this, true), "TextField.inactiveForeground", disabledForegroundColor, "TextField.selectionBackground", selectionBackgroundColor, "TextField.selectionForeground", selectionForegroundColor, "TextPane.background", SubstanceColorUtilities.getDefaultBackgroundColor(JTextPane.class, this, false), "TextPane.border", textBorder, "TextPane.disabledBackground", SubstanceColorUtilities.getDefaultBackgroundColor(JTextPane.class, this, true), "TextPane.foreground", foregroundColor, "TextPane.caretForeground", foregroundColor, "TextPane.inactiveBackground", SubstanceColorUtilities.getDefaultBackgroundColor(JTextPane.class, this, true), "TextPane.inactiveForeground", disabledForegroundColor, "TextPane.selectionBackground", selectionBackgroundColor, "TextPane.selectionForeground", selectionForegroundColor, "TitledBorder.titleColor", foregroundColor, "TitledBorder.border", new SubstanceEtchedBorder(), "ToggleButton.foreground", foregroundColor, "ToggleButton.disabledText", disabledForegroundColor, "ToggleButton.margin", new InsetsUIResource(0, 0, 0, 0), "ToolBar.background", SubstanceColorUtilities.getDefaultBackgroundColor(JToolBar.class, this, false), "ToolBar.border", new BorderUIResource(new SubstanceToolBarBorder()), "ToolBar.isRollover", Boolean.TRUE, "ToolBar.foreground", foregroundColor, "ToolBarSeparator.background", SubstanceColorUtilities.getDefaultBackgroundColor(JToolBar.class, this, false), "ToolBarSeparator.foreground", lineBwColor, "ToolBar.separatorSize", null, "ToolTip.border", tooltipBorder, "ToolTip.borderInactive", tooltipBorder, "ToolTip.background", SubstanceColorUtilities.getDefaultBackgroundColor(JToolTip.class, this, false), "ToolTip.backgroundInactive", SubstanceColorUtilities.getDefaultBackgroundColor(JTextPane.class, this, true), "ToolTip.foreground", foregroundColor, "ToolTip.foregroundInactive", disabledForegroundColor, "Tree.closedIcon", emptyIcon, "Tree.collapsedIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new IconUIResource(SubstanceIconFactory.getTreeIcon(null, true));
            }
        }, "Tree.expandedIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new IconUIResource(SubstanceIconFactory.getTreeIcon(null, false));
            }
        }, "Tree.leafIcon", emptyIcon, "Tree.openIcon", emptyIcon, "Tree.background", SubstanceColorUtilities.getDefaultBackgroundColor(JTree.class, this, false), "Tree.selectionBackground", backgroundLightColor, "Tree.foreground", foregroundColor, "Tree.hash", lineColorDefault, "Tree.rowHeight", new Integer(0), "Tree.selectionBorderColor", lineColor, "Tree.selectionForeground", selectionCellForegroundColor, "Tree.textBackground", backgroundDefaultColor, "Tree.textForeground", foregroundColor, "Viewport.background", backgroundDefaultColor, "Viewport.foreground", foregroundColor};
        table.putDefaults(defaults);
    }

    public SubstanceColorScheme getColorScheme(Component comp, ComponentState componentState) {
        return this.getColorScheme(comp, componentState, false);
    }

    public SubstanceColorScheme getColorScheme(Component comp, ComponentState componentState, boolean toIgnoreHighlights) {
        SubstanceColorScheme registered;
        DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey((Object)(decorationAreaType = SubstanceDecorationUtilities.getDecorationType(comp))) && (registered = this.colorSchemeBundleMap.get((Object)decorationAreaType).getColorScheme(comp, componentState, toIgnoreHighlights)) != null) {
            return registered;
        }
        SubstanceColorScheme registered2 = this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getColorScheme(comp, componentState, toIgnoreHighlights);
        if (registered2 != null) {
            return registered2;
        }
        if (componentState == ComponentState.DEFAULT) {
            return this.getMainDefaultColorScheme();
        }
        if (componentState.getColorSchemeKind() == ComponentState.ColorSchemeKind.DISABLED) {
            return this.getMainDisabledColorScheme();
        }
        return this.getMainActiveColorScheme();
    }

    public SubstanceColorScheme getHighlightColorScheme(Component comp, ComponentState componentState) {
        SubstanceColorScheme registered;
        DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey((Object)(decorationAreaType = SubstanceDecorationUtilities.getDecorationType(comp))) && (registered = this.colorSchemeBundleMap.get((Object)decorationAreaType).getHighlightColorScheme(comp, componentState)) != null) {
            return registered;
        }
        SubstanceColorScheme registered2 = this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getHighlightColorScheme(comp, componentState);
        if (registered2 != null) {
            return registered2;
        }
        if (componentState == ComponentState.DEFAULT) {
            return this.getMainDefaultColorScheme();
        }
        if (componentState.getColorSchemeKind() == ComponentState.ColorSchemeKind.DISABLED) {
            return this.getMainDisabledColorScheme();
        }
        return this.getMainActiveColorScheme();
    }

    public float getHighlightAlpha(Component comp, ComponentState componentState) {
        Float registered;
        DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey((Object)(decorationAreaType = SubstanceDecorationUtilities.getDecorationType(comp))) && (double)(registered = Float.valueOf(this.colorSchemeBundleMap.get((Object)decorationAreaType).getHighlightAlpha(comp, componentState))).floatValue() >= 0.0) {
            return registered.floatValue();
        }
        Float registered2 = Float.valueOf(this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getHighlightAlpha(comp, componentState));
        if ((double)registered2.floatValue() >= 0.0) {
            return registered2.floatValue();
        }
        boolean isRollover = componentState.isKindActive(FadeKind.ROLLOVER);
        boolean isSelected = componentState.isKindActive(FadeKind.SELECTION);
        boolean isArmed = componentState.isKindActive(FadeKind.ARM);
        if (isRollover && isSelected) {
            return 0.9f;
        }
        if (isRollover && isArmed) {
            return 0.8f;
        }
        if (isSelected) {
            return 0.7f;
        }
        if (isArmed) {
            return 0.6f;
        }
        if (isRollover) {
            return 0.4f;
        }
        return 0.0f;
    }

    public float getAlpha(Component comp, ComponentState componentState) {
        Float registered;
        DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey((Object)(decorationAreaType = SubstanceDecorationUtilities.getDecorationType(comp))) && (double)(registered = Float.valueOf(this.colorSchemeBundleMap.get((Object)decorationAreaType).getAlpha(comp, componentState))).floatValue() >= 0.0) {
            return registered.floatValue();
        }
        Float registered2 = Float.valueOf(this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getAlpha(comp, componentState));
        if ((double)registered2.floatValue() >= 0.0) {
            return registered2.floatValue();
        }
        return 1.0f;
    }

    public void registerDecorationAreaSchemeBundle(SubstanceColorSchemeBundle bundle, SubstanceColorScheme backgroundColorScheme, DecorationAreaType ... areaTypes) {
        if (bundle == null) {
            return;
        }
        for (DecorationAreaType areaType : areaTypes) {
            this.decoratedAreaSet.add(areaType);
            this.colorSchemeBundleMap.put(areaType, bundle);
            this.backgroundColorSchemeMap.put(areaType, backgroundColorScheme);
        }
    }

    public void registerDecorationAreaSchemeBundle(SubstanceColorSchemeBundle bundle, DecorationAreaType ... areaTypes) {
        this.registerDecorationAreaSchemeBundle(bundle, bundle.getDefaultColorScheme(), areaTypes);
    }

    public void registerAsDecorationArea(SubstanceColorScheme backgroundColorScheme, DecorationAreaType ... areaTypes) {
        for (DecorationAreaType areaType : areaTypes) {
            this.decoratedAreaSet.add(areaType);
            this.backgroundColorSchemeMap.put(areaType, backgroundColorScheme);
        }
    }

    public boolean isRegisteredAsDecorationArea(DecorationAreaType decorationType) {
        return this.decoratedAreaSet.contains((Object)decorationType);
    }

    public SubstanceColorScheme getWatermarkColorScheme() {
        if (this.watermarkScheme != null) {
            return this.watermarkScheme;
        }
        return this.getMainDefaultColorScheme();
    }

    public SubstanceColorScheme getMainActiveColorScheme(DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey((Object)decorationAreaType)) {
            return this.colorSchemeBundleMap.get((Object)decorationAreaType).getActiveColorScheme();
        }
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getActiveColorScheme();
    }

    public SubstanceColorScheme getMainDefaultColorScheme(DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey((Object)decorationAreaType)) {
            return this.colorSchemeBundleMap.get((Object)decorationAreaType).getDefaultColorScheme();
        }
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getDefaultColorScheme();
    }

    public SubstanceColorScheme getMainDisabledColorScheme(DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey((Object)decorationAreaType)) {
            return this.colorSchemeBundleMap.get((Object)decorationAreaType).getDisabledColorScheme();
        }
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getDisabledColorScheme();
    }

    public double getSelectedTabFadeStart() {
        return this.selectedTabFadeStart;
    }

    public double getSelectedTabFadeEnd() {
        return this.selectedTabFadeEnd;
    }

    public void setSelectedTabFadeEnd(double selectedTabFadeEnd) {
        if (selectedTabFadeEnd < 0.0 || selectedTabFadeEnd > 1.0) {
            throw new IllegalArgumentException("Value for selected tab fade end should be in 0.0-1.0 range");
        }
        this.selectedTabFadeEnd = selectedTabFadeEnd;
    }

    public void setSelectedTabFadeStart(double selectedTabFadeStart) {
        if (selectedTabFadeStart < 0.0 || selectedTabFadeStart > 1.0) {
            throw new IllegalArgumentException("Value for selected tab fade start should be in 0.0-1.0 range");
        }
        this.selectedTabFadeStart = selectedTabFadeStart;
    }

    public boolean isPaintingDropShadows(DecorationAreaType decorationAreaType) {
        return this.dropShadowsSet.contains((Object)decorationAreaType);
    }

    public void setPaintingDropShadows(DecorationAreaType decorationAreaType) {
        this.dropShadowsSet.add(decorationAreaType);
    }

    public SubstanceColorScheme getBorderColorScheme(Component comp, ComponentState componentState) {
        DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey((Object)(decorationAreaType = SubstanceDecorationUtilities.getDecorationType(comp)))) {
            return this.colorSchemeBundleMap.get((Object)decorationAreaType).getBorderColorScheme(comp, componentState);
        }
        return this.colorSchemeBundleMap.get((Object)DecorationAreaType.NONE).getBorderColorScheme(comp, componentState);
    }

    protected Object clone() throws CloneNotSupportedException {
        final String myName = this.getDisplayName();
        SubstanceSkin clone = new SubstanceSkin(){

            @Override
            public String getDisplayName() {
                return "Clone " + myName;
            }
        };
        clone.borderPainter = this.borderPainter;
        clone.buttonShaper = this.buttonShaper;
        clone.decorationPainter = this.decorationPainter;
        clone.gradientPainter = this.gradientPainter;
        clone.highlightPainter = this.highlightPainter;
        clone.watermark = this.watermark;
        clone.watermarkScheme = this.watermarkScheme;
        clone.selectedTabFadeEnd = this.selectedTabFadeEnd;
        clone.selectedTabFadeStart = this.selectedTabFadeStart;
        if (this.colorSchemeBundleMap != null) {
            clone.colorSchemeBundleMap = new EnumMap<DecorationAreaType, SubstanceColorSchemeBundle>(DecorationAreaType.class);
            for (Map.Entry<DecorationAreaType, SubstanceColorSchemeBundle> bundleEntry : this.colorSchemeBundleMap.entrySet()) {
                clone.colorSchemeBundleMap.put(bundleEntry.getKey(), (SubstanceColorSchemeBundle)bundleEntry.getValue().clone());
            }
        }
        if (this.decoratedAreaSet != null) {
            clone.decoratedAreaSet = EnumSet.copyOf(this.decoratedAreaSet);
        }
        if (this.dropShadowsSet != null) {
            clone.dropShadowsSet = EnumSet.copyOf(this.dropShadowsSet);
        }
        if (this.backgroundColorSchemeMap != null) {
            clone.backgroundColorSchemeMap = new EnumMap<DecorationAreaType, SubstanceColorScheme>(this.backgroundColorSchemeMap);
        }
        return clone;
    }

    @SubstanceApi
    public SubstanceSkin transform(ColorSchemeTransform transform, final String name) {
        SubstanceSkin result = new SubstanceSkin(){

            @Override
            public String getDisplayName() {
                return name;
            }
        };
        result.borderPainter = this.borderPainter;
        result.buttonShaper = this.buttonShaper;
        result.decorationPainter = this.decorationPainter;
        result.gradientPainter = this.gradientPainter;
        result.highlightPainter = this.highlightPainter;
        result.watermark = this.watermark;
        if (this.watermarkScheme != null) {
            result.watermarkScheme = transform.transform(this.watermarkScheme);
        }
        result.selectedTabFadeEnd = this.selectedTabFadeEnd;
        result.selectedTabFadeStart = this.selectedTabFadeStart;
        if (this.colorSchemeBundleMap != null) {
            result.colorSchemeBundleMap = new EnumMap<DecorationAreaType, SubstanceColorSchemeBundle>(DecorationAreaType.class);
            for (Map.Entry<DecorationAreaType, SubstanceColorSchemeBundle> entry : this.colorSchemeBundleMap.entrySet()) {
                result.colorSchemeBundleMap.put(entry.getKey(), entry.getValue().transform(transform));
            }
        }
        if (this.decoratedAreaSet != null) {
            result.decoratedAreaSet = EnumSet.copyOf(this.decoratedAreaSet);
        }
        if (this.dropShadowsSet != null) {
            result.dropShadowsSet = EnumSet.copyOf(this.dropShadowsSet);
        }
        if (this.backgroundColorSchemeMap != null) {
            result.backgroundColorSchemeMap = new EnumMap<DecorationAreaType, SubstanceColorScheme>(DecorationAreaType.class);
            for (Map.Entry<DecorationAreaType, Object> entry : this.backgroundColorSchemeMap.entrySet()) {
                result.backgroundColorSchemeMap.put(entry.getKey(), transform.transform((SubstanceColorScheme)entry.getValue()));
            }
        }
        return result;
    }

    @SubstanceApi
    public SubstanceSkin withWatermark(SubstanceWatermark watermark) {
        try {
            SubstanceSkin clone = (SubstanceSkin)this.clone();
            clone.watermark = watermark;
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public SubstanceColorScheme getBackgroundColorScheme(DecorationAreaType decorationAreaType) {
        SubstanceColorScheme registered;
        if (this.backgroundColorSchemeMap.containsKey((Object)decorationAreaType)) {
            return this.backgroundColorSchemeMap.get((Object)decorationAreaType);
        }
        if (this.colorSchemeBundleMap.containsKey((Object)decorationAreaType) && (registered = this.colorSchemeBundleMap.get((Object)decorationAreaType).getDefaultColorScheme()) != null) {
            return registered;
        }
        return this.backgroundColorSchemeMap.get((Object)DecorationAreaType.NONE);
    }

    public boolean isValid() {
        if (!this.colorSchemeBundleMap.containsKey((Object)DecorationAreaType.NONE)) {
            return false;
        }
        if (this.getButtonShaper() == null) {
            return false;
        }
        if (this.getGradientPainter() == null) {
            return false;
        }
        if (this.getBorderPainter() == null) {
            return false;
        }
        if (this.getHighlightPainter() == null) {
            return false;
        }
        return this.getDecorationPainter() != null;
    }
}

