/*
 * Decompiled with CFR 0.152.
 */
package my.client.plnf.wp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import my.client.plnf.wp.WallpaperScrollBarUI;
import my.client.plnf.wp.WallpaperThemeImpl;

class WallpaperTool {
    static VersionAdapter versionAdapter;

    static {
        try {
            String specVersion = System.getProperty("java.specification.version", "1.0");
            versionAdapter = WallpaperTool.isCompatable(specVersion, "1.5") ? WallpaperTool.getVersionAdapter("my.client.plnf.wp.JREVersion1Dot5Adapter") : WallpaperTool.getVersionAdapter("my.client.plnf.wp.JREVersion1Dot4Adapter");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    WallpaperTool() {
    }

    private static final boolean isCompatable(String vmVersion, String softwareVersion) {
        StringTokenizer vmToken = new StringTokenizer(vmVersion, ".");
        StringTokenizer softwareToken = new StringTokenizer(softwareVersion, ".");
        while (vmToken.hasMoreTokens()) {
            int software;
            if (!softwareToken.hasMoreTokens()) {
                return false;
            }
            int vm = Integer.parseInt(vmToken.nextToken());
            if (vm > (software = Integer.parseInt(softwareToken.nextToken()))) {
                return true;
            }
            if (vm >= software) continue;
            return false;
        }
        return true;
    }

    private static final VersionAdapter getVersionAdapter(String className) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> aClass = Class.forName(className);
        Constructor<?> constructor = aClass.getDeclaredConstructor(new Class[0]);
        return (VersionAdapter)constructor.newInstance(new Object[0]);
    }

    static final void paintBackGroundWithFocusAndPress(Graphics g, AbstractButton b, WallpaperThemeImpl theme) {
        if (WallpaperTool.isSelected(b)) {
            WallpaperTool.paintBackGround(g, (Component)b, theme.getSelectBufferedImage());
        } else if (b.isEnabled() && versionAdapter.isRollover(b)) {
            b.getModel().setArmed(false);
            WallpaperTool.paintBackGround(g, (Component)b, theme.getRolloverBufferedImage());
        } else {
            WallpaperTool.paintBackGround(g, (Component)b, theme.getBufferedImage());
        }
    }

    private static boolean isSelected(AbstractButton b) {
        if (b.isEnabled()) {
            if (b instanceof JToggleButton && !(b instanceof JCheckBox) && !(b instanceof JRadioButton) ? b.getModel().isSelected() : b.isFocusPainted() && b.hasFocus()) {
                return true;
            }
            if (!(b instanceof JMenu) ? b.getModel().isPressed() : b.getModel().isSelected()) {
                return true;
            }
        }
        return false;
    }

    private static final void paintBackGround(Graphics g, Component c, TexturePaint texture) {
        Graphics2D g2d = (Graphics2D)g;
        Paint paint = g2d.getPaint();
        g2d.setPaint(texture);
        Container root = WallpaperTool.getRoot(c.getParent());
        Point rootLocation = null;
        if (!root.isDisplayable() || !root.isShowing()) {
            return;
        }
        rootLocation = root.getLocationOnScreen();
        Point componentLocation = null;
        if (!c.isDisplayable() || !c.isShowing()) {
            return;
        }
        componentLocation = c.getLocationOnScreen();
        int compx = componentLocation.x - rootLocation.x;
        int compy = componentLocation.y - rootLocation.y;
        Rectangle2D image = texture.getAnchorRect();
        int imageWidth = (int)image.getWidth();
        int imageHeight = (int)image.getHeight();
        int bottom = compy + c.getHeight();
        int left = compx + c.getWidth();
        int startX = compx / imageWidth;
        int endX = left / imageWidth + 1;
        int startY = compy / imageHeight;
        int endY = bottom / imageHeight + 1;
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                g2d.fillRect(x * imageWidth - compx, y * imageHeight - compy, (int)image.getWidth(), (int)image.getHeight());
                ++y;
            }
            ++x;
        }
        g2d.setPaint(paint);
    }

    static final void paintBackGround(Graphics g, Component c, Image image) {
        Graphics2D g2d = (Graphics2D)g;
        Point componentLocation = null;
        if (!c.isDisplayable() || !c.isShowing()) {
            return;
        }
        componentLocation = c.getLocationOnScreen();
        Container root = WallpaperTool.getRoot((Container)(c instanceof Container ? c : c.getParent()));
        Point rootLocation = null;
        if (!root.isDisplayable() || !root.isShowing()) {
            return;
        }
        rootLocation = root.getLocationOnScreen();
        int compx = componentLocation.x - rootLocation.x;
        int compy = componentLocation.y - rootLocation.y;
        int compWidth = c.getWidth();
        int compHeight = c.getHeight();
        WallpaperTool.paint(image, g2d, compx, compy, compWidth, compHeight);
    }

    static void paint(Image image, Graphics2D g2d, int compx, int compy, int compWidth, int compHeight) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        int bottom = compy + compHeight;
        int left = compx + compWidth;
        int startX = compx / imageWidth;
        int endX = left / imageWidth + 1;
        int startY = compy / imageHeight;
        int endY = bottom / imageHeight + 1;
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                g2d.drawImage(image, x * imageWidth - compx, y * imageHeight - compy, null);
                ++y;
            }
            ++x;
        }
    }

    static void paintWithClip(Image image, Graphics2D g2d, int x, int y, int width, int height) {
        Shape clip = g2d.getClip();
        g2d.setClip(x, y, width, height);
        WallpaperTool.paint(image, g2d, x, y, width, height);
        g2d.setClip(clip);
    }

    static final Container getRoot(Container c) {
        if (c.getParent() == null || c instanceof JInternalFrame || c.getParent() instanceof JViewport) {
            return c;
        }
        return WallpaperTool.getRoot(c.getParent());
    }

    static boolean isRollover(WallpaperScrollBarUI barUI, JComponent c) {
        return versionAdapter.isRollover(barUI, c);
    }

    public interface VersionAdapter {
        public boolean isRollover(AbstractButton var1) throws HeadlessException;

        public boolean isRollover(WallpaperScrollBarUI var1, JComponent var2);
    }
}

