/*
 * Decompiled with CFR 0.152.
 */
package my.client.plnf.wp;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RescaleOp;
import javax.swing.ImageIcon;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public final class WallpaperThemeImpl
extends DefaultMetalTheme {
    private Object basisObjectForResourceLoad;
    private String defaultImage;
    private String rolloverImage;
    private String selectImage;
    private BufferedImage bufferedImage;
    private BufferedImage rolloverBufferedImage;
    private BufferedImage selectBufferedImage;
    private float rolloverBrightness = 25.0f;
    private float selectBrightness = -50.0f;
    private TexturePaint texture;
    private TexturePaint rolloverTexture;
    private TexturePaint selectTexture;
    private ColorUIResource primaryColor;
    private ColorUIResource primaryShadowColor;
    private ColorUIResource primaryDarkColor;
    private ColorUIResource secondaryColor;
    private ColorUIResource secondaryShadowColor;
    private ColorUIResource secondaryDarkColor;
    static final FontUIResource DIALOG_PLAIN_12 = new FontUIResource("dialog", 0, 12);
    static final FontUIResource DIALOG_BOLD_12 = new FontUIResource("dialog", 1, 12);
    boolean useBold = true;
    FontUIResource controlTextFont;
    FontUIResource menuTextFont;
    FontUIResource subTextFont;
    FontUIResource SystemTextFont;
    FontUIResource userTextFont;
    FontUIResource windowTitleFont;

    WallpaperThemeImpl() {
    }

    public String getDefaultImage() {
        return this.defaultImage;
    }

    public void setDefaultImage(String image) {
        this.defaultImage = image;
    }

    public String getRolloverImage() {
        return this.rolloverImage;
    }

    public void setRolloverImage(String rolloverImage) {
        this.rolloverImage = rolloverImage;
    }

    public String getSelectImage() {
        return this.selectImage;
    }

    public void setSelectImage(String selectImage) {
        this.selectImage = selectImage;
    }

    public BufferedImage getBufferedImage() {
        if (this.bufferedImage == null) {
            ImageIcon icon = WallpaperThemeImpl.getIcon(this.basisObjectForResourceLoad.getClass(), this.defaultImage);
            Image image = icon.getImage();
            this.bufferedImage = WallpaperThemeImpl.toBufferedImage(image);
        }
        return this.bufferedImage;
    }

    public BufferedImage getRolloverBufferedImage() {
        if (this.rolloverBufferedImage == null) {
            if (this.rolloverImage == null) {
                this.getTexture();
                this.rolloverBufferedImage = WallpaperThemeImpl.createEmptyBufferedImage(this.bufferedImage);
                this.rolloverBufferedImage = new RescaleOp(1.0f, this.rolloverBrightness, null).filter(this.bufferedImage, this.rolloverBufferedImage);
            } else {
                ImageIcon icon = WallpaperThemeImpl.getIcon(this.basisObjectForResourceLoad.getClass(), this.rolloverImage);
                Image image = icon.getImage();
                this.rolloverBufferedImage = WallpaperThemeImpl.toBufferedImage(image);
            }
        }
        return this.rolloverBufferedImage;
    }

    public BufferedImage getSelectBufferedImage() {
        if (this.selectBufferedImage == null) {
            if (this.selectImage == null) {
                this.getTexture();
                this.selectBufferedImage = WallpaperThemeImpl.createEmptyBufferedImage(this.bufferedImage);
                this.selectBufferedImage = new RescaleOp(1.0f, this.selectBrightness, null).filter(this.bufferedImage, this.selectBufferedImage);
            } else {
                ImageIcon icon = WallpaperThemeImpl.getIcon(this.basisObjectForResourceLoad.getClass(), this.selectImage);
                Image image = icon.getImage();
                this.selectBufferedImage = WallpaperThemeImpl.toBufferedImage(image);
            }
        }
        return this.selectBufferedImage;
    }

    public WallpaperThemeImpl(String imageFile, ColorUIResource defaultColor, ColorUIResource shadowColor, ColorUIResource darkColor) {
        this.defaultImage = imageFile;
        this.primaryColor = defaultColor;
        this.primaryShadowColor = shadowColor;
        this.primaryDarkColor = darkColor;
        this.secondaryColor = defaultColor;
        this.secondaryShadowColor = shadowColor;
        this.secondaryDarkColor = darkColor;
    }

    protected ColorUIResource getPrimary1() {
        return this.primaryColor;
    }

    protected ColorUIResource getPrimary2() {
        return this.primaryShadowColor;
    }

    protected ColorUIResource getPrimary3() {
        return this.primaryDarkColor;
    }

    protected ColorUIResource getSecondary1() {
        return this.secondaryColor;
    }

    protected ColorUIResource getSecondary2() {
        return this.secondaryShadowColor;
    }

    protected ColorUIResource getSecondary3() {
        return this.secondaryDarkColor;
    }

    public TexturePaint getTexture() {
        if (this.texture == null) {
            this.texture = WallpaperThemeImpl.getTexturePaint(this.getBufferedImage());
        }
        return this.texture;
    }

    public TexturePaint getRolloverTexture() {
        if (this.rolloverTexture == null) {
            this.rolloverTexture = WallpaperThemeImpl.getTexturePaint(this.getRolloverBufferedImage());
        }
        return this.rolloverTexture;
    }

    public TexturePaint getSelectTexture() {
        if (this.selectTexture == null) {
            this.selectTexture = WallpaperThemeImpl.getTexturePaint(this.getSelectBufferedImage());
        }
        return this.selectTexture;
    }

    public static final TexturePaint getTexturePaint(Image image) {
        BufferedImage bufferedImage = WallpaperThemeImpl.toBufferedImage(image);
        return WallpaperThemeImpl.getTexturePaint(bufferedImage);
    }

    private static TexturePaint getTexturePaint(BufferedImage bufferedImage) {
        return new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public static final ImageIcon getIcon(Class aClass, String iconFile) {
        return new ImageIcon(aClass.getResource(iconFile));
    }

    public static final BufferedImage createEmptyBufferedImage(Image image) {
        return new BufferedImage(image.getWidth(null), image.getHeight(null), WallpaperThemeImpl.hasAlpha(image) ? 2 : 1);
    }

    public static final BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = WallpaperThemeImpl.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static final boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public void setBasisObjectForResourceLoad(Object basisObjectForResourceLoad) {
        this.basisObjectForResourceLoad = basisObjectForResourceLoad;
    }

    public void setDefaultFontAsBold(boolean isBold) {
        this.useBold = isBold;
    }

    private FontUIResource getDefaultFont() {
        if (this.useBold) {
            return DIALOG_BOLD_12;
        }
        return DIALOG_PLAIN_12;
    }

    public FontUIResource getControlTextFont() {
        if (this.controlTextFont == null) {
            this.controlTextFont = this.getDefaultFont();
        }
        return this.controlTextFont;
    }

    public FontUIResource getMenuTextFont() {
        if (this.menuTextFont == null) {
            this.menuTextFont = this.getDefaultFont();
        }
        return this.menuTextFont;
    }

    public FontUIResource getSubTextFont() {
        if (this.subTextFont == null) {
            this.subTextFont = this.getDefaultFont();
        }
        return this.subTextFont;
    }

    public FontUIResource getSystemTextFont() {
        if (this.SystemTextFont == null) {
            this.SystemTextFont = this.getDefaultFont();
        }
        return this.SystemTextFont;
    }

    public FontUIResource getUserTextFont() {
        if (this.userTextFont == null) {
            this.userTextFont = super.getUserTextFont();
        }
        return this.userTextFont;
    }

    public FontUIResource getWindowTitleFont() {
        if (this.windowTitleFont == null) {
            this.windowTitleFont = this.getDefaultFont();
        }
        return this.windowTitleFont;
    }
}

