/*
 * Decompiled with CFR 0.152.
 */
package my.client.plnf.wp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import my.client.plnf.wp.WallpaperHelper;
import my.client.plnf.wp.WallpaperTool;

public final class WallpaperScrollBarUI
extends MetalScrollBarUI {
    public static final WallpaperHelper helper = new WallpaperHelper();
    private Color thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
    private Color thumbHighlight = UIManager.getColor("ScrollBar.thumbHighlight");

    WallpaperScrollBarUI() {
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Graphics2D g2d = (Graphics2D)g;
        Paint paint = g2d.getPaint();
        Color color = g2d.getColor();
        Rectangle rec = g2d.getClipBounds();
        JScrollBar s = (JScrollBar)c;
        g2d.clip(thumbBounds);
        if (!s.isEnabled()) {
            g2d.setClip(rec);
            return;
        }
        if (this.isDragging) {
            WallpaperTool.paintBackGround((Graphics)g2d, (Component)c, helper.getTheme().getSelectBufferedImage());
        } else if (WallpaperTool.isRollover(this, c)) {
            WallpaperTool.paintBackGround((Graphics)g2d, (Component)c, helper.getTheme().getRolloverBufferedImage());
        } else {
            WallpaperTool.paintBackGround((Graphics)g2d, (Component)c, helper.getTheme().getBufferedImage());
        }
        g2d.setColor(this.thumbShadow);
        g2d.drawRect(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
        g2d.setColor(this.thumbHighlight);
        g2d.fillRect(thumbBounds.x, thumbBounds.y + 1, thumbBounds.width, 1);
        g2d.fillRect(thumbBounds.x + 1, thumbBounds.y, 1, thumbBounds.height);
        g2d.setClip(rec);
        g2d.setColor(color);
        g2d.setPaint(paint);
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        super.paintTrack(g, c, trackBounds);
    }

    public static ComponentUI createUI(JComponent c) {
        return new WallpaperScrollBarUI();
    }
}

