/*
 * Decompiled with CFR 0.152.
 */
package my.client.plnf.wp;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonListener;
import my.client.plnf.wp.WallpaperLookAndFeel;
import my.client.plnf.wp.WallpaperThemeImpl;
import my.client.plnf.wp.WallpaperTool;

class WallpaperHelper {
    private WallpaperThemeImpl theme;
    private BasicButtonListener buttonListener;
    boolean rolloverBackup;

    WallpaperHelper() {
    }

    public WallpaperThemeImpl getTheme() {
        if (this.theme == null) {
            this.theme = ((WallpaperLookAndFeel)UIManager.getLookAndFeel()).getWallpaperLookAndFeel().getTheme();
        }
        return this.theme;
    }

    public void paint(Graphics g, JComponent c) {
        WallpaperTool.paintBackGround(g, (Component)c, this.getTheme().getBufferedImage());
    }

    public void dynamicPaint(Graphics g, JComponent c) {
        WallpaperTool.paintBackGroundWithFocusAndPress(g, (AbstractButton)c, this.getTheme());
    }

    public BasicButtonListener getButtonListener(JComponent c) {
        if (this.buttonListener == null) {
            this.buttonListener = new BasicButtonListener((AbstractButton)c){};
        }
        return this.buttonListener;
    }

    public void installButtonListener(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        this.rolloverBackup = b.isRolloverEnabled();
        b.setRolloverEnabled(true);
        BasicButtonListener buttonListener = this.getButtonListener(c);
        c.addMouseListener(buttonListener);
        c.addFocusListener(buttonListener);
        c.addMouseMotionListener(buttonListener);
        c.addPropertyChangeListener(buttonListener);
        ((AbstractButton)c).addChangeListener(buttonListener);
    }

    public void uninstallButtonListener(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        b.setRolloverEnabled(this.rolloverBackup);
        BasicButtonListener buttonListener = this.getButtonListener(c);
        c.removeMouseListener(buttonListener);
        c.removeFocusListener(buttonListener);
        c.removeMouseMotionListener(buttonListener);
        c.removePropertyChangeListener(buttonListener);
        ((AbstractButton)c).removeChangeListener(buttonListener);
    }
}

