/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceOutlineUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.border.SubstanceBorder;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceTextUtilities {
    public static void paintTextWithDropShadow(JComponent c, Graphics g, Color foregroundColor, String text, int width, int height, int xOffset, int yOffset) {
        Graphics2D graphics = (Graphics2D)g.create();
        RenderingUtils.installDesktopHints(graphics, c);
        BufferedImage blurred = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D gBlurred = (Graphics2D)blurred.getGraphics();
        gBlurred.setFont(graphics.getFont());
        gBlurred.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        float luminFactor = SubstanceColorUtilities.getColorStrength(foregroundColor);
        gBlurred.setColor(SubstanceColorUtilities.getNegativeColor(foregroundColor));
        ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{0.0f, 0.05f, 0.1f, 0.05f, 0.0f, 0.1f, 0.1f, 0.1f, 0.1f}), 1, null);
        gBlurred.drawString(text, xOffset + 1, yOffset + 1);
        blurred = convolve.filter(blurred, null);
        graphics.setComposite(TransitionLayout.getAlphaComposite(c, luminFactor, g));
        graphics.drawImage((Image)blurred, 0, 0, null);
        graphics.setComposite(TransitionLayout.getAlphaComposite((Component)c, g));
        FontMetrics fm = graphics.getFontMetrics();
        SubstanceTextUtilities.paintText((Graphics)graphics, c, new Rectangle(xOffset, yOffset - fm.getAscent(), width - xOffset, fm.getHeight()), text, -1, graphics.getFont(), foregroundColor, graphics.getClipBounds());
        graphics.dispose();
    }

    private static void paintText(Graphics g, JComponent comp, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip, AffineTransform transform) {
        if (text == null || text.length() == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(font);
        g2d.setColor(color);
        if (clip != null) {
            g2d.setClip(clip);
        }
        if (transform != null) {
            g2d.transform(transform);
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, text, mnemonicIndex, textRect.x, textRect.y + g2d.getFontMetrics().getAscent());
        g2d.dispose();
    }

    public static void paintText(Graphics g, JComponent comp, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip) {
        SubstanceTextUtilities.paintText(g, comp, textRect, text, mnemonicIndex, font, color, clip, null);
    }

    public static void paintVerticalText(Graphics g, JComponent comp, Rectangle textRect, String text, int mnemonicIndex, Font font, Color color, Rectangle clip, boolean isFromBottomToTop) {
        if (text == null || text.length() == 0) {
            return;
        }
        AffineTransform at = null;
        if (!isFromBottomToTop) {
            at = AffineTransform.getTranslateInstance(textRect.x + textRect.width, textRect.y);
            at.rotate(1.5707963267948966);
        } else {
            at = AffineTransform.getTranslateInstance(textRect.x, textRect.y + textRect.height);
            at.rotate(-1.5707963267948966);
        }
        Rectangle newRect = new Rectangle(0, 0, textRect.width, textRect.height);
        SubstanceTextUtilities.paintText(g, comp, newRect, text, mnemonicIndex, font, color, clip, at);
    }

    public static void paintText(Graphics g, AbstractButton button, Rectangle textRect, String text, int mnemonicIndex) {
        ButtonModel model = button.getModel();
        ComponentState state = ComponentState.getState(model, button, button instanceof JMenuItem);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(button);
        if ((SubstanceCoreUtilities.isButtonNeverPainted(button) || !button.isContentAreaFilled() || button instanceof JRadioButton || button instanceof JCheckBox) && state.isKindActive(FadeKind.ENABLE)) {
            state = ComponentState.DEFAULT;
            prevState = ComponentState.DEFAULT;
        }
        float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha(button, ComponentState.getState(button));
        SubstanceTextUtilities.paintText(g, (JComponent)button, textRect, text, mnemonicIndex, state, prevState, buttonAlpha);
    }

    public static void paintText(Graphics g, JComponent component, Rectangle textRect, String text, int mnemonicIndex, ComponentState state, ComponentState prevState, float textAlpha) {
        Color fgColor = SubstanceTextUtilities.getForegroundColor(component, text, state, prevState, textAlpha);
        SubstanceTextUtilities.paintText(g, component, textRect, text, mnemonicIndex, component.getFont(), fgColor, null);
    }

    public static Color getForegroundColor(JComponent component, String text, ComponentState state, ComponentState prevState, float textAlpha) {
        Color fgColor;
        if (text == null || text.length() == 0) {
            return null;
        }
        Color color = fgColor = SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null ? component.getForeground() : SubstanceColorUtilities.getForegroundColor(component, state, prevState);
        if (textAlpha < 1.0f) {
            Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor(component);
            fgColor = SubstanceColorUtilities.getInterpolatedColor(fgColor, bgFillColor, textAlpha);
        }
        return fgColor;
    }

    public static void paintTextCompBackground(Graphics g, JComponent comp) {
        SubstanceTextUtilities.paintTextCompBackground(g, comp, SubstanceColorUtilities.getBackgroundFillColor(comp), SubstanceCoreUtilities.toDrawWatermark(comp) || !comp.isOpaque());
    }

    private static void paintTextCompBackground(Graphics g, JComponent comp, Color backgr, boolean toOverlayWatermark) {
        SubstanceWatermark watermark;
        Graphics2D g2d = (Graphics2D)g.create();
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(comp)) / 2.0);
        Border compBorder = comp.getBorder();
        boolean isSubstanceBorder = compBorder instanceof SubstanceBorder;
        if (compBorder instanceof CompoundBorder) {
            isSubstanceBorder = isSubstanceBorder || ((CompoundBorder)compBorder).getOutsideBorder() instanceof SubstanceBorder;
        }
        Shape contour = isSubstanceBorder ? SubstanceOutlineUtilities.getBaseOutline(comp.getWidth(), comp.getHeight(), SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(comp)), null, borderDelta) : new Rectangle(0, 0, comp.getWidth(), comp.getHeight());
        g2d.setColor(backgr);
        g2d.fill(contour);
        if (toOverlayWatermark && (watermark = SubstanceCoreUtilities.getSkin(comp).getWatermark()) != null) {
            watermark.drawWatermarkImage(g2d, comp, 0, 0, comp.getWidth(), comp.getHeight());
        }
        g2d.dispose();
    }
}

