/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.colorscheme.EbonyColorScheme;
import org.jvnet.substance.colorscheme.TintColorScheme;
import org.jvnet.substance.colorscheme.ToneColorScheme;
import org.jvnet.substance.painter.border.ClassicInnerBorderPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.FlatDecorationPainter;
import org.jvnet.substance.painter.gradient.SimplisticGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.shaper.ClassicButtonShaper;
import org.jvnet.substance.watermark.SubstanceCrosshatchWatermark;

public class RavenGraphiteSkin
extends SubstanceSkin {
    public static String NAME = "Raven Graphite";

    public RavenGraphiteSkin() {
        TintColorScheme activeScheme = new TintColorScheme(new EbonyColorScheme(), 0.2){
            Color foreColor;
            {
                this.foreColor = new Color(200, 200, 200);
            }

            @Override
            public Color getForegroundColor() {
                return this.foreColor;
            }
        };
        TintColorScheme selectedDisabledScheme = new TintColorScheme(new EbonyColorScheme(), 0.2){
            Color foreColor;
            {
                this.foreColor = new Color(32, 32, 32);
            }

            @Override
            public Color getForegroundColor() {
                return this.foreColor;
            }
        };
        ToneColorScheme disabledScheme = new ToneColorScheme(new EbonyColorScheme(), 0.35){
            Color foreColor;
            {
                this.foreColor = new Color(32, 32, 32);
            }

            @Override
            public Color getForegroundColor() {
                return this.foreColor;
            }
        };
        SubstanceColorScheme defaultScheme = activeScheme.shade(0.2);
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, disabledScheme);
        defaultSchemeBundle.registerHighlightColorScheme((SubstanceColorScheme)new EbonyColorScheme(), 0.8f, new ComponentState[0]);
        defaultSchemeBundle.registerColorScheme((SubstanceColorScheme)disabledScheme, 0.5f, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme((SubstanceColorScheme)selectedDisabledScheme, 0.5f, ComponentState.DISABLED_SELECTED);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, DecorationAreaType.NONE);
        this.registerAsDecorationArea(defaultScheme, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.FOOTER, DecorationAreaType.GENERAL, DecorationAreaType.TOOLBAR);
        this.setSelectedTabFadeStart(0.3);
        this.setSelectedTabFadeEnd(0.6);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = new SubstanceCrosshatchWatermark();
        this.gradientPainter = new SimplisticGradientPainter(){

            @Override
            public Color getBottomFillColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
                return this.getMidFillColorBottom(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
            }

            @Override
            public Color getTopFillColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
                return super.getBottomFillColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation);
            }
        };
        this.decorationPainter = new FlatDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new ClassicInnerBorderPainter(0.55f, SubstanceConstants.ColorShiftKind.TONE);
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

