/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.colorscheme.BaseLightColorScheme;
import org.jvnet.substance.colorscheme.CremeColorScheme;
import org.jvnet.substance.colorscheme.LightGrayColorScheme;
import org.jvnet.substance.painter.border.ClassicInnerBorderPainter;
import org.jvnet.substance.painter.border.GlassInnerBorderPainter;
import org.jvnet.substance.painter.decoration.ArcDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.gradient.MatteGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.shaper.ClassicButtonShaper;

public class CremeCoffeeSkin
extends SubstanceSkin {
    public static String NAME = "Creme Coffee";

    public CremeCoffeeSkin() {
        ActiveScheme activeScheme = new ActiveScheme();
        CremeColorScheme defaultScheme = new CremeColorScheme();
        SubstanceColorScheme disabledScheme = new LightGrayColorScheme().tint(0.35);
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, disabledScheme);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, DecorationAreaType.NONE);
        this.registerAsDecorationArea(defaultScheme, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER, DecorationAreaType.FOOTER, DecorationAreaType.GENERAL, DecorationAreaType.TOOLBAR);
        this.buttonShaper = new ClassicButtonShaper();
        this.gradientPainter = new MatteGradientPainter();
        this.decorationPainter = new ArcDecorationPainter();
        this.borderPainter = new ClassicInnerBorderPainter(0.8f, SubstanceConstants.ColorShiftKind.TINT);
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new GlassInnerBorderPainter(0.8f, SubstanceConstants.ColorShiftKind.TINT);
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    protected static class ActiveScheme
    extends BaseLightColorScheme {
        private static final Color mainUltraLightColor = new Color(244, 229, 192);
        private static final Color mainExtraLightColor = new Color(240, 222, 179);
        private static final Color mainLightColor = new Color(235, 215, 166);
        private static final Color mainMidColor = new Color(200, 162, 110);
        private static final Color mainDarkColor = new Color(170, 131, 99);
        private static final Color mainUltraDarkColor = new Color(141, 97, 44);
        private static final Color foregroundColor = new Color(50, 34, 15);

        public ActiveScheme() {
            super("Creme Coffee Active");
        }

        @Override
        public Color getForegroundColor() {
            return foregroundColor;
        }

        @Override
        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        @Override
        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        @Override
        public Color getLightColor() {
            return mainLightColor;
        }

        @Override
        public Color getMidColor() {
            return mainMidColor;
        }

        @Override
        public Color getDarkColor() {
            return mainDarkColor;
        }

        @Override
        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }
}

