/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceColorSchemeBundle;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.colorscheme.BaseLightColorScheme;
import org.jvnet.substance.painter.border.ClassicInnerBorderPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.MarbleNoiseDecorationPainter;
import org.jvnet.substance.painter.gradient.MatteGradientPainter;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.shaper.ClassicButtonShaper;

public class AutumnSkin
extends SubstanceSkin {
    public static String NAME = "Autumn";

    public AutumnSkin() {
        DefaultScheme defaultScheme;
        ActiveScheme activeScheme = new ActiveScheme();
        DefaultScheme disabledScheme = defaultScheme = new DefaultScheme();
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, defaultScheme, disabledScheme);
        defaultSchemeBundle.registerColorScheme((SubstanceColorScheme)disabledScheme, 0.6f, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme((SubstanceColorScheme)activeScheme, 0.6f, ComponentState.DISABLED_SELECTED);
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, DecorationAreaType.NONE);
        this.registerAsDecorationArea(activeScheme, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER);
        this.setPaintingDropShadows(DecorationAreaType.TOOLBAR);
        this.buttonShaper = new ClassicButtonShaper();
        this.gradientPainter = new MatteGradientPainter();
        this.borderPainter = new ClassicInnerBorderPainter(0.8f, SubstanceConstants.ColorShiftKind.TINT);
        this.highlightPainter = new ClassicHighlightPainter();
        MarbleNoiseDecorationPainter decorationPainter = new MarbleNoiseDecorationPainter();
        decorationPainter.setPaintingSeparators(true);
        decorationPainter.setTextureAlpha(0.7f);
        this.decorationPainter = decorationPainter;
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    protected static class DefaultScheme
    extends BaseLightColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#FFF2DF");
        private static final Color mainExtraLightColor = Color.decode("#FFE3C5");
        private static final Color mainLightColor = Color.decode("#FDD1A4");
        private static final Color mainMidColor = Color.decode("#FBCD9C");
        private static final Color mainDarkColor = Color.decode("#FCC896");
        private static final Color mainUltraDarkColor = Color.decode("#AC623B");
        private static final Color foregroundColor = Color.decode("#AC623B");

        public DefaultScheme() {
            super("Autumn Default");
        }

        @Override
        public Color getForegroundColor() {
            return foregroundColor;
        }

        @Override
        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        @Override
        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        @Override
        public Color getLightColor() {
            return mainLightColor;
        }

        @Override
        public Color getMidColor() {
            return mainMidColor;
        }

        @Override
        public Color getDarkColor() {
            return mainDarkColor;
        }

        @Override
        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class ActiveScheme
    extends BaseLightColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#FDDDAC");
        private static final Color mainExtraLightColor = Color.decode("#FCEF9F");
        private static final Color mainLightColor = Color.decode("#FCD592");
        private static final Color mainMidColor = Color.decode("#F9BE84");
        private static final Color mainDarkColor = Color.decode("#F8B87A");
        private static final Color mainUltraDarkColor = Color.decode("#AC623B");
        private static final Color foregroundColor = Color.decode("#AC623B");

        public ActiveScheme() {
            super("Autumn Active");
        }

        @Override
        public Color getForegroundColor() {
            return foregroundColor;
        }

        @Override
        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        @Override
        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        @Override
        public Color getLightColor() {
            return mainLightColor;
        }

        @Override
        public Color getMidColor() {
            return mainMidColor;
        }

        @Override
        public Color getDarkColor() {
            return mainDarkColor;
        }

        @Override
        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }
}

