/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api.renderers;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceTableHeaderUI;
import org.jvnet.substance.SubstanceTableUI;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceApi;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;

@SubstanceApi
public class SubstanceDefaultTableHeaderCellRenderer
extends DefaultTableCellRenderer
implements UIResource {
    public SubstanceDefaultTableHeaderCellRenderer() {
        this.setHorizontalAlignment(0);
        this.putClientProperty("substancelaf.colorizationFactor", 1.0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table == null) {
            this.setBorder(DefaultTableCellRenderer.noFocusBorder);
            this.setValue(value);
            this.setOpaque(false);
            return this;
        }
        if (table.getTableHeader() == null) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        JTableHeader tableHeader = table.getTableHeader();
        TableHeaderUI tableHeaderUI = tableHeader.getUI();
        if (SubstanceLookAndFeel.isCurrentLookAndFeel() && tableHeaderUI instanceof SubstanceTableHeaderUI) {
            SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI)tableHeaderUI;
            ComponentState state = ui.getColumnState(column);
            ComponentState prevState = ui.getPrevColumnState(column);
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(tableHeader, state);
            Color color = SubstanceColorUtilities.getInterpolatedForegroundColor(tableHeader, Integer.valueOf(column), scheme, state, prevState, FadeKind.SELECTION, FadeKind.ROLLOVER);
            super.setForeground(new ColorUIResource(color));
        } else {
            super.setForeground(table.getForeground());
        }
        this.setBackground(tableHeader.getBackground());
        if (tableHeader.getFont() != null) {
            this.setFont(tableHeader.getFont());
        } else {
            this.setFont(table.getFont());
        }
        TableUI tableUI = table.getUI();
        if (SubstanceLookAndFeel.isCurrentLookAndFeel() && tableUI instanceof SubstanceTableUI) {
            this.setBorder(new EmptyBorder(((SubstanceTableUI)tableUI).getCellRendererInsets()));
        }
        this.setValue(value);
        this.setOpaque(false);
        this.setEnabled(tableHeader.isEnabled() && table.isEnabled());
        this.setIcon(null);
        RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
        if (rowSorter != null) {
            this.setHorizontalTextPosition(10);
            List<RowSorter.SortKey> sortKeys = rowSorter.getSortKeys();
            Icon sortIcon = null;
            SubstanceColorScheme scheme = null;
            if (tableHeaderUI instanceof SubstanceTableHeaderUI) {
                SubstanceTableHeaderUI ui = (SubstanceTableHeaderUI)tableHeaderUI;
                ComponentState state = ui.getColumnState(column);
                scheme = SubstanceColorSchemeUtilities.getColorScheme(tableHeader, state);
            } else {
                scheme = SubstanceColorSchemeUtilities.getColorScheme(tableHeader, ComponentState.DEFAULT);
            }
            if (sortKeys.size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(column)) {
                switch (sortKeys.get(0).getSortOrder()) {
                    case ASCENDING: {
                        sortIcon = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getComponentFontSize(tableHeader), 1, scheme);
                        break;
                    }
                    case DESCENDING: {
                        sortIcon = SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getComponentFontSize(tableHeader), 5, scheme);
                        break;
                    }
                    case UNSORTED: {
                        sortIcon = null;
                    }
                }
                this.setIcon(sortIcon);
            }
        }
        return this;
    }

    public static boolean isColumnSorted(JTable table, int columnIndex) {
        List<RowSorter.SortKey> sortKeys;
        RowSorter<? extends TableModel> rowSorter = table.getRowSorter();
        if (rowSorter != null && (sortKeys = rowSorter.getSortKeys()).size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(columnIndex)) {
            switch (sortKeys.get(0).getSortOrder()) {
                case ASCENDING: 
                case DESCENDING: {
                    return true;
                }
            }
        }
        return false;
    }
}

