/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceRadioButtonUI;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceCheckBoxUI
extends SubstanceRadioButtonUI {
    protected Set lafWidgets;
    private static final String propertyPrefix = "CheckBox.";
    protected FadeStateListener substanceFadeStateListener;
    protected PropertyChangeListener substancePropertyListener;
    private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceCheckBoxUI");

    public void __org__jvnet__substance__SubstanceCheckBoxUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__jvnet__substance__SubstanceCheckBoxUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceCheckBoxUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceCheckBoxUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceCheckBoxUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceCheckBoxUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    public void installListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceCheckBoxUI__installListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void installDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceCheckBoxUI__installDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    public void uninstallListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceCheckBoxUI__uninstallListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceCheckBoxUI__uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
    }

    @Override
    public void uninstallDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceCheckBoxUI__uninstallDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceCheckBoxUI((JToggleButton)comp);
    }

    private SubstanceCheckBoxUI(JToggleButton button) {
        super(button);
        button.setRolloverEnabled(true);
    }

    @Override
    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected void __org__jvnet__substance__SubstanceCheckBoxUI__installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b, false));
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceCheckBoxUI.this.substanceFadeStateListener != null) {
                        SubstanceCheckBoxUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceCheckBoxUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), SubstanceCoreUtilities.getFadeCallback(b, false));
                    SubstanceCheckBoxUI.this.substanceFadeStateListener.registerListeners();
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void __org__jvnet__substance__SubstanceCheckBoxUI__uninstallListeners(AbstractButton b) {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners(b);
    }

    protected void __org__jvnet__substance__SubstanceCheckBoxUI__installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Border border = b.getBorder();
        if (border == null || border instanceof UIResource) {
            b.setBorder(SubstanceSizeUtils.getCheckBoxBorder(SubstanceSizeUtils.getComponentFontSize(b)));
        }
    }

    private static Icon getIcon(JToggleButton button, ComponentState currState, ComponentState prevState) {
        int checkMarkSize;
        HashMapKey key;
        Icon result;
        float checkMarkVisibility = currState.isKindActive(FadeKind.SELECTION) ? 10.0f : 0.0f;
        boolean isCheckMarkFadingOut = false;
        boolean isTableRenderer = button instanceof SubstanceDefaultTableCellRenderer.BooleanRenderer;
        SubstanceColorScheme theme = SubstanceColorSchemeUtilities.getColorScheme(button, currState, isTableRenderer && currState == ComponentState.SELECTED);
        SubstanceColorScheme theme2 = prevState == currState ? theme : SubstanceColorSchemeUtilities.getColorScheme(button, prevState, isTableRenderer && currState == ComponentState.SELECTED);
        float cyclePos = 0.0f;
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)button, FadeKind.SELECTION, FadeKind.ROLLOVER, FadeKind.PRESS);
        if (fadeState != null) {
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
            if (fadeState.fadeKind == FadeKind.SELECTION) {
                checkMarkVisibility = fadeState.getFadePosition();
                isCheckMarkFadingOut = !fadeState.isFadingIn();
            }
        }
        if ((result = icons.get(key = SubstanceCoreUtilities.getHashKey(checkMarkSize = SubstanceSizeUtils.getCheckBoxMarkSize(SubstanceSizeUtils.getComponentFontSize(button)), currState.name(), prevState.name(), theme.getDisplayName(), theme2.getDisplayName(), Float.valueOf(cyclePos), Float.valueOf(checkMarkVisibility), isCheckMarkFadingOut))) != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getCheckBox(button, checkMarkSize, currState, prevState, theme, theme2, cyclePos, checkMarkVisibility, isCheckMarkFadingOut));
        icons.put(key, result);
        return result;
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    @Override
    public Icon getDefaultIcon() {
        ComponentState currState = ComponentState.getState(this.button);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.button);
        return SubstanceCheckBoxUI.getIcon(this.button, currState, prevState);
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceCheckBox: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }
}

