
package jcm.mod.resp;
import java.io.*;
import java.util.*;
import jcm.core.*;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.itf.dataholder;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.tls.fileio;
import static jcm.core.report.*;
import jcm.core.ob.module;
import jcm.mod.obj.controller;
import jcm.mod.obj.sresdata;
import static jcm.mod.obj.sresdata.scen;

/*note: this module isn't used yet elsewhere (nothing affectedby this), so might as well load data only once 
 - hence implements dataholder interface - will setup only once and for one world
 - but note precalc changes that data according to scenario - so it shouldn't be static if used! */

public class matchdata extends module implements dataholder {
    
    public enum gas  { CO2, CH4, N2O}
    public enum lbu { lower, best, upper}
    public enum sector { enin, agwa, lucf } //,  enin_agwa, all
      
    public EnumMap<gas, EnumMap<sector, EnumMap<lbu, curveset>>> emitmap;
    
   
    //******* CONSTRUCTOR ************
    public void initsetup()  {
	try {
	    makemap();
	    loaddata(scen.none);
	} catch (Exception e) { e.printStackTrace(); }
	
	setaffectedby(gm(controller.class).scenario);
    }
    
    //******** PRECALC****************
    // in response to scenario change
    public void precalc() { loaddata(); }
    
    //****** MAP OF QTSETS ************************************************************
    
    public curveset emit(Object ... oo) {
	
	gas g=gas.CO2; sector s=sector.enin;  lbu u=lbu.best; //scen n=scen.none; 
	for (Object o : oo) {
	    if (o instanceof gas) g=(gas)o;
	    if (o instanceof sector) s=(sector)o;
//	    if (o instanceof scen) n=(scen)o;
	    if (o instanceof lbu) u=(lbu)o;
	}
	
	curveset q=emitmap.get(g).get(s).get(u);
	if (q!=null) return q;
	q=new curveset(""+g+"_"+s+"_"+u, "kilo&ton&"+g, 1750, 2100); //sy(n), ey(n));
	//not sure if all of line below necessary
	q.owner=this; q.setaffectedby(this); 	curvesets.add(q); 	addOb(q); q.register();
	emitmap.get(g).get(s).put(u, q);
	return q;
    }
    
    void makemap() {
	emitmap=new EnumMap(gas.class);
	for (gas g : gas.values()) {
	    emitmap.put(g, new EnumMap(sector.class));
	    for (sector s: sector.values()) {
		emitmap.get(g).put(s, new EnumMap(lbu.class));
//		emitmap.get(g).put(s, new EnumMap(scen.class));
//		for (scen n : scen.values()) {
//		}
	    }
	}
    }
    
    //start / end years of data
    public static int sy(scen n) { return n==scen.none ? 1750 : 2000; }
    public static int ey(scen n) { return n==scen.none ? 2005 : 2100; }
    
    
//********* LOAD DATA **************************************
//could convert this to load the qtset data on demand -
//could add a param -chooser to show just one of them in the tree
    
    void loaddata() {
	scen n=gm(controller.class).scenario.chosen;
	if (n==null) { deb ("no matchdata for scenario !"); return; }
	loaddata(n);
    }
    
    void loaddata(scen n) {
	
	File f; String[][]data;
	
	InputStream is; LineNumberReader lnr;
	String line, name;
	StringTokenizer st;
	
	loop: for (gas g : gas.values()) for (lbu u: lbu.values())  for (sector s : sector.values()) {
	    //for (scen n : scen.values()) {
	    if (s==sector.lucf && (g!=gas.CO2 || !(n==scen.A1B || n==scen.B2 || n==scen.none))) continue;
	    name=g+"_"+s+"_"+u+"_"+n+".tab";
	    		
	    try {
	    data=fileio.loadtab("match-emitdata/"+name, "\t");
	    curveset qq=emit(g, u, s); //,n
	    
	    for (int i=1; i<data.length; i++) {
		name=data[i][0];
		region reg=regman.allreg.findormakereg(name, "matchdata: ");
		if (reg==null) deb("matchdata "+ name +" not in countrynames");
		curve q=qq.getOrAddCurve(reg!=null ? reg : name);
		for (int j=1; j<data[i].length; j++) {
		    q.set(j+sy(n)-1, Float.parseFloat(data[i][j]));
		}
	    }
	    } catch (Exception e) { deb(e+"\ntrying to load "+name); }
	} //for
    }
    
    

} //end class
