//mapdata: a specific GCM or baseline climatology dataset (12 months)
//see also jcm/mod/regcli.java and jcm/pan/regclimap.java

package jcm.mod.regimp;

import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.EOFException;
import jcm.core.cur.curve;
import jcm.core.data.griddata;
import jcm.core.tls.fileio;
import jcm.core.cur.*;
import jcm.core.reg.*;
import static jcm.core.report.*;



public class mapdata {
    public byte[][] o; //original data (12 months)
    public float[] r; //real/restored data
    public int nmon, nlon, nlat, tot;
    public double max, min, range, fac=1;
    public double av, sd, sum, sumsq, area;
    
    public boolean gettingdata=false;
  
    
    //unpacks files saved with "convertdata"
    public boolean getdata(String dataset, String quantity) {
	if (!gettingdata) {	//avoid recall load before finished
	    gettingdata=true;
	    boolean gotduds=dataset.equals("baseline");
	    String filename=dataset+"."+quantity+".dat";
	    try {
                String srcdir= filename.equals("had3_A2_80.tmp.dat") ? "data/" : ""; //only this default dataset is included in src/data for faster startup
		DataInputStream	datain = fileio.getDIS(srcdir+"gcmdata/"+filename);
		nmon=datain.readShort(); nlat=datain.readShort(); nlon=datain.readShort();
		min=datain.readFloat(); max=datain.readFloat();
		
		tot=nlon*nlat;
		range=(max-min);
		
		o =new byte[nmon][tot+1];
		r =new float[tot+1];
		
		if (gotduds) {
		    int i=0; int m=0; int j=0;
		    try {
			int q=0; boolean dud=false;
			
			do {
			    if (dud && j<q) {	o[m][i]=-1; i++; j++; } else {
				if (q==255) {	dud=true; j=0; q=datain.readUnsignedByte(); } else {
				    if (dud) dud=false;
				    else  {	o[m][i]=(byte)q; i++; }
				    q=datain.readUnsignedByte();
				}
			    }
			    if (i==nlat*nlon) {	i=0; m++; }
			} while (m<nmon);
			
		    } catch (EOFException e) {	deb("EOF m:"+ m + " i:"+i ); }
		}
		
		else {
		    for (int i=0; i<nmon; i++) {
			int got=0; do {	got+=datain.read(o[i],got,tot-got); } while (got<tot);
		    }
		}
		
		datain.close();
		stats();
		log("loaded "+filename+" av="+av+" sd="+sd+" min="+min+" max="+max);
		gettingdata=false;
		return true;
		
	    } catch (Exception e) {
		log("Mapdata Loading Problem: " + filename+ e.getMessage());
		log("Mapdata Loading Problem" + filename);
		for (int i=0; i<tot; i++)  for (int m=0; m<nmon; m++) o[m][i]=-1;
		gettingdata=false;
		return false;
	    }
	} //if
	return false;
    } //end run
    
    //restore one nmonth's data to original form
    public void restore(int m) {
	double f=range/254.0;
	for (int i=0; i<tot; i++){
	    if (o[m][i]==-1) r[i]=curve.dud; else r[i]= (float)( min + f* (o[m][i]>=0 ? o[m][i] : 256+o[m][i]) );
	}
	fac=1.0;
    }
    
    //calc statistics for this dataset
    public void stats() {
	double cosnlat; int k;
	sum=0; sumsq=0; area=0;
	for (int m=0; m<nmon; m++) {
	    restore(m);
	    for (int i=0; i<nlat; i++) {
		cosnlat=Math.sin((0.5+i)*Math.PI/nlat); //note sin assumes i is zero at north pole
		//area+=nlon*cosnlat;
		for (int j=0; j<nlon; j++) {
		    k=nlon*i+j;
		    if (notdud(r[k])) {
			area+=cosnlat;
			sum += cosnlat * r[k];
			sumsq += cosnlat * r[k]*r[k];
		    }
		}}}
	av=sum/area;
	sd= Math.pow((sumsq/area -av*av),0.5);
    }
    
    //scale data by a factor
    public void scaledata(double newfac) {
	double fac2=newfac/fac; fac=newfac;
	for (int i=0; i<tot; i++) if (notdud(r[i])) r[i]*=fac2;
	//			log("scaled by "+newfac);
    }
    
    public static boolean notdud (float f) { return (f>=-999 && !Float.isNaN(f)); } 
     public static boolean dud (float f) { return (f<=-999 || Float.isNaN(f)); } 
    
     
        //***************************************************
    //INTERPOLATE AVERAGE (moved from region)
    //interpolate average for each polygon, from an instance of mapdata (GCM data, baseline climatology etc)
	/*
	 may need to put back regman.allreg.resetdud(); which was called by regcli.precalc(iob) when new dataset
	public static void resetdud () {	for (Enumeration e = reg.elements() ; e.hasMoreElements() ; ((region) e.nextElement()).dud=false ); }
	 
	P1 ENH  Polygon.contains(x,y) is very inefficient for large polygons - it traces every edge segment
	So when bounding box is large, it's checking edges a long way away
	Hence map draws more efficiently with many small polygons despite increased total number of edges
	Could split into subboxes and use contains(x1,y1,x2,y2) method? but that doesn't work in MS-JVM
	name below works with both, but slow in MSJVM
	 */
    
//area=(float)(cos((Math.PI*yi)/180.0)* pow(1.8521 * 30, 2)); //IUGG equatorial radius Earth  6378.137 km, equatorial circumference 40,075 km // 1 nautical miles  = 1.852 kilometres  http://www.thetipsbank.com/convert.htm;
    
    //note this code is almost duplicated in CalcLucEmit - should generalise -also make general way of extracting areas
    //(do this by generalising mapdata to cope with biome maps?)
    
    /* average over griddata  - note todos in code!*/
    public float avg(region reg) {
	if  (reg.name.startsWith("PAC_") && reg.name.length()==6) return curve.dud;
	int xo,yo, xi, yi, xd, yd, cell;
	double area=0, sum=0, sumarea=0, dudarea=0;
	boolean inbox;
	//		makepolys(); // -only when changed - which mapplot should ensure!
	for (regpoly p : reg.polyset) {
	    Rectangle box=p.getBoundingBox();
	    
	    int step=5; // degree steps
	    for (xo=box.x; xo<(box.x+box.width); xo+=step)	{
		xd=Math.min((box.x+box.width)-xo, step);
		for (yo=box.y; yo<(box.y+box.height); yo+=step) {
		    yd=Math.min((box.y+box.height)-yo, step);
		    if (p.intersects(xo,yo,xd,yd)) {
			inbox=p.contains(xo,yo,xd,yd);
			for (yi=yo; yi<(yo+yd); yi++) {
			    area=Math.cos((Math.PI*yi)/180.0);
			    for (xi=xo; xi<(xo+xd); xi++)	{
				if (inbox || p.contains(xi,yi)) {
				    cell=findcell(xi,yi);
				    try {
					if (notdud(r[cell])) {	sum+=r[cell]*area; sumarea+=area; } else dudarea+=area;
				    } catch (NullPointerException e) { dudarea+=area; }
				}
			    }
			}
		    }
		}
	    }
	} //polys
	if (sumarea>dudarea) {	return (float)(sum/sumarea); } else { return curve.dud; }
    } //regav
    
    int findcell(int x, int y) {
	int xx=(int)(0.5+nlon*((x+360)%360)/360.0);
	int yy=(int)(0.5+nlat*(90-y)/180.0);
	return yy*nlon+xx;
    }
    
     
     
} //end class mapdata


