/** This module loads files of historical socioeconomic and emissions data and blends them together to fill some gaps.
 * The data is kept here in the original countries - the conversion to larger regions is doee in history.java using seperate curvesets 
 * This national data is never changed after startup, so there are no interactions and the curvesets are static
 * Their contents can be viewed in expert complexity level
 
 */
package jcm.mod.regemit;

import jcm.core.complexity;
import jcm.core.cur.*;
import jcm.core.data.loadtable;
import jcm.core.itf.dataholder;
import jcm.core.ob.module;
import jcm.core.reg.*;
import jcm.mod.socio.histsocdata;
import static jcm.core.data.loadtable.*;
import static jcm.core.report.*;

public class histemitdata extends module implements dataholder {
    boolean done = false;
    public static curveset //
            fosCO2 = new curveset("fosCO2", "kilo&ton&carbon", 1750, 2013, complexity.expert), //extrapolated using gdp for 2007-13
             epaCH4 = new curveset("epaCH4", "mega&ton&CH4", 1990, 2020, 5, complexity.expert), //
             epaN2O = new curveset("epaN2O", "mega&ton&N", 1990, 2020, 5, complexity.expert); //

    /*Note: this module fillhistdata must be done *after* histsocdata fills the GDP
     * Likewise, this module fillhistdata must be done before aviashipemit history
     * => put all three here
     */ 
    public void initsetup() {
        if (!done) {
            histsocdata.fillhistdata(); 
            fillhistdata();
            gm(AviaShipEmit.class).aviashiphistory();
            done = true;
        }
    }

    public static void fillhistdata() {
        loaddata(fosCO2, "data/hist/cdiacrows.csv", ",", false, 1f, 1750, 2004, 1750);

//      loaddata(fosCO2, "hist/eia_co2_emission.csv", "\t", false, 1f, 1980, 2002, 2001); //use only 2001-2
        loaddata(fosCO2, "data/hist/UNFCCC_CO2emit.csv", ",", false, 12f / 44f, 1990, 2002, 1990);    // use 1990-2002 for countries with data
        extendFos2007();
        loadtable.oldsplit(fosCO2);    // split former soviet union, czech, yugoslavia

        // original data was mega ton CO2eq, divide by GWP=23 to get mega ton CH4
        loaddata(epaCH4, "data/hist/EPA_CH4.csv", "\t", false, true, 1f / 23f, 1990, 2020, 1990, 5);

        // original data was mega ton CO2eq, divide by GWP=296 to get mega tonN2O, then multiply 14/44 for N2O=> N (for consistent units with rest of JCM, as IPCC)
        loaddata(epaN2O, "data/hist/EPA_N2O.csv", "\t", false, true, (14f / 44f) * (1f / 296f), 1990, 2020, 1990, 5);

        extrapfos13(2008, 2013);
        for (int y = 1750; y < 2014; y++) fosCO2.calctot(y);
    }

    //
    //*************** Emissions *******************
    /*
     * extension of fossil CO2 from 2004 to 2007 based on table published by MNP Netherlands 2008, derived from BP energy use statistics
     * data is from 2004 to 2007 in GtCO2 (not C)
     * note this includes cement production (unlike the previous version) - hence bigger especially in China
     * just use % change, not absolute numbers
     * have not yet applied bunker data!
     */
    static void extendFos2007() {
        double[][] d = {
            {5.84, 5.87, 5.80, 5.90}, {3.42, 3.38, 3.39, 3.32}, {1.23, 1.25, 1.23, 1.25},
            {0.56, 0.56, 0.55, 0.55}, {0.48, 0.50, 0.52, 0.51}, {1.58, 1.59, 1.67, 1.67},
            {1.57, 1.57, 1.61, 1.61}, {5.03, 5.57, 6.23, 6.72}, {1.18, 1.22, 1.28, 1.36},
            {0.36, 0.36, 0.37, 0.39}, {0.35, 0.38, 0.38, 0.37}, {1.51, 1.54, 1.56, 1.64},
            {1.04, 1.11, 1.17, 1.23}, {0.91, 0.96, 0.99, 1.05}
        };
        Object[] sets = {
            "USA", "West Europe", "Japan",
            "Canada", "Oceania", "Russia",
            new String[]{"East Europe +Ukraine", "Central Asia Stans", "Turkey"}, "China", "India",
            "Brazil",
            new String[]{"Mexico", "South Africa", "Saudi Arabia", "Iran"},
            new String[]{"Indonesia", "Singapore", "Malaysia", "Thailand", "South Korea", "Taiwan"},
            "Other", "Bunker"
        };

        ss:
        for (int i = 0; i < 12; i++) {
            if (sets[i] instanceof String) {
                extend((String) sets[i], d[i]);
                continue ss;
            }

            for (String s : (String[]) sets[i]) {
                extend(s, d[i]);
            }
        }    // ss

        for (region r : regman.nations.reg) {
            if (!(fosCO2.get(r, 2005) > 0)) {
                extend(r, d[11]);    // other
            }
        }

    // extend(regman.allreg.find("Bunker"), d[12]);
    }

    static void extend(String s, double[] d) {
        region r = regman.allreg.findreg(s);

        if (r == null) {
            deb("extendfos2006 can't find region set " + s);
            return;
        }

        if (regman.nations.contains(r)) {
            extend(r, d);
            return;
        }

        for (region rr : r.subreg(regman.nations)) {
            extend(rr, d);
        }
    }

    static void extend(region r, double[] d) {
        fosCO2.set(r, 2005, (float) (fosCO2.get(r, 2004) * d[1] / d[0]));
        fosCO2.set(r, 2006, (float) (fosCO2.get(r, 2004) * d[2] / d[0]));
        fosCO2.set(r, 2007, (float) (fosCO2.get(r, 2004) * d[3] / d[0]));
    }

    /* extrapolate fossil CO2 using GDP_PPP growth rate * emissions intensity
     * extrapolate emissions intensity assuming exponential decay(growth) calibrated from previous ten years
     * if problem with GDP data (very small countries), assume constant emissions
     */
    static void extrapfos13(int y0, int ye) {
        String lackdata = "";
        curveset GDP_PPP = histsocdata.GDP_PPP;
        for (region r : regman.nations.reg) {
            float gdp, gdp0 = GDP_PPP.get(r, y0 - 1 - 10), ei, rate = 0;
            boolean ok = true;
            ylp:
            for (int y = y0 - 1; y < ye; y++) {
                gdp = GDP_PPP.get(r, y);
                if (ok && !(gdp > 0 && gdp0 > 0)) {
                    ok = false;
                    lackdata += r.name + " ";
                }
                if (!ok) {
                    fosCO2.set(r, y + 1, fosCO2.get(r, y));
                    continue ylp;
                }
                ei = fosCO2.get(r, y) / gdp;
                if (rate == 0) rate = (float) Math.pow(ei / (fosCO2.get(r, y - 10) / gdp0), 0.1f);
                ei *= rate;
                fosCO2.set(r, y + 1, ei * GDP_PPP.get(r, y + 1));
            }
        }
        if (lackdata.length() > 0) deb("Lacking GDP data to extrapolate to 2014 for: " + lackdata);
    }
}    // end class


