//gas efficacies from Hansen et al 2005 (Ea in table 1, 2, 3) and from Ponater et al 2005 for aviation forcings

package jcm.mod.ogas;

import java.awt.Color;
import static jcm.gui.gen.colfont.*;

public enum gas {
    
    co2(black, 1f),
    ch4(green, 1.10f),
    n2o(brown, 1.04f),
    cfc(pink, 1.32f), //efficacy from CFC11&12, check same factor for HFCs?
    o3trop(grey, 0.82f),
    sulphate(cyan, 1.08f),
    bc(dkgrey, 0.68f),  //industrial 0.78, biomass 0.58
    oc(ltgrey, 0.97f), //industrial 1.03, biomass 0.93 - need to subdivide later
    volcano(orange, 0.91f), //0.33 pinatubo from table 2
    solar(yellow, 0.83f), //Lean's changefor 0.3W:m2 in table 3
    o3avia(grey, 1.37f),
    ch4avia(green, 1.18f), //efficacy aviation - check is this same as for ground source?
    h2oavia(cream, 1.14f),
    contrails(blue, 0.59f),
    cirrus(dkblue, 0.59f ) //assume same efficacy as contrails
    ;
    public Color col;
    public float efficacy;
    
    gas(Color c, float e) { col=c; efficacy=e; }
    
}
