//AEROSOLS, VOLCANO, SOLAR VARIABILITY
        /*
        note solar variability effect included with aerosols because it has short lifetime and also related to cloud seeding
        also their uncertainties are strongly coupled
         */

package jcm.mod.ogas;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import static jcm.gui.gen.colfont.*;
import static jcm.core.complexity.*;
import jcm.indata.matchdataOld;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.radfor;


public class aerosol extends module {
    
    //*******************************************************
    //INTERACTIONS
    
    
    
    //PARAMS
    public param
            sulfrf2000=new param("sulfrf2000", "w&per&m2", -1.2, -2.4, 0, cyan),
            solarrf2000=new param("solarrf2000", "w&per&m2", 0.2, 0, 0.6, orange), //checked - it's correct that 0.2 applies to 2000, = 0.12 in 2005 as in AR4
            volcfac=new param("volcfac", "", -1.0, -3.0, 0, dkorange, expert), //note negative!
            bcocwig=new param("bcocwig", false, expert),
            hadleyaero=new param("HadA", false, experimental), //added for unfccc-brazilian proposal exercise
            futuresolar=new param("futsolopt", true, expert),
            solardata=new param("solardata", new String[]{"Lean", "Hoyt&Schatten", "none"}, "Lean"),
            incvolc=new param("incvolc", true) ;
    
    //PLOTARRAYS
    public curve
            aerorf = new curve("totaerosol" ,cyan, simplest, curve.Type.total ),
            sulfdirrf=new curve( "sulfdir", blue),
            sulfindrf=new curve( "sulfind", ltblue),
            bcrf= new curve( "blackcarbon", dkgrey),
            ocrf= new curve( "orgcarbon", ltgrey),
            natvrf = new curve( "totnatvar", orange, simplest, curve.Type.total ),
            solarrf= new curve( "solvar", yellow),
            volcanorf= new curve( "volcano", dkorange); //only history!
    
    public curveset aerosol=new curveset( aerorf, sulfdirrf, sulfindrf, bcrf, ocrf, natvrf, solarrf, volcanorf, "aerosolrf", "w&per&m2", normal);
    
    //LOOP CALCS
    
    boolean firsttime=true;
    public void initsetup() {
        super.initsetup();
        follows(othgasemit.class); //this only applies to sulphate/carbon not volcano
        aerosol.associate(sulfrf2000, solarrf2000);
        gm(radfor.class).allrf.associate(sulfrf2000, solarrf2000);
        gm(radfor.class).allrf2.associate(sulfrf2000, solarrf2000);
        setaffectedby(gm(radfor.class).applyefficacy);
    }
    
    public void setinteractions() {
        setaffectedby(volcfac, incvolc.istrue());
        setaffectedby(solarrf2000, solardata.chosen!="none");
    }
    
    public void calcstep() {
        bcocrf();
        sulfrf();
        solarrf();
        volcrf();
        //can now change with efficacy -minor inefficiency to run every time
//	if (firsttime || solarrf2000.changed  || solardata.changed || futuresolar.changed) solarrf();
//	if (firsttime || volcfac.changed || incvolc.changed) volcrf();
        
        aerorf.set(year, sulfdirrf.get(year)+ sulfindrf.get(year)+ bcrf.get(year)+ocrf.get(year)); //+aircontrf.get(year) +bioburnrf.get(year); //+dustrf.get(year);
        natvrf.set(year, solarrf.get(year) +  volcanorf.get(year) ); // + albedorf.get(year)
        
    }
    
    public void postcalc() { firsttime=false; }
    
    //*******************************************************
    //SULPHATE
    
    //sulphur constants
    double se2000=69,  senat=42;
    double sdqdir2000= -0.4, sdqind2000= -0.8; //to fit TAR
    //double se1990=69, sdqdir1990= -0.3, sdqind1990= -0.8;  old figures
    
    void sulfrf() {
        if (hadleyaero.istrue()) {
            int hai=(year<1860 ? 0 : year<2100 ? year - 1860 : 240);
            sulfdirrf.set(year, (float)matchdataOld.hadleyaerosol[hai][0]); sulfindrf.set(year, (float)matchdataOld.hadleyaerosol[hai][1]);
        } else {
            sulfdirrf.set(year, (float)((sulfrf2000.getval()/(sdqdir2000+sdqind2000))*(sdqdir2000*gm(othgasemit.class).soxemit.get(year)/se2000) ));
            sulfindrf.set(year, (float)((sulfrf2000.getval()/(sdqdir2000+sdqind2000))*(sdqind2000*(Math.log(1.0+gm(othgasemit.class).soxemit.get(year)/senat)/Math.log(1.0+se2000/senat))) ));
        }
        sulfdirrf.set(year, sulfdirrf.get(year)*gm(radfor.class).getefficacy(gas.sulphate));
        sulfindrf.set(year, sulfindrf.get(year)*gm(radfor.class).getefficacy(gas.sulphate)); //check - does hansen efficacy also apply to indirect?
    }
    
    
    //**************************************
    //CARBON AEROSOLS
    
    
    void bcocrf() {
        
        //carbon aerosols -very uncertain, 2000 figures below:
        //              FF      BB
        // RF(OC, 2000) = -0.1 + (-0.4) = -0.5
        // RF(BC,2000)  = +0.2 + (+0.2) = +0.4
        
        
        if (bcocwig.istrue()) {
            //wigley magicc method scale fossil to sulphate and biomass to "gross deforestation" (both using 1990 baseline)
            float ff=gm(othgasemit.class).soxemit.get(year)/gm(othgasemit.class).soxemit.get(1990);
            float bb=(grossdefor(year)>0 ? grossdefor(year) : 0) /grossdefor(1990);
            bcrf.set(year, 0.2f*ff+0.2f*bb);
            ocrf.set(year, -0.1f*ff-0.4f*bb);
        }
        
        else {
            //joos simple scale to co
            //but why the 1036 ???
            bcrf.set(year, 0.4f*(gm(othgasemit.class).coemit.get(year)+1036f-gm(othgasemit.class).coemit.get(2000))/1036f);
            ocrf.set(year, -0.5f*(gm(othgasemit.class).coemit.get(year)+1036f-gm(othgasemit.class).coemit.get(2000))/1036f);
        }
        
        if (hadleyaero.istrue()) {	bcrf.set(year, 0); ocrf.set(year, 0); }
        
        //scale with the sulfrf paramater to allow reduce to zero
        //note correction of sign october 2004 (scaling was introduced in summer04)
        bcrf.set(year, bcrf.get(year) * (float)sulfrf2000.getval() / -1.2f);
        ocrf.set(year, ocrf.get(year) * (float)sulfrf2000.getval() / -1.2f);
        
        bcrf.set(year, bcrf.get(year) * gm(radfor.class).getefficacy(gas.bc));
        ocrf.set(year, ocrf.get(year) * gm(radfor.class).getefficacy(gas.oc));
    } //end bcocrf
    
    //for biomass bcoc aerosol -approximate to wigley's "gross deforestation":
    float grossdefor(int year) {	return gm(carboncycle.class).lucf.get(year)+5f*(year>1850 ? year<2100 ? year-1850 : 250: 0); }
    
    //******************* SOLAR ***********************
    
    //from Hoyt and Schatten, 1750-1994 + guestimate extension to 2000 - data from old JCM makedata file - should update
    double[] HoytSchattenSolar={-0.05, -0.035, -0.02, -0.005, 0.01, 0.025, 0.04, 0.055, 0.07, 0.08, 0.09, 0.054, 0.069, 0.084, 0.094, 0.16, 0.16, 0.16, 0.183, 0.207, 0.23, 0.22, 0.21, 0.2, 0.173, 0.145, 0.118, 0.09, 0.135, 0.18, 0.11, 0.033, -0.045, -0.122, -0.2, -0.19, -0.18, -0.185, -0.19, -0.22, -0.25, -0.28, -0.293, -0.306, -0.319, -0.331, -0.344, -0.357, -0.37, -0.37, -0.37, -0.362, -0.354, -0.346, -0.338, -0.33, -0.34, -0.35, -0.328, -0.306, -0.284, -0.262, -0.241, -0.219, -0.197, -0.175, -0.153, -0.131, -0.109, -0.087, -0.066, -0.044, -0.022, 0, 0.018, 0.035, 0.053, 0.07, 0.073, 0.077, 0.08, 0.05, 0.02, -0.01, 0.015, 0.04, 0.065, 0.09, 0.08, 0.07, 0.06, 0.05, 0.003, -0.045, -0.092, -0.14, -0.122, -0.105, -0.087, -0.07, -0.11, -0.15, -0.157, -0.165, -0.172, -0.18, -0.175, -0.17, -0.137, -0.103, -0.07, -0.082, -0.095, -0.107, -0.12, -0.155, -0.19, -0.19, -0.19, -0.135, -0.08, -0.094, -0.108, -0.122, -0.136, -0.15, -0.148, -0.146, -0.144, -0.142, -0.14, -0.127, -0.113, -0.1, -0.17, -0.195, -0.22, -0.245, -0.27, -0.27, -0.27, -0.247, -0.223, -0.2, -0.207, -0.213, -0.22, -0.208, -0.197, -0.185, -0.173, -0.162, -0.15, -0.12, -0.09, -0.06, -0.05, -0.04, -0.042, -0.044, -0.046, -0.048, -0.05, -0.025, 0, 0.025, 0.05, 0.075, 0.1, 0.088, 0.075, 0.063, 0.05, 0.072, 0.094, 0.116, 0.138, 0.16, 0.148, 0.136, 0.124, 0.112, 0.1, 0.12, 0.14, 0.16, 0.18, 0.2, 0.21, 0.198, 0.185, 0.173, 0.16, 0.165, 0.17, 0.235, 0.3, 0.283, 0.267, 0.25, 0.188, 0.125, 0.063, 0, 0.023, 0.047, 0.07, 0.046, 0.022, -0.002, -0.026, -0.05, -0.06, -0.07, -0.065, -0.06, -0.02, 0.02, 0.06, 0.065, 0.07, 0.04, 0.01, 0.04, 0.03, 0.02, 0.07, 0.12, 0.17, 0.22, 0.27, 0.273, 0.277, 0.28, 0.235, 0.19, 0.145, 0.1, 0.195, 0.29, 0.28, 0.24, 0.2, 0.16, 0.12, 0.10, 0.09, 0.09, 0.1, 0.12, 0.15};
    double nfH=1.0  / ( HoytSchattenSolar[250] - HoytSchattenSolar[0] );
    
    //from Lean et al. 2000, 1750-2000, W/m-2 (for perpendicular sunlight: divide by 4 for average over sphere)
    double[] LeanSolar = { 1364.6550, 1364.4856, 1364.4713, 1364.5011, 1364.4661, 1364.4956, 1364.5505, 1364.6743, 1364.7921, 1364.8596, 1364.8436, 1365.0159, 1364.9268, 1364.8948, 1364.8768, 1364.7380, 1364.7140, 1364.9026, 1365.1284, 1365.2963, 1365.3224, 1365.2742, 1365.2576, 1365.0886, 1365.0730, 1364.9504, 1364.9908, 1365.1300, 1365.3407, 1365.3878, 1365.2184, 1365.3258, 1365.0697, 1364.9484, 1364.7700, 1364.7765, 1365.0347, 1365.1556, 1365.0844, 1365.0612, 1364.9716, 1364.8311, 1364.8021, 1364.7446, 1364.6022, 1364.4440, 1364.3721, 1364.2897, 1364.2538, 1364.2601, 1364.3076, 1364.5537, 1364.4031, 1364.2324, 1364.1881, 1364.1506, 1364.0232, 1363.9309, 1363.8656, 1363.8068, 1363.7976, 1363.8395, 1363.9207, 1364.0035, 1364.0667, 1364.1497, 1364.2391, 1364.1935, 1364.1351, 1364.1268, 1364.0815, 1364.1232, 1364.2358, 1364.2893, 1364.3669, 1364.4620, 1364.5746, 1364.6865, 1364.7704, 1364.7952, 1364.8501, 1364.7161, 1364.6519, 1364.6066, 1364.6750, 1364.9484, 1365.3376, 1365.4343, 1365.2535, 1365.1826, 1365.0696, 1364.9200, 1364.8647, 1364.8060, 1364.8508, 1364.9818, 1365.0797, 1365.1847, 1365.3846, 1365.3910, 1365.1982, 1365.1567, 1365.0192, 1364.8820, 1364.7728, 1364.7249, 1364.7605, 1364.8938, 1365.0951, 1365.3092, 1365.3649, 1365.2426, 1365.0697, 1364.9423, 1364.8333, 1364.7239, 1364.6573, 1364.6069, 1364.7668, 1365.0073, 1365.2471, 1365.2012, 1365.1577, 1364.9529, 1364.7947, 1364.6147, 1364.5499, 1364.5630, 1364.5669, 1364.6174, 1364.7728, 1364.9196, 1364.9546, 1364.9996, 1364.9010, 1364.7394, 1364.5116, 1364.4189, 1364.3615, 1364.3398, 1364.3982, 1364.6823, 1364.8152, 1364.9875, 1365.1044, 1364.9883, 1364.7870, 1364.6105, 1364.5564, 1364.4856, 1364.4579, 1364.4176, 1364.4843, 1364.7440, 1365.0502, 1364.8820, 1365.0778, 1364.9320, 1364.9508, 1364.8024, 1364.6566, 1364.5870, 1364.5724, 1364.6243, 1364.7195, 1365.0414, 1365.2614, 1365.4149, 1365.3726, 1365.1373, 1364.9840, 1364.9114, 1364.8347, 1364.9006, 1364.9569, 1365.1799, 1365.2997, 1365.4958, 1365.3811, 1365.3519, 1365.3588, 1365.2800, 1365.2067, 1365.1062, 1365.2339, 1365.4572, 1365.8521, 1365.7859, 1365.7197, 1365.7096, 1365.6804, 1365.6616, 1365.6266, 1365.5270, 1365.5911, 1365.8702, 1365.9720, 1366.2172, 1366.3531, 1366.2626, 1366.0220, 1365.7882, 1365.7739, 1365.6204, 1365.6467, 1365.7719, 1366.3141, 1366.6812, 1366.6552, 1366.4130, 1366.2997, 1365.9115, 1365.7020, 1365.6451, 1365.6605, 1365.7242, 1365.9506, 1366.1831, 1366.2590, 1366.3573, 1366.3480, 1366.0192, 1366.0541, 1365.7612, 1365.6792, 1365.5020, 1365.6442, 1365.8557, 1366.3101, 1366.6769, 1366.6913, 1366.7280, 1366.2999, 1366.2001, 1365.8145, 1365.6506, 1365.6470, 1365.7990, 1366.0918, 1366.6570, 1366.5624, 1366.4547, 1366.3112, 1366.0377, 1365.8063, 1365.7087, 1365.6211, 1365.7489, 1366.1111, 1366.3942, 1366.6744};
    double nfL=1.0 / (( LeanSolar[250] -LeanSolar[0] ) / 4f); //factor to normalise to give 1 in 2000, will then multiply by solarrf2000
    
    double  scf=(2.0*Math.PI/11.0), scf2=0.25f, edf=0.03;
    
    
  /*
   note:
   IPCC TAR said solar RF in 2000 was 0.3W/m2
   IPCC AR4 says direct solar RF in 2005 was 0.12W/m2
   but the difference is partly that 2000 is closer to the peak of the 11-year cycle,
   so solar RF in 2000=0.2 and scf2=0.25, gives solar RF in 2005 = 0.12, and constant 0.15 thereafter if no future cycle
   note also that AR4 explicitly excludes potential secondary amplifying effects such as cosmic rays
   
   The fading out was added, since there is no reason to assume a permanent solar warming on a long time horizon
   P2 would be better to use the average from 1750-1900 for the normalising
   */
    
    void solarrf() {
        solarrf.set(year,
                solardata.chosen.equals("none") ? 0 :
                    (float) (
                solarrf2000.getval() * gm(radfor.class).getefficacy(gas.solar) *
                (
                year<=2000 ?
                    (solardata.chosen.equals("Lean")) ?
                        nfL * (LeanSolar[year-1750]-LeanSolar[0])/4f
                : nfH * (HoytSchattenSolar[year-1750]- HoytSchattenSolar[0])
                :   futuresolar.istrue() || year<=fsyog ? //2035
                    Math.exp(-edf*(year-2000)) * ( //fade out exponentially
                    scf2*Math.cos(scf*(year-2001)) //the cycle part
                    + ( 1f - scf2*Math.cos(scf)) //correcting for the 11yr cycle in 2000
                    )
                    : 0 //0.5  experiment change from zero jun 08 - to add 0.1 in long term
                )
                )
                );
    }
    
//******************** VOLCANO *************************
    
    double[] volcano= {0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 23, 0, 0, 0, 9, 0, 0, 0, 0, 5, 0, 4, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 4, 0, 0, 0, 0, 1, 0, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0};
    double volcdecay=0.8; //lowered from 2 to 0.8 in october 07
    double firstyeardecay=(1.0-Math.exp(-volcdecay)) / volcdecay, othyeardecay=Math.exp(-volcdecay) ;
/*
 volcano data from 1750 to 2000, transferred from old JCM histdata file, adapted from a plot in IPCC TAR
 all negative forcings *10 (i.e. 22=-2.2)
assume the values are the peak max, so much of it decays before end first year
integral of Ve(-lt) dt is -(V/l)e(-lt) so from 0 to 1  =(1-e(-lt))*V/l
 volcdecay is the decay rate (lambda) (note need *dt if not 1!),
 volcfac is a scaling factor (user-adjustable)
 JCM- TAR used volcdecay=2 and volcfac = 1.5
 fig 2.23 in AR4 WG1-Ch2 suggests that the decay needs to be slower - the effect of larger peaks lasts several years and some merge together
 
 using volcdecay => 0.8 and  volcfac => 1.5, the peak heights for Pinatubo and Krakatoa correspond well to those in fig 2.23
 but assuming that plot also shows peaks > annual average,
 it seems reasonable to lower the volcfac to 1.0, which makes a better fit to the observed temperatures around Pinatubo
 
 As the long-term average RF from volcanos should be zero (as they are random events, no trend), => 0.1 is removed to compensate
 (check this works using integral - or that volcfac has virtually no effect on 2005 temperature)
 
 Note also AR4 WG1 Ch6 Fig 6.13 and 6.14:  in 6.13  volcano RF peaks seem lower, but are smoothed over 30 years, in 6.14 temperatures were smoothed likewise
 Could be better to use volcano data directly from Amman 2003, but that is by month and latitude band - need to extract averages
 */
    
    void volcrf() {
        volcanorf.set(year,
                incvolc.istrue() ? 	  (float)(
                (year<=2000 ?   volcfac.getval() * ( -0.1 + volcano[year-1750] * 0.1 *  firstyeardecay)  : year<2007 ?  volcfac.getval() * -0.1 :  year<2027 ? volcfac.getval() * (2027-year)/20 * -0.1 : 0)
                +  (year>gsy ? volcanorf.get(year-1) * othyeardecay : 0 )
                )
                *  gm(radfor.class).getefficacy(gas.volcano)
                : 0
                );
    }
    
} //end class
