/**
 module to load and hold scenario data, which is static and unchanging
 */

package jcm.mod.obj;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import jcm.core.data.loadtable;
import jcm.core.cur.*;
import jcm.core.itf.dataholder;
import jcm.core.ob.*;
import static jcm.core.complexity.*;
import static  jcm.core.report.*;
import static jcm.mod.obj.sresdata.scen.*;

public class sresdata extends module implements dataholder  {
    
   
    //**************************************************
    
    public  void initsetup() {
        if (!gotimagedata) loadImageData();
        addcurvesets();
    }
    
    
    //********** IMAGEdata **************************
    public enum scen { A1B, A1T, A1F, A2, B1, B2, A1, IS92A, TGCIA450, CPI, none }
    public static EnumSet<scen>
            sresscen=EnumSet.of(A1B, A1T, A1F, A2, B1, B2),
            popscen =EnumSet.of(A1, A2, B2),
            gdpscen =EnumSet.of(A1, A2, B1, B2);
    
    public static Map<scen, curveset> sres_image_popn = new HashMap();
    public static Map<scen, curveset> sres_image_gdp = new HashMap();
    public static Map<scen, curveset> sres_image_fos = new HashMap();
    static boolean gotimagedata=false;
    
    static void loadImageData() {
        deb("loading image data");
        for (scen s : popscen) {
            curveset q = new curveset("pop_"+s, "mega&person", 1995, 2100, 5, expert );
            sres_image_popn.put(s, q);
            loadtable.loaddata(q, "data/sres/POP"+s+".csv", "\t", false, true, 1f, 1995, 2100, 1995, 5);
        }
        for (scen s : gdpscen) {
            curveset q = new curveset("gdp_"+s, "mega&dollar", 1995, 2100, 5, expert );
            sres_image_gdp.put(s, q);
            loadtable.loaddata(q, "data/sres/GDP"+s+".csv", "\t", false, true, 1f, 1995, 2100, 1995, 5);
            //multiply by population because data was percapita
            curveset pop=sres_image_popn.get(s==B1 ? A1 : s);
            for (Object o : q.map.keySet()) for (int y=1995; y<=2100; y+=5) try { q.set(o, y, pop.get(o,y)*q.get(o,y));  } catch (Exception e) { deb(e); }
        }
	for (scen s : sresscen) {
            curveset q = new curveset("fos_"+s, "giga&ton&carbon", 1995, 2100, 5, expert );
            sres_image_fos.put(s, q);
            loadtable.loaddata(q, "data/sres/FOS"+s+".csv", "\t", false, true, 1f, 1995, 2100, 1995, 5);
        }
        gotimagedata=true;
    }
    
    //because module won't find them automatically inside the map
    void addcurvesets() {
        for (curveset q : sres_image_popn.values())  { curvesets.add(q); addOb(q); q.owner=this; }
        for (curveset q : sres_image_gdp.values())  { curvesets.add(q); addOb(q); q.owner=this; }
	for (curveset q : sres_image_fos.values())  { curvesets.add(q); addOb(q); q.owner=this; }
    }
    
    
    //****************************
    //ARRAYS FOR INTERP, FILLED BY LOADDATA
    //item, (region,) scenario, year
    //6 SRES scenarios +IS92a
    //12 regions + world + extra
    //11 year blocks (2000-2100 in 10yr intervals)
    
    //later maybe combine similar types?
    
    //global data
    public static float[][]
            fosemit=new float[8][11],
            lucemit=new float[8][11],
            soxemit=new float[8][11],
            ch4emit=new float[8][11],
            n2oemit=new float[8][11],
            noxemit=new float[8][11],
            coemit=new float[8][11],
            vocemit=new float[8][11]
            ;
    public static float[][][] hfcemit=new float[12][7][11]; //gas, scenario, block - but why seven scenarios?
               
    //4-region, 1990-2100. region 0 is total
    public static float[][][]
           sres4luc=new float[5][6][12],
            sres4ch4=new float[5][6][12],
            sres4n2o=new float[5][6][12]
            ;
    
    //ipcc calculated data for superimposing circles
    //rf: co2bern, co2isam ch4, n2o, tropo3, hfc, cfc, sa, bcoc(isam), total
    public  static float[][][]
            rfdata=new float[10][7][11],
            sldata=new float[7][6][11]
            ;
    public  static float[][]
            bernmid=new float[7][11],
            tempchange=new float[7][11]
            ;  
    
//****************************
    //INTERPOLATION ROUTINES
    //linear interpolation between 10-year data
    //used by globco2emit, othgasemit, costs
    
    //for global data float[sc][bk]
    public static float interp(float[][] data, int sc, int year) {
        int bk=(year-2000) / 10, by=year % 10;
        try {
            return (float)((bk<10 || (sc==7 && bk<30)) ? ((double)(10-by)*data[sc][bk]+ (double)by*data[sc][bk+1]) /10f : sc==7 ? data[sc][30]  : data[sc][10] );
        } catch (Exception e) { log(e, "sres interp error: "+data+ " sc="+sc+ " bk="+bk+ " by="+by) ; return 0; }
    }
    
    
 
    
} //end class



