/* GLOBAL CO2 EMISSIONS
linker class:
takes global emissions from futbasescen and history and feeds to carboncycle,  othgasemit, shares etc. also follow this due to mitigation scaling rules
also partitions global fossil and landuse CO2  (whilst regional shares of LUC CO2 elsewhere as slow)

note todos in futureLUC => luc.todo

 */
package jcm.mod.obj;

import jcm.mod.regemit.emitbase;
import jcm.mod.obj.*;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.mod.carbon.*;
import static jcm.core.complexity.*;
import static jcm.gui.gen.colfont.*;
import jcm.mod.luc.CalcLucEmit;
import static jcm.gui.gen.colfont.*;
import jcm.mod.regemit.AviaShipEmit;

public class globco2emit extends module {    //
    //
    //*********** PARAMS ***************
    public param fosconv = new param("foshistscenconv", "percent&per&year", dkbrown, 2f, 0f, 100f, expert); //
    public param lucconv = new param("luchistscenconv", "percent&per&year", dkgreen, 5f, 0f, 100f, expert);    //
    public param potlucfrac = new param("potlucfrac", "", green, 0.5, 0, 2, expert); //fraction of accumulated luc emissions that is potential sink in one year
    public param potlucconvergence = new param("potlucfracConverg", "", green, 0.5, 0, 2, expert); //fraction of emissions/sink decrease
    public param fixedfrac = new param("fix luc fossil ratio", false, experimental);    //0 is constant offset (use SRES trend, 100 is instant SRES, in between is convergence to SRES)
    public param pulse = new param("one year pulse", 0, 0, 1000, "MtC", complexity.experimental);    //
    //
    //************** curves **************
    //
    public curve fossil,  lucquota,  totemit; //links to carboncycle, maybe move here later
    public curve //
            potlucbase = new curve("globpotlucbase", ltgreen, fsyluc, gey, expert), //
             potlucquota = new curve("globpotlucquota", dkgreen, expert), //
             fossilbase = new curve("fossilemitbase", dkred, fsyfos, gey), //
             lucfbase = new curve("lucemitbase", dkorange, 2000, gey); //2000 for houghton case
    public curveset globco2curves; //
    //
    //************  working variables ***********************
    carboncycle carb;
    curveset emitfosbase, emitlucbase; //references
    private float alpha; //note this changes with step
    public float plf;
    int sci;
    public boolean nopolicy,  houghton;
    //
    //************** SETUP ***************
    public void initsetup() {
        follows(gm(emitbase.class).history);
        follows(gm(emitbase.class).future);
        follows(sresext.class);
        //follows(gm(AviaShipEmit.class).emitmitig); //because when bunker changes, have to re-scale rest - impossible => circular calc order, actually it only applies post 2100 
        
        setaffectedby(gm(controller.class).objective);
        
        carb = gm(carboncycle.class);
        fossil = carb.fossil;
        lucquota = carb.lucf;
        totemit = carb.totemit;
        globco2curves = new curveset("globco2curves", "mega&ton&carbon&per&year", fossilbase, lucfbase, fossil, lucquota, totemit, potlucbase, potlucquota);
        potlucquota.set(gsy, 0);
        emitfosbase = gm(emitbase.class).emitfosbase;
        emitlucbase = gm(emitbase.class).emitlucbase;
        affectsfutureonly = true;
    }
    
    public void setinteractions(){
        param cob = gm(controller.class).objective;
        follows(stabilisation.class, cob.chosen.equals("stabilisation"));
        follows(optimisation.class, cob.chosen.equals("optimisation"));
    }
    
    //************** PRECALC ***********************
    public void precalc() {
        nopolicy = gm(controller.class).objective.chosen.equals("nopolicy");
        plf = -(float) (potlucfrac.getval() / 100f);
        sci = gm(controller.class).scenario.getchosenindex();
        houghton = gm(CalcLucEmit.class).lucsource.chosen.equals("Houghton");
        fsyluc = houghton ? 2001 : 2003;
    }
    //*************CALCSTEP **********************************
    public void calcstep() {

        //P3 moved from old (regional) "history" class: check interactions ok - needs to run after regemit history but before regemit future ??
        if (year > 1755 && ((gm(CalcLucEmit.class).lucsource.chosen.equals("Inverse") && year < fsyluc))) gm(carboncycle.class).inverseluc();
        //|| (get(CalcLucEmit.class).lucsource.chosen.equals("Houghton") && year<1850) //old option - now houghton scaled back to 1750 (starting at 0 in 1700)
        else if (year < fsyluc) lucquota.set(gm(emitbase.class).emitlucbase.calctot());
        if (year < fsyluc) totemit.set(fossil.get() + lucquota.get());


        //potluc: based on fraction of cululative lucf emissions, including history
        if (year > gsy) potlucquota.set(potlucquota.get(year - 1) + lucquota.get(year - 1) * plf);

        /*
        SRES period
        
        SCALING emitfosbase, note:
        sres4 data was not consistent with TAR sres totals (due to correction in TAR)
        old regional data from IMAGE12 was saved as a fraction of 1000, need to apply topdownscale to total (exc bunker) to correct this
        fossil scaling will affect sres extension and hence global total post 2100, but does not need to precede sresext in loop
        
        note emitlucbase must be calculated in futureLUC as it uses potentials for interpolating as well as SRES4
        note CH4 and N2O  top-down scaling  done in othgasemit and shares
        
        P2 STRUC in principle scaling in the wrong place, since only changes when futbasescen changes
        could have 4 modules: globco2base, globco2pol, regco2base, regco2pol (and for each, also LUC/fossil... - especially for regpol),   but also consider sresext...
        
        separation helps to remove aviashipemit affects futbasescen, i.e. re-use regional emitfosbase without re-interpolating (slow)
        fossilbase is only changed by sres.fosemit and globalcorrfac, which is not changed by future bunker
        the topdownscale subtracts bunker from the fossilbase, and scales the rest
        
        Blending bunker with SRES via topdownscale:
        "true" implies scale all *except* bunker to fit the required total - the concept is that bunker has been implicitly included in SRES, so we need to remove it proportionally
        note that for low SRES (B1 and A1T) this still produces unreasonable results (unless combine with a low aviation scenario)
        maybe would be better to scale according to fraction of corresponding SRES scenario (eg Fa1:IS92A etc.)
        
        note emitfosquota is set in shares, which starts by copying emitfosbase, and later scaling down by same factor as below
        
        note, (only) after 2100, sresext applies a bottom up approach, so higher aviation scenario => higher total,
        but not so much higher because other regional emissions started from lower base (since total fixed before 2100)
        
        note: it seems that switching scaledown on /off doesn't preserve the total CO2 emissions
        - actually this is correct, due to feedbacks from aviation non-CO2 gases affecting the temperature and hence the carbon sinks
        
         */

        //if (year>=2000 & year<fsyfos) { fossilbase.set(emitfosbase.calctot()); fossil.set(fossilbase.get()); }

        if (year >= fsyfos && year <= 2100) {
            //fix total using original SRES data (total different from that of IMAGE used for regional emitfosbase) 
            //but combined with same convergence factor as for emitfosbase
            fossilbase.set((float) (1000f * sresdata.interp(sresdata.fosemit, sci, year) + (1f - fosconv.getval() / 100f) * ((year == fsyfos ? emitfosbase.calctot(year - 1) : fossilbase.get(year - 1)) - 1000f * sresdata.interp(sresdata.fosemit, sci, year - 1))));
            emitfosbase.topdownscale(fossilbase.get(), true); //true implies exclude bunker - don't scale that 
        }

        if (year >= 2000 && year < fsyluc) {  //case ivig or 2000 for houghton - use 5 year moving average of history
            float a = 0;
            for (int i = -5; i < 0; i++) a += lucquota.get(year + i);
            lucfbase.set(a / 5f);
        }

        if (year >= fsyluc && year <= 2100) {
            lucfbase.set((float) (1000f * sresdata.interp(sresdata.lucemit, sci, year) + (1f - lucconv.getval() / 100f) * (lucfbase.get(year - 1) - 1000f * sresdata.interp(sresdata.lucemit, sci, year - 1))));
        } //year sres



        //note: fsyluc can be earlier than fsyfos with houghton
        if (year >= fsyluc && year < fsyfos) {
            lucquota.set(lucfbase.get());
            totemit.set(fossil.get() + lucquota.get());
        }


        if (year > 2100) {
            //after 2100, it's a top-down approach follwoing sresext (and aviaship)
            fossilbase.set(emitfosbase.calctot());
            //after 2100, lucbase converges towards potlucbase
            float fac = lucfbase.get(year - 1) < potlucbase.get(year - 1) ? 1f : (float) potlucconvergence.getval() / 100f;
            lucfbase.set(fac * potlucbase.get(year - 1) + (1f - fac) * lucfbase.get(year - 1));
        }

        //presuming fsyluc is earlier than fsyfos!
        if (year >= fsyluc)
            potlucbase.set(year == fsyluc ? potlucquota.get() : potlucbase.get(year - 1) + lucfbase.get() * plf);

        //calculate mitigation: proportional to fossil mitigation (relative to base)
        if (year >= fsyfos) {

            alpha = (lucfbase.get() - potlucbase.get()) / fossilbase.get();

            // old note "note this has to be corrected by adding the bunker fuels in aviaShipEmit - which runs after this!"-  hope false now - aviaShipEmit baseline runs before this , and mitig after
            if (nopolicy) {
                fossil.set(fossilbase.get());
                lucquota.set(lucfbase.get());
                totemit.set(fossilbase.get() + lucfbase.get());

            } else { //stabilisation or optimisation, assume totemit has been set

                lucquota.set(
                        fixedfrac.istrue() ? totemit.get() * lucquota.get(fsyfos - 1) / totemit.get(fsyfos - 1)
                        : (totemit.get() * alpha + potlucquota.get()) / (1f + alpha));

                fossil.set(totemit.get() - lucquota.get());

                if (fossil.get() < 0) {
                    fossil.set(0);
                    lucquota.set(totemit.get());
                }
                // added restraint on LUC emissions can't go less than potlucquota
                // in this case totemit is changed!
                if (lucquota.get() < potlucquota.get()) {
                    lucquota.set(potlucquota.get());
                    totemit.set(lucquota.get() + fossil.get());
                }
            }

        }  //y>fsy

        if (year == 2010) {
            totemit.set(totemit.get() + (float) pulse.getval());  //note also effect measured in radfor
        }
    } //calcstep
}  // end class
