/*
 * interp1D.java
 */
package jcm.mod.math;

import java.lang.reflect.Array;

/**
 * store 1D data vectors and allow linear interpolation from these
 * Very stupid algorithm, did not take time for it.
 */
public class interp1D {
    private float [] xs, ys;
    
    /** Creates a new instance of interp1D */
    public  interp1D(float set_xs[], float set_ys[]) {
       xs=new float [set_xs.length];
       ys=new float [set_ys.length];
       System.arraycopy(set_xs,0,xs,0,set_xs.length);
       System.arraycopy(set_ys,0,ys,0,set_ys.length); 
    }
    
    /** Basic stupid search function (not efficient, may be improved) */
    public int search1D(float xx, float[]xvals) {
        for (int ii=0; ii<(xvals.length-2); ii++) {
            if (xvals[ii]<=xx && xvals[ii+1]>=xx) {
                return ii;
            }
        }
        if (xx<xs[0]) return 0;
        else return xs.length-2;
    }
    
    /** Gets 1D interpolated value from data */
    public float getLin(float xx) {
        float yy;
        int ilow;
        ilow=search1D(xx,xs);
        yy=ys[ilow]+ (ys[ilow+1]-ys[ilow]) * (xx-xs[ilow]) / (xs[ilow+1]-xs[ilow]);
        return yy ;
    }
    /** Gets 1D interpolated value from data - inverse */
    public float getInvLin(float yy) {
        float xx;
        int ilow;
        ilow=search1D(yy,ys);
        xx=xs[ilow]+ (xs[ilow+1]-xs[ilow]) * (yy-ys[ilow]) / (ys[ilow+1]-ys[ilow]);
        return xx ;
    }
    
}