package jcm.mod.cli;
import jcm.core.*;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import static jcm.gui.gen.colfont.*;
import java.awt.Color;
import Jama.*; //this is the java matrix package for calculating eigenvectors, inverses etc.

public class oceantemp extends module  {
    
 	/*
	this module just includes the extra curves and calcs needed for an ocean temp plot
	separated from the main calc in get(glotemp.class) because multiplying out the whole matrix is rather slow
	 */
    
  public void initsetup() {
        follows(gm(glotemp.class));
        register.requires(this, gm(glotemp.class), true); //see explanatory note in carbonstorage initsetup - same concept
        makecurves();
    }
    

    //"real" box contents for viewbox  -beware about 150K memory!
    int nhb=udebclimod.nhb;
    public float[][] hq=new float[2*nhb][gey-gsy+2];
    
    public void changeendyear(int oldey, int newey) { hq=new float[2*nhb][newey-gsy+2]; }
    
    
    //curves for plotting
    public curve[] curve=new curve[hq.length];
    public curveset oceantemp=new curveset("oceantempcurves", "degc");
    
 
  
       //note the surface boxes moved from end to beginning of array
    void makecurves() {
        	int cd=(int)(gm(udebclimod.class).val(udebclimod.cp.mixlaydepth)), cd2;
	for (int i=0; i<(nhb-1); i++) {
	    int r= (int) (127+127.0*Math.cos((Math.PI*2)*0.3*i/nhb));
	    int b= (int) (127+127.0*Math.cos((Math.PI*2)*(i-nhb/2)/nhb));
	    cd2=cd+(i<20 ? 49 :196);
	    cd=cd2;
	    curve[i+1]=new curve(hq[i], "N_"+cd+"-"+cd2+"m", new Color(r,0,b));
	    curve[i+nhb+1]=new curve(hq[i+nhb], "S_"+cd+"-"+cd2+"m", new Color(0,r,b));
	}
	
	curve[0]=new curve(hq[nhb-1], "N surface", red);
	curve[nhb]=new curve(hq[nhb+nhb-1], "S surface", green);
	for (curve q : curve) oceantemp.addcurve(q);
    }
    
    //********************************************
    
    public void calcstep() {
	//below is whole matrix multiplication : beware will be slow - so should only calc if needed for plot/table
	for (int o=0; o<2; o++) {	for (int n=0; n<nhb; n++) {
	    hq[n+o*nhb][year-gsy]=0; for (int m=0; m<nhb; m++) hq[n+o*nhb][year-gsy]+=gm(udebclimod.class).MV[o].getArray()[n][m]*gm(udebclimod.class).hiq[o][m];
	    //convert units from heat to temp
	    hq[n+o*nhb][year-gsy]/=(gm(udebclimod.class).qpt*(n<(nhb-1) ? gm(udebclimod.class).dl[n]/gm(udebclimod.class).val(udebclimod.cp.mixlaydepth) : 1) );
	}}
    } //calcstep
    
    
} //end class
