

package jcm.gui.plot;

import java.awt.*;
import java.awt.event.*;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.*;
import javax.swing.event.*;

import jcm.core.*;
import jcm.core.par.param;
import jcm.core.cur.curveset;
import jcm.core.itf.menuFiller;
import jcm.core.itf.plotlink;
import jcm.core.reg.mapprojection;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.ob.interacob;
import jcm.gui.doc.*;
import jcm.gui.nav.*;
import jcm.gui.gen.*;
import jcm.mod.obj.regset;
import static jcm.core.report.*;

public class mapplot extends JPanel   {
    
    //********************* FIELDS *********************
    public param startlon=new param("mapstartlongitude", "degrees", 349, 0, 360)  ;
    public param projection=mapprojection.getparam();
    public param<region> regions;
    
    mapprojection getprojection() { return  (mapprojection)(projection.chosen); }
    interacob source;
    colormap cm;
    colorscale cols;
    
    JPanel intpan;
    
    boolean ownregions=false;
    
    //******************** CONSTRUCT ************************
    
    public mapplot(interacob io) {
	source=io;
	if (source instanceof colormap) cm=(colormap)source;
	setName(labman.getTitle(source.getNameWithWorld()+"&map"));
	if  (source instanceof param)   regions= (param<region>)source;
	if (source instanceof curveset) { cm=new qtsetcolormap((curveset)source); regions=source.getworld().gm(regset.class).regions; }
	if (regions==null) { regions=regman.makeregionparam("mapregions","ALL"); ownregions=true; }
	setToolTipText(getName());
	setPreferredSize(new Dimension(400,300));
	setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
	setLayout(new BorderLayout());
	
	JMenuBar mb =new JMenuBar();
	mb.add(projection.getMenuItem());
	mb.add(regions.getMenuItem());
	
	intpan=new JPanel(); intpan.setLayout(new BorderLayout());
	
	if (cm!=null)  {
	    deb("making colorscale from "+cm);
	    cm.resetscale();
	    cols= new colorscale(cm);
	    mb.add(cols.reset);
	    intpan.add(cols, BorderLayout.SOUTH);
	    if (cm instanceof qtsetcolormap) mb.add( ((qtsetcolormap)cm).year.getComponent() );
	}
	
	add(mb, BorderLayout.NORTH);
	map map=new map(); //after made colorscale!
	intpan.add(map);
	add(intpan);
	map.ready=true;
    }
    
    public void addNotify() {
	super.addNotify();
	deb("map addNotify - will call loop");
	loop.golater("Map Shown");
    }
    
    
    public void removeNotify() {  //called when plot is closed
	super.removeNotify();
	if (showpan.moulist.carrying!=this) {
	    projection.disposeLater(); startlon.disposeLater();
	    if (ownregions) regions.disposeLater();
	}
	loop.golater("Map Removed");
    }
    
    
    
// *********** MAP ***************
    class map extends JPanel implements MouseInputListener, plotlink, menuFiller {
	
	boolean  firsttime=true, ready=false,   inside=false;
	
	//temporary store of polygons and colors, for faster replotting when one or other doesn't  change
	Map<region, Set<Polygon>> plotpoly=new HashMap();
	Map<region, Color> plotcolor=new HashMap(); //note not used if region param map
	
	int ow=0, oh=0;
	double mx, oldmx, my;
	JLabel info=new JLabel();
	
	
	map() {
	    setLayout(null);
	    setBackground(Color.white);
	    add(info);
	    addMouseListener(this);
	    addMouseMotionListener(this);
	    new jcmMenu(this);
	    register.addlink(this, regions, projection, startlon, source);
	    if (cm!=null)   { register.addlink(this, cols.sp); deb("map linked to sp"); }
	    if (cm!=null && (cm instanceof qtsetcolormap)) register.addlink(this, ((qtsetcolormap)cm).year);
	    loop.gonow();
	}
	
	public void doplot() {  if (ready) {
	    if (firsttime) { cols.resetAction.act(); } //cols.resetcols(); cols.repaint();  }
	    makepolys(); repaint();
	}}
	//beware: repaint only calls paintcomponent AFTER the loop finished so changed flags reset! therefore call makepolys first
	
	//note doesn't seem to be showing as soon as one might expect - leads to problem with interactions - hence added addNotify
	//deb("called map isShowing "+!ready+" "+super.isShowing()); 
	public boolean isShowing(){ return (!ready || super.isShowing()); } //so loop.go has an effect, before its showing
	
	
	
	//*********** PAINT POLYS ****************
	//for efficiency, only remake polygons and colors when changed
	void makepolys() {
	    int w=getWidth(), h=getHeight();
	    java.util.List<region> rs=regions.chosen.reg;
	    
	    boolean sizechanged=(w!=ow) || (h!=oh) || startlon.changed || projection.changed;
	    boolean regchanged=firsttime || regions.changed; //note: when regions is borrowed from another module, can be false when this map is created
	    boolean colorschanged=(cm!=null) && (cols.sp.changed || regchanged || source.changed  || (cm instanceof qtsetcolormap && ((qtsetcolormap)cm).year.changed));
	    
	    if (sizechanged)    { getprojection().setsize(0, 0, w, h , (int)startlon.val);   }
	    ow=w; oh=h;
	    
	    if(regchanged ) {
		regions.chosen.makepolys();
		for (region r : rs)   r.makepolys();
		plotpoly.clear();  for (region r : rs)  plotpoly.put(r, new HashSet());
		plotcolor.clear();
	    }
	    
	    if (regchanged || sizechanged) {
		mapprojection mp=getprojection();
		for (region r : rs) plotpoly.get(r).clear();
		for (region r : rs)   for (Polygon p : r.polyset) { plotpoly.get(r).add(mp.translate(p));   }
	    }
	    
	    if (colorschanged) { for (region r : rs) plotcolor.put(r, cols.getColor(cm.getValue(r))); }
	    
	    firsttime=false;
	} //makepolys
	
	public void paintComponent(Graphics g) {
	    super.paintComponent(g); //paint background
	    lookandfeel.setAntiAlias(g);
	    makepolys();
	    region rs=(region)(regions.chosen);
	    
	    for (region r : rs.reg)  {
		g.setColor( (cm!=null) ? plotcolor.get(r) : r.getColor());
		for (Polygon p : plotpoly.get(r)) try {  g.fillPolygon(p);  } catch (Exception e) {  deb(e, "mapplot problem plotting "+r.name);  } 
	    }
	    
	    for (region r : rs.reg) { 
	    g.setColor( (cm!=null) ? Color.black : r.getColor().darker());
		for (Polygon p : plotpoly.get(r))    try { g.drawPolygon(p);  } catch (Exception e) { }
	    }
	    
	} //paint
	
//***********************************
//Event handling
	
	public void mouseDragged(MouseEvent e) {
	    findpos(e);
	    if (inside) {
		startlon.val=(int)(((int)startlon.val+(mx-oldmx)+360)%360);
		startlon.respond(true); //doesn't work because not output!
	    }
	}
	
	public void mouseMoved(MouseEvent e) {  findpos(e); if (inside) writepos();  }
// if (inside) {	cleartext(); writepos(); leftmap=false; } else  {	if (!leftmap) cleartext(); leftmap=true; }
	public void mousePressed(MouseEvent e) {  findpos(e); if (inside) oldmx=mx; }
	public void mouseReleased(MouseEvent e) {	 }
	public void mouseClicked(MouseEvent e) {	}
	public void mouseExited(MouseEvent e) {	}
	public void mouseEntered(MouseEvent e) {	}
	
	
	//************** POPUP**********
	public void fillMenu(jcmMenu popup) {
	    popup.add(imagesaver.copyaction(intpan));
	    popup.add(imagesaver.saveimagemenu(intpan, "JCM-map"));
	    popup.add(showpan.pan("Show doc", docview.class, "mapplot") );
	}
	
//**********************************
//FIND/WRITE POS
	region insidereg;
	
	void findpos(MouseEvent e) { findpos(e.getX(), e.getY()); }
	void findpos(int x, int y) {	//work out lat & lon corresponding to mouse position
	    Point p=getprojection().translateback(x,y);
	    mx=p.x; my=p.y;
	    inside= (my<90 && my>-90 && mx<180.0 && mx>-180);
	    insidereg= findreg(x,y);
	    info.setLocation(x+4, y+4);
	}
	
	public region findreg(int x, int y) {
	    for(region r : ((region)(regions.chosen)).reg) if (r.contains(getprojection().translateback(x,y))) return r;
	    //for grid can do directly without check contains!
	    return null;
	}
	
	public void writepos() {
	    info.setText( inside ? (latlon()+" "+  ( insidereg!=null ? insidereg.getName() +((cm!=null) ? " "+cm.getMapInfo(insidereg) : "" ) : "" )) : "") ;
	    info.setSize(info.getPreferredSize());
	}
	
	public String latlon() { return (int)Math.abs(my)+ ( my>0 ? " N" : " S") + " "+ (int)Math.abs(mx)+ ( mx>0 ? " E" : " W"); }
	
    } //map
}  //end class


