
package jcm.gui.plot;

import java.awt.*;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jcm.core.loop;
import jcm.core.par.param;
import static jcm.core.report.*;
import static java.lang.Math.*;

public class arrow {
    
    param parx, pary, xscale, yscale;
    JPanel plot;
    type t=type.square;
    int xi,yi;
    Polygon poly;
    
    public arrow(param p, param x, param y, JPanel pan) {
	plot=pan; xscale=x; yscale=y;
	deb(p.name+" "+p.units.units+" "+y.units.units+" "+p.units.sameAs(y.units));
	if (p.units.sameAs(yscale.units)) {
	    pary=p;
	    if (p.pair!=null) { t=type.nsew; parx=p.pair;   } else {  t=type.leftarrow;   }
	} else { t=type.downarrow; parx=p; } //if (p.units.sameAs(xscale.units)) 
	poly=new Polygon();
    }
    
    boolean checkenabled() { return (pary!=null ? pary.checkneededforplot() : parx!=null ? parx.checkneededforplot() : false); }
    
    public void getpos() {
	xi=parx!=null ? (int)(plot.getWidth()*(parx.getval() - xscale.min())/xscale.range()) : 0;
	yi= pary!=null ? (int)(plot.getHeight()*(yscale.max() -pary.getval())/yscale.range()) : plot.getHeight();
	poly.reset();
	for (int i=0; i<t.p.length-1; i+=2) {
	    poly.addPoint(xi+t.p[i], yi+t.p[i+1]);
	}
    }
    
    public String getinfo() { 
	return "<html> "+(pary!=null ? pary.hashcolor() +pary.getinfo() +(parx!=null ? "<br>"+parx.getinfo() : "" ) : parx.hashcolor() +parx.getinfo())+" </font>"; 
    }
    
    public void draw(Graphics g) {
	draw2(g, pary!=null ? pary.getColor() : parx.getColor());
    }
    public void draw2(Graphics g, Color c) {
	g.setColor(c);
	g.fillPolygon(poly);
	g.setColor(Color.black);
	g.drawPolygon(poly);
    }
    
    public void move(int x, int y) {
	 draw2(plot.getGraphics(), plot.getBackground());
	if (parx!=null) { parx.val=(xscale.min()+xscale.range()* x / plot.getWidth() ); if (parx.val<parx.min) parx.val=parx.min; if (parx.val>parx.max) parx.val=parx.max;  parx.report(); parx.changed=true; }
	if (pary!=null) { pary.val=(yscale.max()-yscale.range()* y / plot.getHeight() );if (pary.val<pary.min) pary.val=pary.min; if (pary.val>pary.max) pary.val=pary.max;  pary.report(); pary.changed=true; }
	getpos(); draw(plot.getGraphics());
        loop.golater("Arrow moved", false); 
    }
    
    //***************************
    enum type {
	square(0,0,20,0,20,20,0,20),
	uptriangle(0,0,15,30,-15,30,0,0),
	downtriangle(0,0,15,-30,-15,-30,0,0),
	lefttriangle(0,0,30,15,30,-15,0,0),
	righttriangle(0,0,-30,15,-30,-15,0,0),
	leftarrow(0,0,20,20,20,10,40,10,40,-10,20,-10,20,-20,0,0),
	rightarrow(0,0,-20,20,-20,10,-40,10,-40,-10,-20,-10,-20,-20,0,0),
	uparrow(0,0,20,20,10,20,10,40,-10,40,-10,20,-20,20,0,0),
	downarrow(0,0,20,-20,10,-20,10,-40,-10,-40,-10,-20,-20,-20,0,0),
	nsew( -5,5,-5,20,-10,20,0,30,10,20,5,20,5,5,20,5,20,10,30,0,20,-10,20,-5,5,-5,5,-20,10,-20,0,-30,-10,-20,-5,-20,-5,-5,-20,-5,-20,-10,-30,0,-20,10,-20,5,-5,5),
	ns(-5,20,-10,20,0,30,10,20,5,20,5,-20,10,-20,0,-30,-10,-20,-5,-20,-5,20),
	ew(20,5,20,10,30,0,20,-10,20,-5,-20,-5,-20,-10,-30,0,-20,10,-20,5,20,5);
	
	int[] p;
	type(int ... i) { p=i; } //String s= this.name(); for (int j : p) s+=" "+j; System.err.println(s);}
	
    }
    //***************************
    
    
}
