
   /*
    FILTER for menus and trees
    */
 

package jcm.gui.nav;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import jcm.core.*;
import jcm.core.itf.plotlink;
import jcm.core.par.param;
import jcm.gui.doc.labman;
import jcm.gui.gen.iconFinder;
import static jcm.gui.nav.filter.filtertype;
import static jcm.gui.nav.filter.filtertype.*;
import jcm.gui.nav.filter.filtertype;
import static jcm.core.complexity.*;
import jcm.gui.gen.Gauge;

public class filter {
    
    public enum filtertype {
	NeededParams(simplest), AllParams(expert), Curves(simplest), Worlds(expert), Maps(simplest), interacmap(normal), Doc(simplest), Source(expert),  Data(expert), Scripts(expert), Tree(experimental);
	public complexity mycomplexity;
	filtertype(complexity c) { mycomplexity=c; }
    }
    
    
    // ***************** FILTER TOOLBAR / BUTTON **************
    
    public static FilterToolBar getToolBar(Set<filtertype> ff, plotlink pl, param<complexity> cp) { return new FilterToolBar(ff, pl, cp); }
    
    public static Set<filtertype> all() { return EnumSet.allOf(filtertype.class); }
    
} //filter class

class FilterToolBar extends JToolBar implements plotlink {
    
    Map<filtertype, FilterButton> butmap=new EnumMap(filtertype.class);
    Set<filtertype> filters;
    plotlink link;
    param<complexity> level;
    
    FilterToolBar(Set<filtertype> ff, plotlink pl, param<complexity> cp) {
	filters=ff; link=pl; level=cp;
	fillTb();
	register.addlink(this, level);
    }
    
    void fillTb() {
	Gauge g=new Gauge(level);
	add(g); g.setAlignmentX(Component.LEFT_ALIGNMENT);
	for (filtertype f : filtertype.values()) if (complexity.check(f.mycomplexity, level.chosen)) { FilterButton fb= new FilterButton(f); add(fb); butmap.put(f, fb); }
//	add(Box.createHorizontalGlue());
//	add(level.getComponent(false));
//	paramMenu pm=; pm.lab.setText(" "); pm.setPreferredSize(pm.cb.getMinimumSize());	add(pm);
    }
    
    public void doplot() { removeAll(); butmap.clear(); fillTb(); revalidate();  repaint(); }
    
    class FilterButton extends JToggleButton implements ActionListener {
	filtertype myf;
	FilterButton(filtertype f) {
	    super( iconFinder.findIcon(f), filters.contains(f));
	    myf=f;
	    addActionListener(this);
	    setMaximumSize(new Dimension(28,26));
	    setPreferredSize(new Dimension(28,26));
	    setToolTipText(labman.getTitle(f.toString()));
	}
	public void actionPerformed(ActionEvent e) {
	    if (isSelected()) filters.add(myf); else filters.remove(myf);
	    if (myf==AllParams && isSelected()) { filters.add(NeededParams); butmap.get(NeededParams).setSelected(true); }
	    if (myf==NeededParams && !isSelected()) { filters.remove(AllParams); if (butmap.containsKey(AllParams)) butmap.get(AllParams).setSelected(false); }
	    link.doplot();
	}
    }
    
} //toolBar class



