/*
P1 ENH Circmenu enhancements:
 expanding pie slices
 a tree model - so can open/close branches (and keep those you want open)
 a treemap structure (areas with subareas)
 use the treemodel of treemaker
 reduce clicks - to open, release (maybe after new click outside init button) to close
 */


package jcm.gui.nav;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import jcm.core.*;
import jcm.core.ob.*;
import jcm.gui.*;
import static jcm.gui.gen.colfont.*;
import jcm.gui.gen.iconFinder;

public class circmenu extends JComponent implements  MouseInputListener {
    
    infob start;
    Area selected;
    boolean paint=true;
    
    Map<Area, Object> segs =new HashMap();
    
    //constructor
    public circmenu(infob o) { this(o, 0, null); }
    public circmenu(infob o, float angle, infob back) {
	start=o;
	Dimension d=new Dimension(200, 200);
	setSize(d);
	setPreferredSize(d);
	setLayout(null);
	addMouseListener(this);
	addMouseMotionListener(this);
	setOpaque(false);
	
	Collection sub=subItems(o);
	if (back !=null) sub.add(back);
	
	float step=360f/sub.size();
	float in=40, out=100;
	
	Area inner=new Area(new Arc2D.Float(out-in, out-in, in*2, in*2, 0, 360, Arc2D.PIE));
	segs.put(inner, o);
	
	for (Object me : sub )   {
	    Area pie=new Area(new Arc2D.Float(0, 0, out*2, out*2, angle, step, Arc2D.PIE));
	    pie.subtract(inner);
	    segs.put(pie, me);
	    angle+=step;
	}
	/* this works but looks a mess
	for (Area a : segs.keySet()) {
	    Object oo =segs.get(a); Rectangle r=a.getBounds();
	    if (subItems(oo)==null  && oo instanceof hasinfo) {
		Component co=add(((hasinfo)oo).getSmall());
		co.setLocation(new Point(r.x, r.y));
		co.setSize(co.getPreferredSize());
		co.show();
	    }
	}
	 */
    } //constructor
    
    public Collection subItems(infob o) {
	Collection c=new ArrayList();
	if (o.getObs()!=null)
	    for (infob me : o.getObs())  if (subItems(me)!=null) c.add(me) ;
	    if (o.actions!=null) for (Action a : o.actions.keySet()) c.add(a);
	    if (c.size()>0) return c;
	    return null;
    }
    
    
    public void paintComponent(Graphics g) {
	Graphics2D g2= (Graphics2D) g;
	if (paint) {
	    for (Area a : segs.keySet()) {
		Object o =segs.get(a);
		Color c= (o instanceof infob) ? ((infob)o).getColor() : infob.rcol();
		c=new Color(c.getRed(), c.getGreen(), c.getBlue(), 128);
		g2.setColor( selected==a  ? c.brighter() : c );
		g2.fill(a);
		g2.setFont(bigfont);
		g2.setColor(black);
		Rectangle r=a.getBounds();
		//if (subItems(o)!=null && subItems(o).size()>0) {
		String s=o instanceof infob ? ((infob)o).getLabel() : o instanceof Action ?  ((Action)o).getValue(Action.NAME).toString()  : o.toString();
		if (iconFinder.findIcon(s)!=null) iconFinder.findIcon(s).paintIcon(this, g,  r.x+r.width/2-10, r.y+r.height/2);
		g2.drawString(s, r.x+r.width/2-20, r.y+r.height/2-5);
	    }
	}
    }
    
    Color subcol(Color c, float f) { return new Color(rand(c.getRed(), f), rand(c.getGreen(), f), rand(c.getBlue(), f));    }
    int rand(int x, float f) { return (int)(x+(255-x)*Math.random()/f-x*Math.random()/f); }
    
    
    public void  mouseClicked(MouseEvent e) {
	for (Area a : segs.keySet()) if (a.contains(e.getPoint())) {
	    final Object o =segs.get(a);
	    Container c=getRootPane().getParent();
	    Point p= c instanceof WindowConstants? getLocation() : c.getLocation();
	    int mx=e.getPoint().x-getSize().width/2, my=e.getPoint().y-getSize().height/2;
	    final Point z=new Point(p.x+ mx, p.y+my );
	    float angle=(float) (  ( (Math.atan((float)my/(float)mx)*180f/Math.PI)+(mx<0 ? 180 : 360 ) ) % 360 );
	    
	    
	    //this works, but new components hang around forever
	    if (o instanceof infob) {
		infob i=(infob)o;
		final JComponent newc=
			subItems(i)!=null && subItems(i).size()>0  ? new circmenu(i, angle, start) : i.getComponent();
		if (newc!=null) {
		    paint=false; getRootPane().repaint();
		    SwingUtilities.invokeLater(new Runnable() {  public void run() {
			newc.setSize(newc.getPreferredSize());
			showpan.addwindow(newc ,z ); close();
		    }});
		}
	    }
	    
	    if (o instanceof Action)  {
		((Action)o).actionPerformed(new ActionEvent(this, 0, null));
		close();
	    }
	}
    }
    
    public void  mouseEntered(MouseEvent e) {}
    public void  mouseExited(MouseEvent e) { close(); }
    public void  mousePressed(MouseEvent e) {}
    public void  mouseReleased(MouseEvent e) {}
    public void  mouseMoved(MouseEvent e) {
	for (Area a : segs.keySet()) if (a.contains(e.getPoint()) && selected!=a) { selected=a; repaint(); return; }
    }
    public void  mouseDragged(MouseEvent e) {}
    
    void close() {
	Container c=getRootPane().getParent();
	if (c instanceof WindowConstants) { c=getParent(); c.remove(this); c.repaint();  } else {  ((Window)c).hide(); ((Window)c).dispose(); }
    }
    
} //end class

