package jcm.gui.gen;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.*;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import jcm.StartJCM;
import jcm.java6methods;
import jcm.gui.nav.jcmAction;
import jcm.core.setup;
import jcm.core.report;
import jcm.gui.doc.labman;
import jcm.gui.nav.showpan;
import static jcm.gui.gen.colfont.*;
import static jcm.core.report.*;

public class splash extends JWindow {    //*************** STARTUP INFO  *******************
    static JLabel title = new JLabel("<html><center><font size=+2>Java Climate Model </font><br>" +
                                     "<i>Last revised " + StartJCM.revisiondate + " </i><br>" + "<font color=purple><i>JCM is developed in UCL-ASTR <br>supported by Belgian Science Policy</i></font><br>");
    static String message = ("<html><center>Welcome<br><font color=red><i>Please wait while loading data and initialising model</i></font><p>");
    static JLabel report = new JLabel(message);
    static JProgressBar progbar = new JProgressBar(0, 30);    //*********************************************************
    public splash(JComponent... cc) {
        super();
        try {
            setSize(400, 350);
            setLocation(showpan.pointForCenter(this));
            //getContentPane().
            try {
                setAlwaysOnTop(true);
            } catch (Exception e) {
                deb(e, "Couldn't set splash always on top \n");
            }
            
            //note this is a Java6 method - - has a catch Error to avoid  crashing Java5 JRE! Also can comment out to compile in Java 5
            java6methods.setIconImage(this);
            
            final JPanel p = new JPanel() {
                public void paintComponent(Graphics g) {
                    Graphics2D g2 = (Graphics2D) g;
                    g2.setPaint(new GradientPaint(0, 0, ltgreen, 400, 350, ltblue, true));
                    g2.fill(getBounds());
                }

            };
            Border bo = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(dkgreen, 2), new BevelBorder(BevelBorder.RAISED));
            p.setBorder(bo);
            p.getInsets().set(8, 8, 8, 24);
            
            add(p);

            lookandfeel.lookAndFeelParam.precalc();
            /*
            Box bht = Box.createHorizontalBox();
            bht.add(title);
            bht.add(Box.createHorizontalStrut(6));
            bht.add(closer);
            bht.setPreferredSize(new Dimension(380, 80));
            p.add(bht, BorderLayout.NORTH);
             * */
            title.setSize(new Dimension(360, 80));
            p.add(title, BorderLayout.NORTH);

            report.setPreferredSize(new Dimension(360, 160));
            p.add(report);

            Box bv = Box.createVerticalBox();
            bv.add(progbar);
            bv.add(Box.createVerticalStrut(10));
            Box bh = Box.createHorizontalBox();
            bh.add(new JButton(new jcmAction("<html><font size=-2>log") {
                           public void act() {
                               showlog();
                           }

                       }));
            bh.add(Box.createHorizontalStrut(20));
            bh.add(new JToggleButton(new jcmAction("<html><font size=-1>reset") {
                                 public void act() {
                                     setup.loadcurrent = !setup.loadcurrent;
                                     setup.restart = true;
                                     deb("** pressed reset from splash**");
                                 }

                             }));
            bh.add(Box.createHorizontalStrut(20));
            JButton closer = new JButton(new jcmAction("<html>hide") {
                                     public void act() {
                                         dispose();
                                     }

                                 });
            closer.setSize(new Dimension(20, 20));
            bh.add(closer);
            bv.add(bh);
            bv.add(Box.createVerticalStrut(10));
            bv.setPreferredSize(new Dimension(360, 80));
            p.add(bv, BorderLayout.SOUTH);

            setVisible(true);
        } catch (Exception e) {
            deb("Splash Constructor Error");
        }

    }

    public static void showlog() {
        JFrame log = new JFrame();
        log.setSize(300, 400);
        log.setLocation(100, 100);
        log.setContentPane(new report());
        log.setVisible(true);
        try {
            log.toFront();
        } catch (Exception e) {
        }
    }
    //******** /some shortcuts used below *********
    static String getLabel(String s) {
        return labman.getShort(s);
    }

    public static void report(String s) {
        report.setText(getLabel(message + s));
        progbar.setValue(progbar.getValue() + 1);
        logn(s);
    }

    public static void message(String s) {
        message = "<html><center>" + s + "<p>";
        logn(s);
    }

    public void end() {
        try {
            message("<font color=green>JCM setup finished successfully");
            report("<ul>Hints: <li>Unfold the tree, drag plots from it, <li> Try Setup Examples <li>Read How-To-Use documentation <li>Look in View & Tools menus");
            new Thread("Splash End") {
                public void run() {
                    try {
                        sleep(3000);
                    } catch (InterruptedException e) {
                    }
                    dispose();
                }

            }.start();

            showpan.mf.toFront();
        } catch (Exception e) {
            deb(e, "remove startup error ");
        }

        showpan.mf.validate();
    }

}

