/*
See todos in guimisctools.todo
 */
package jcm.gui.gen;

import jcm.core.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import jcm.core.par.param;
import jcm.gui.nav.filter.filtertype;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmAction;
import jcm.core.itf.menuFiller;
import jcm.core.itf.plotlink;
import jcm.core.ob.*;
import jcm.gui.doc.*;
import jcm.gui.nav.*;
import static jcm.gui.gen.colfont.*;
import static jcm.gui.nav.filter.filtertype.*;
import static jcm.core.report.*;

public class interacmap extends JPanel implements Runnable, plotlink {  //
    //
    //****** FIELDS ********
    Map<interacob, node> map = new HashMap();
    Set<node> vis = new HashSet();
    Set<filtertype> filters = new HashSet(Arrays.asList(NeededParams, Curves, Maps));
    int z = 1000, z2 = 1000; //z is steps for full width/height,  z2 starts same but changes with zoom
    float edgepushfac = 1000;
    int nstep = 0;
    int w, h, cx = 0, cy = 0;
    int initrun = 0, initsteps = 1000;
    int minlev = 1;
    boolean running = false, painting = false, firsttime = true;
    node centre = new node();
    node zoomcentre = new node();
    node closest = null;
    node focus = null, lastfocus = null; //world.worlds.get(0).get(jcm.mod.obj.controller.class);
    JMenuBar mb;
    JLabel foclab=new JLabel("-no focus-");
    static Font bold = new Font("Arial", Font.BOLD, 12),  plain = new Font("Arial", Font.PLAIN, 9),  italic = new Font("Arial", Font.ITALIC, 9);
    static interacmap cfc;   //current interacmap, so other code eg loop can force update
    Thread mythread;
    param level = complexity.defaultcomplexity; //getcomplexityparam();

    //****************** CONSTRUCTOR ****************
    public interacmap() {
        this(null);
    }

    public interacmap(interacob fi) {
        setName("JCM Interactions");
        intmap ip = new intmap();
        cfc = this;
        mb = new JMenuBar();
        setCursor(new Cursor(Cursor.MOVE_CURSOR));
        setLayout(new BorderLayout());        
        add(ip, BorderLayout.CENTER);
        mb.add(foclab);
        mb.add(new JButton(new jcmAction("adjust") {
                       public void act() {
                           start();
                       }

                   }));
        /*
        mb.add(new JButton(new jcmAction("stop") {
        public void act() {
        running = false;
        }
        }));
        mb.add(new JButton(new jcmAction("step") {
        public void act() {
        step(true, true);
        repaint();
        }
        }));
        
        mb.add(new JButton(new jcmAction("loop-go") {
                       public void act() {
                           loop.gonow(false);
                       }

                   })); //loop.go will call reset after setinteractions
         */           
        mb.add(filter.getToolBar(filters, this, level));
        add(mb, BorderLayout.NORTH);
        deb("\n initial run of interacmap, cfc=" + cfc);
        
        if (fi != null) {
             if (!(map.containsKey(fi))) map.put(fi, new node(fi));
            ip.setfocus(map.get(fi), true, false);
        }
        loop.gonow(false);
        start(); //initial run
        register.addlink(this, level);
    }
    //JLabel fglabel=new JLabel("*********"); //add(fglabel);  //fglabel.setText(""+g+" "+fg);
    //****************** SHOW / HIDE *******************
    public void removeNotify() {
        running = false;
        if (cfc == this) cfc = null;
    }//called when plot is closed

    public void hide() {
        if (cfc == this) cfc = null;
        super.hide();
    }

    public void show() {
        cfc = this;
        super.show();
    }

    public void doplot() {
        step(true, true);
        repaint();
    }

    ;    //***************** RESET AFTER LOOP CHANGE *******************
    public static void reset() {
        //called after loop interactions - ideally should wait for rest of loop to finished first? - i.e. make this a changed plot
        if (cfc != null) {
            seekchange:
            {
                if (cfc.firsttime) break seekchange;
                for (interacob i : register.alliobs) if (i.changed && i.needed) break seekchange;
                return;
            }
            deb("reset interacmap");
            cfc.firsttime = false;
            cfc.running = false;
            cfc.setup();
            cfc.step(true, false); //don't wait until loop done, because calling from inside loop
            cfc.repaint();
            for (node n : cfc.map.values()) n.setlevel();

        }
    }

    //***************** SETUP *******************
    public void setup() {
        for (interacob i : register.alliobs) {
            if (!(map.containsKey(i))) map.put(i, new node(i));
            map.get(i).setnc();
        }
        //complex line below avoids Concurrent Modification Exception
        for (Iterator<interacob> it = map.keySet().iterator(); it.hasNext();) {
            interacob i = it.next();
            if (i == null || i.disposed) it.remove();
        }
    }

    public void start() {
        running = true;
        initrun = 0;
        nstep = 0;
        mythread = new Thread(cfc, "InteracMap");
        mythread.setPriority(Thread.MIN_PRIORITY);
        mythread.start();
    }

    public void run() {
        deb("Interacmap run ");
        while (running) {
            step(true, true);
            Thread.currentThread().yield();
            nstep++;
            nstep %= 50;
            if (nstep == 0 && isShowing()) {
                repaint();
            }
            if (initrun >= initsteps) running = false;
            if (initrun < initsteps) initrun++;
        }
    }   //
    //***************** STEP - MOVE *****************

    float pullfac = 0.1f, pushfac = 1000f, avdistcentre, avd;
    void step(boolean random, boolean checkloop) {
        while (Thread.currentThread() == mythread && painting) mythread.yield();
        if (checkloop) loop.waitUntilLoopDone();

        vis.clear();
        for (node n : map.values()) if (n.lev > minlev) vis.add(n);

        //random for startup
        if (random) for (node n : vis) n.random((50 - nstep) / 10);

        //pull each halfway towards its links COG  - calc in this order avoids oscillations
        for (node n : vis) {
            n.cgx = 0;
            n.cgy = 0;
            n.cj = 0;
        }
        for (node n : vis) for (interacob i : n.i.vaffectedby) {
                node m = map.get(i);
                if (m != null && m.lev > minlev) {
                    n.cgx += m.x;
                    n.cgy += m.y;
                    n.cj++;
                    m.cgx += n.x;
                    m.cgy += n.y;
                    m.cj++;
                }
            }
        for (node n : vis) if (n.cj > 0) {
                n.x += (n.cgx / n.cj - n.x) / 2;
                n.y += (n.cgy / n.cj - n.y) / 2;
            }

        //work out overall COG and move back into centre
        float cgx = 0, cgy = 0, dx = 0, dy = 0;
        for (node n : vis) {
            cgx += n.x;
            cgy += n.y;
        }
        dx = centre.x - cgx / vis.size();
        dy = centre.y - cgy / vis.size();
        for (node n : vis) {
            n.x += dx;
            n.y += dy;
        }

        //pull all 1/80 towards COG - this stops isolated items going too far away and pulling COG with them
        for (node n : vis) {
            n.x += (centre.x - n.x) / 80;
            n.y += (centre.y - n.y) / 80;
        }

        //push away from others, trying to keep average pushing 50
        for (node n : vis) {
            n.dx = 0;
            n.dy = 0;
            n.done = false;
        }
        for (node n : vis) {
            n.done = true;
            for (node m : vis) if (!m.done) n.push(m, n.lev * m.lev);
        }
        avd = 0;
        for (node n : vis) avd += Math.sqrt(n.dx * n.dx + n.dy * n.dy);
        avd /= vis.size();
        pushfac = (50f / avd); //*400/avdistcentre;
        if (avd > 0) for (node n : vis) n.move(pushfac);
    //System.err.println(" avd="+avd+" pushfac="+pushfac);

    } //step

    //*************** INT MAP *****************
    public class intmap extends JPanel implements MouseListener, MouseMotionListener, MouseWheelListener, menuFiller {
        Component added = null;
        public intmap() {
            setBackground(Color.white);
            setPreferredSize(new Dimension(600, 600));
            addMouseListener(this);
            addMouseMotionListener(this);
            addMouseWheelListener(this);
            //setOpaque(false);
            new jcmMenu(this); //popup -see menuFiller
            setLayout(null);
        }

        public void setfocus(node n, boolean set, boolean repaint) {
//	    docview.helponclick(closest.i.name);
            if (set) focus = n;
            else focus = null;
            foclab.setText(focus==null ? "- no focus -" : labman.getShort(focus.i.name));
            if (repaint) {
                for (int i = 0; i < 5; i++) step(false, true);
                repaint();
            }
            for (node n2 : cfc.map.values()) n2.setlevel();
        }
        //************* PAINT *****************
        public void paintComponent(Graphics g) {
            painting = true;
            lookandfeel.setAntiAlias(g);
            w = getSize().width;
            h = getSize().height;
            int dx, dy, dl, onx, ony, omx, omy;
            Polygon p1, p2;
            if (cx == 0) {
                cx = w / 2;
                cy = h / 2;
            }
            super.paintComponent(g);
            //g.clearRect(20,20,w-40,h-40);
            //g.setColor(getBackground()); g.fillOval(0,0,w,h);


            vis.clear();
            for (node n : map.values()) if (n.lev > minlev) vis.add(n);

            for (node n : vis) for (interacob i : n.i.vaffectedby) {
                    node m = map.get(i);
                    if (m != null && m.lev > minlev) {
                        dx = m.px() - n.px();
                        dy = m.py() - n.py();
                        dl = (int) Math.sqrt(dx * dx + dy * dy);
                        if (dl > 0) {
                            onx = n.lev * dy / dl;
                            ony = -n.lev * dx / dl;
                            omx = m.lev * dy / dl;
                            omy = -m.lev * dx / dl;
                            p1 = new Polygon();
                            p1.addPoint(onx + n.px(), ony + n.py());
                            p1.addPoint(-onx + n.px(), -ony + n.py());
                            p1.addPoint(-omx + m.px(), -omy + m.py());
                            p1.addPoint(omx + m.px(), omy + m.py());
                            //g.setColor(yellow);
                            //g.fillPolygon(p1);
                            p2 = new Polygon();
                            p2.addPoint(n.px(), n.py());
                            if (n.i.affects(m.i)) {
                                p2.addPoint((m.px() + n.px() + omx + onx) / 2, (m.py() + n.py() + omy + ony) / 2);
                                p2.addPoint(m.px(), m.py());
                                p2.addPoint((m.px() + n.px() - omx - onx) / 2, (m.py() + n.py() - omy - ony) / 2);
                            } else {
                                p2.addPoint(omx + m.px(), omy + m.py());
                                p2.addPoint(-omx + m.px(), -omy + m.py());
                            }
                            g.setColor(m.getColorTo(n).brighter());
                            g.fillPolygon(p2);
                        } //dl
                    } //m
                } //n

            for (node n : vis) {
                if (n.lev > minlev + 1) {
                    Icon i = n.i.getIcon();
                    if (i == null) i = n.i.owner.getIcon();
                    if (i != null) i.paintIcon(this, g, n.px() - 10, n.py() - 10);
                }
                String s = labman.getShort(n.i.name);
                int order = register.calclist.indexOf(n.i);
                if (order >= 0) s = "" + order + " " + s;
                //note for timespent to work, must enable loopinfo - which now counts in nanseconds - report here in microseconds
                if (n.i.timespent != 0) s += " " + (int) (n.i.timespent / 1000);
                g.setFont(new Font("Arial", Font.PLAIN, n.lev * 2 + 6));
                //g.setFont((n.i instanceof module) ? bold : (n.i instanceof qtset) ? italic : plain);
                // g.setColor(new Color(127*(n.i.output ? 1 : 0), 255*(n.i.needed ? 1 : 0), 255*(n.i.changed ? 1 : 0) ));
                g.setColor(n.getColor().darker());
                g.drawString(s, n.px() + ((n.lev > minlev + 1) ? 20 : 2), n.py() + 3 + n.lev);
            }
            painting = false;
        } //paint

//**************** MOUSE ***************
        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (added != null) {
                mb.remove(added);
                added = null;
            }
            if (closest != null) {
                added = closest.i.getComponent();
                mb.add(added);
                mb.revalidate();
                mb.repaint();
            }
//  if (closest!=null) setfocus(closest);  } //clicked
        }
        //added.setSize(new  Dimension(200,30));
        //if (added!=null)  added.setLocation(focus.px()-100, focus.py()+20);
        public void mousePressed(MouseEvent e) {
            double dist, cdist = 20;
            closest = null;
            for (node n : vis) {
                dist = Math.sqrt((e.getX() - n.px()) * (e.getX() - n.px()) + (e.getY() - n.py()) * (e.getY() - n.py()));
                if (dist < cdist) {
                    cdist = dist;
                    closest = n;
                }
            }
            zoomcentre.move(e.getX(), e.getY());
            cx = e.getX();
            cy = e.getY();
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (closest != null) closest.move(e.getX(), e.getY());
            else {
                cx = e.getX();
                cy = e.getY();
            }
            step(false, true);
            repaint();
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            z2 *= (1f + (float) e.getWheelRotation() * 0.05f);
            repaint();
        }

        public void fillMenu(jcmMenu p) {
            if (closest != null) {
                p.add(new jcmAction(focus == closest ? "de-Focus" : "Focus on &" + closest.i.name) {
                  public void act() {
                      setfocus(closest, focus != closest, true);
                  }

              });
                closest.i.fillMenu(p);
            } else {
                p.add(showpan.pan("doc&interacmap", docview.class, "interacmap"));
                p.add(imagesaver.copyaction(this));
                p.add(imagesaver.saveimagemenu(this, "JCM-Interactions"));
            }
        }

    } //intmap

    /*
    principle - like springs:
    repulsion proportional to 1/distance
    attraction proportional to distance
    
     */    //************* NODES *****************
    class node {
        float dx, dy, cgx = 0, cgy = 0;
        int cj = 0;
        float x, y;
        interacob i;
        int lev = 1;
        boolean output = false, needed = false, changed = false;
        boolean done = false;
        node(interacob i) {
            this.i = i;
            x = z * (float) Math.random();
            y = z * (float) Math.random();
            dx = 0;
            dy = 0;
        }

        node() { //centre
            x = z / 2;
            y = z / 2;
            dx = 0;
            dy = 0;
        }
        //want to store this, because depends on temporary interactions info maybe lost by the time swing calls repaint
        void setnc() {
            output = i.output;
            needed = i.needed;
            changed = i.changed;
        }

        Color getColor() {
            return output ? changed ? purple : red
                    : needed ? changed ? blue : green
                    : changed ? ltblue : grey;
        }

        Color getColorTo(node to) {
            boolean follows = (i instanceof loopcalc && to.i instanceof loopcalc && register.follows.containsKey(to.i) && register.follows.get(to.i).contains(i));
            return to.needed ? changed ? //
                    follows ? dkpurple : blue //n  c
                    : follows ? green : cyan // n !c
                    : changed ? //
                    follows ? pink : ltblue //!n c
                    : follows ? yellow : grey; //!n !c
        }

        int px() {
            return cx + (int) ((x - zoomcentre.x) * w / z2);
        }

        int py() {
            return cy + (int) ((y - zoomcentre.y) * h / z2);
        }

        void move(int px, int py) {
            x = zoomcentre.x + (px - cx) * z2 / w;
            y = zoomcentre.y + (py - cy) * z2 / h;
        }

        float dist(node m) {
            return (float) Math.sqrt((m.x - x) * (m.x - x) + (m.y - y) * (m.y - y));
        }

        void setlevel() {

            boolean include = i.checkcomplexity() && i.checkenabled(filters);
            include |= register.checkneededforplotexcept(i, jcmTree.class);
            //added august 06: not very efficient, also not ideal: really want to add only if needed AND is only link between less complex modules...


            if (!include) {
                lev = 0;
                return;
            }

            //if (focused && focus!=null) include &= (this==focus || this.i.affects(focus.i) || this.i.affectedby(focus.i));
            // if (param.filterenabled.istrue()) include &=i.checkenabled();


            lev = (this.i instanceof loopcalc) ? 3 : 1;
            if (focus != null) foclev:
                {
                    if (this == focus) {
                        lev += 4;
                        break foclev;
                    }
                    if (this.i.affectedby(focus.i) || this.i.affects(focus.i)) {
                        lev += 2;
                        break foclev;
                    }
                    for (interacob ii : this.i.vaffectedby) if (ii.affectedby(focus.i) || ii.affects(focus.i)) {
                            lev += 1;
                            break foclev;
                        }
                    for (interacob ii : this.i.vaffects) if (ii.affectedby(focus.i) || ii.affects(focus.i)) {
                            lev += 1;
                            break foclev;
                        }
                }
        }

        void random(float f) { // by f * (frac of 1)
            x += (float) (f * (Math.random() - 0.5));
            y += (float) (f * (Math.random() - 0.5));
        }

        void push(node m, float f) { // by f / dist
            float d = ((m.x - x) * (m.x - x) + (m.y - y) * (m.y - y));
            if (d > 1) { // && d<10000) {
                dx -= (f / d) * (float) (m.x - x);
                m.dx += (f / d) * (float) (m.x - x);
                dy -= (f / d) * (float) (m.y - y);
                m.dy += (f / d) * (float) (m.y - y);
            } else {
                dx -= f;
                m.dx += f;
                dy -= f;
                m.dy += f;
            }
        }

        void move(float f) {
            x += f * dx;
            y += f * dy;
        }

    }

} //end flowchart


/*
NO LONGER USED

void pull(node m, float f) { // by f * dist
dx+=f*(float)(m.x-x); m.dx-=f*(float)(m.x-x);
dy+=f*(float)(m.y-y);  m.dy-=f*(float)(m.y-y);
}
void edgepush(float f){ // by f / dist (if dist between min and max)
int min=5, max=50;
if (x>min && x<max) dx+=f/x; if (x<z-min && x>z-max) dx -=f/(z-x);
if (y>min&& y<max) dy+=f/y; if (y<z-min && y>z-max) dy -=f/(z-y);
//	    if (x<z/4 && x>0) dx+=f/x;
//	    if (x>3*z/4 && x<z) dx-=f/(z-x);
//	    if (y<z/4 && y>0) dy+=f/y;
//	    if (y>3*z/4 && y<z) dy-=f/(z-y);
}


void edge() {  //stop at edge (called after move, no effect on dx, dy)
int d=10, d2=10;
if (x<d) x=d; if (x>z-d) x=z-d; if (y<d+d2) y=d+d2; if (y>z-d+d2) y=z-d+d2;
//x=x%z; y=y%z;
}

 *///*****************
//if beyond edge, move back to it
//without this, isolated items move further and further away and pull COG with them
//for (node n : vis) n.edge();

//avdistcentre=0; for (node n : vis) avdistcentre+=n.dist(pullcentre); avdistcentre/=vis.size();

//
//	avd=0; for (node n : vis)  avd+=Math.sqrt(n.dx*n.dx+n.dy*n.dy); avd/=vis.size();
//	pullfac =(20f/avd)*avdistcentre/400;
//	if (avd>0) for (node n : vis) n.move(pullfac);
//	System.err.println("avdistcentre: "+avdistcentre+" avdpull="+avd+" pullfac= "+pullfac);
//
//for (node n : vis)) n.pull(pullcentre, fg/10);
//for (node n : vis) n.edgepush(edgepushfac);
//edgepushfac *= avdistcentre/400;
//edgepushfac+=100*(g-400)/400; //10000
//for (node n : vis) System.err.println("dx="+n.dx+" dy="+n.dy );

