

package jcm.gui.gen;

import java.awt.*;
import java.awt.datatransfer.*;

import java.awt.image.*;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jcm.core.complexity;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.jcmMenu;
import jcm.core.tls.fileio;
import static  jcm.core.report.*;

public class imagesaver  {
    

    
/*
 Copy into a popupmenu p
	p.add(imagesaver.copyaction(painter));
	p.add(imagesaver.saveimagemenu(painter, name));
 */
    
    public static jcmAction copyaction(final Component painter) {
	return new jcmAction("Copy image") {  public void act() { copy(painter); }};
    }
    
    public static jcmMenu saveimagemenu(final Component painter, final String name) {
	jcmMenu saveimage=new jcmMenu("Save image", complexity.simplest);
	// ImageIO.getWriterFileNames()
	for (final String s : new String[]{"png", "png-transparent", "jpg"})  saveimage.add( new jcmAction(s, complexity.simplest) {  public void act() { saveimage(painter, name, s); }});
	return saveimage;
    }
    
    static BufferedImage getimage(Component c, boolean transparent) {
	//showpan.mf.setDefaultLookAndFeelDecorated(true); //so we see the title bar
	BufferedImage bi=new BufferedImage(c.getSize().width, c.getSize().height, transparent ? BufferedImage.TYPE_4BYTE_ABGR : BufferedImage.TYPE_3BYTE_BGR);
	c.paintAll(bi.getGraphics());
	//showpan.mf.setDefaultLookAndFeelDecorated(false);
	return transparent ? maketrans(bi) : bi;
    }
    
    
    static BufferedImage maketrans(BufferedImage bi) {
	try {
	    BufferedImage bi2=new BufferedImage(bi.getWidth(), bi.getHeight(),  BufferedImage.TYPE_INT_ARGB);
	    int mask=bi.getRGB(0,0);
	    for (int x=0; x<bi.getWidth(); x++) for (int y=0; y<bi.getHeight(); y++) bi2.setRGB( x,y,
		    bi.getRGB(x,y)==mask ? 0 : bi.getRGB(x,y)
		    );
	    return bi2;
	} catch (Exception e) { return null; }
    }
    
    static String converttype(String type) { String type2=type.substring(0,3); if (type2.equals("jpg")) type2="jpeg"; return type2; }
    static boolean transparent(String type) { return type.endsWith("transparent"); }
    
    //called from menus - opens a dialog
    public static void saveimage(Component painter, String name, String type){
	fileio f=new fileio("images", name,  type.substring(0,3), "Save Image", "save");
	saveimage(painter, type, f);
    }
    
    //called directly from scripts
    public static void saveimage(Component painter, String type, File f){
	saveimage(painter, type, new fileio(f));
    }
    
    public static void saveimage(Component painter, String type, fileio f){
	try {
	    BufferedImage b = getimage(painter, transparent(type));
	    ImageIO.write(b, converttype(type), f.os);
	    f.save();
	} catch (Exception e) { deb(e, "Couldn't Save Image");  }
    }
    
    
    
    //******************************
    
    
    public static void copy(final Component c) {
	try {
	    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(
		    new Transferable() {
		public DataFlavor[] getTransferDataFlavors() { return new DataFlavor[]{DataFlavor.imageFlavor}; }
		public boolean isDataFlavorSupported(DataFlavor flavor) { return flavor.equals(DataFlavor.imageFlavor); }
		public Object getTransferData(DataFlavor flavor)  throws UnsupportedFlavorException, IOException { return getimage(c, false);   }
	    } ,
		    new ClipboardOwner() {
		public void lostOwnership(Clipboard clipboard, Transferable contents) {}
	    }
	    );
	   log("copied image");
	} catch (Exception ex) {	deb(ex, "Error copying "+c); };
    }
    
}
