


package jcm.core.tls;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.*;
import java.lang.reflect.*;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import jcm.core.*;
import jcm.core.ob.*;
import jcm.gui.doc.labman;
import jcm.gui.nav.showpan;
import jcm.core.reg.regman;
import static jcm.core.report.*;

public class memoryChecker implements Runnable {
    
    
    static HTMLDocument  report;
    static Map<Object, meminfo> allinfo=new LinkedHashMap();
    static Queue<meminfo> checkqueue=new LinkedList();
    
    public static void checkall() { new Thread(new memoryChecker(), "Memory Checker").start(); }
    
    public void run() {
	Thread.currentThread().setPriority(Thread.MIN_PRIORITY); Thread.currentThread().yield();
	
	allinfo.clear(); System.gc();
	byte[] block= new byte[1000000]; //spare memory, 1MB
	
	deb("Checking All Objects");
	show();
	
	report("JCM memory use, starting from world.class");
	report("<i>beware this process itself uses a lot of memory and prevents memory from being cleared!</i><hr>");
	
	try {
	    meminfo.get(world.class);
	    while (!checkqueue.isEmpty()) checkqueue.poll().check();
	    meminfo.get(regman.class);
	    while (!checkqueue.isEmpty()) checkqueue.poll().check();
	    meminfo.get(labman.class);
	    while (!checkqueue.isEmpty()) checkqueue.poll().check();
	    meminfo.get(register.class); //doesn't seem to make any difference after world (since all objects already got ref)
	    while (!checkqueue.isEmpty()) checkqueue.poll().check();
	    meminfo.get(showpan.class);
	    while (!checkqueue.isEmpty()) checkqueue.poll().check();
	    
	} catch (Error e) { block=null; System.gc(); deb(e); report("UNFINISHED DUE TO LACK OF MEMORY <hr>");  }
	block=null;
	
	deb("Calc Size");
	for (meminfo i : allinfo.values()) {if (i.parent==null) i.sublev=0; }
	for (meminfo i : allinfo.values())  i.calcsizesub();
	for (meminfo i : allinfo.values()) if (i.sub!=null) Collections.sort(i.sub);
	
	SortedSet<meminfo> initial=new TreeSet();
	for (meminfo i : allinfo.values()) if ( i.sublev<1 && (i.size+i.sizesub)>0 ) initial.add(i);
	deb("Report");
	for (meminfo i : initial)  report(i.report()+ "</div>");
	initial=null;
	
	System.gc();
	//try { System.err.println(report.getText(0, 1000)); } catch (Exception e) { e.printStackTrace(); }
    }
    
    static void report(String s) {
	try {
	    report.insertBeforeEnd(report.getDefaultRootElement(), s );
	} catch (Exception e) { deb(e); }
    }
    
    
    
    static void show() {
	JEditorPane jep=new JEditorPane();
	jep.setContentType("text/html;");
	report=(HTMLDocument) jep.getDocument();
	jep.setEditable(false);
	jep.addHyperlinkListener(new HyperlinkListener() {   public void hyperlinkUpdate(HyperlinkEvent e) { if (e.getEventType()==HyperlinkEvent.EventType.ACTIVATED) { open(e); } }});
	final JFrame mf=new JFrame();
	mf.addWindowListener(new WindowAdapter() {	public void windowClosing(WindowEvent e) {mf.dispose();  report=null; allinfo.clear();   System.gc(); }} );
	mf.setSize(800,800);
	mf.setContentPane(new JScrollPane(jep));
	mf.show();
    }
    
    static void open(HyperlinkEvent e) {
	deb("open "+e.getDescription());
	String code=e.getDescription();
	meminfo opi=null;
	search: for (meminfo i : allinfo.values()) { if (code.equals(i.code())) { opi=i; break search; } }
	if (opi==null) { deb("Can't find object"); return; }
	try {
	    opi.open=!opi.open;
	    String s=opi.report();   if (opi.open && opi.sub!=null) for (meminfo i : opi.sub) if ((i.size+i.sizesub)>0) s+=i.report()+ " </div>"; s+= " </div>";
	    report.setOuterHTML(report.getElement(code), s);
	    //e.getSourceElement().getParentElement(
	    // report.insertBeforeEnd(report.getElement(code), s);
	} catch (Exception ex) { deb(ex); }
    }
    
    
    
} //end class

class meminfo implements Comparable<meminfo> {
    
    public int compareTo(meminfo i) {
	int z=(i.size+i.sizesub)-(size+sizesub);
	if (z==0) z=1; //i.ob.hashCode()-ob.hashCode() ; //must not return 0 or objects considered to be equal! but hashcodes of maps can crash!
	return z;
    }
    
    boolean inc=false, open=false;
    int size=0, sizesub=0, sublev=0;
    String name;
    long created=System.currentTimeMillis(); //used for code
    Object ob;
    meminfo parent=null;
    List<meminfo> sub=null;
    
    meminfo(String na, Object o, int lev) {
	name=na;
	ob=o; sublev=lev;
	memoryChecker.allinfo.put(ob, this);
	memoryChecker.checkqueue.add(this);
    }
    
    static meminfo get(Class c) { return get("", c, 0); }
    
    static meminfo get(String n, Object o, int lev) {
	if (o==null) return null; //deb("trying to get null!");
	
	//check have we got this already in register?
	meminfo i=memoryChecker.allinfo.get(o); if (i!=null) return i;
	
	if (o instanceof Class) n="CLASS:_";
	if (!(o instanceof Class)) get(o.getClass()); //try to get the class object first
	return new meminfo(n, o, lev);
    }
    
    void addob(String n, Object o2) {
	if (o2==null || o2==ob) return;
	meminfo i=get( n, o2, sublev+1);
	if (maydescend(i)) {
	    if (i.parent!=null && i.parent.sub!=null) i.parent.sub.remove(i);
	    if (sub==null) sub=new ArrayList(4);
	    i.parent=this; i.sublev=sublev+1; sub.add(i);
//	    if (sublev>10) deb(name+" "+ob.getClass().getName()+ " => "+n+" "+o2.getClass().getName()+" "+sublev);
	}
    }
    
    
    int calcsizesub() {
	inc=true;
	if (sub!=null) for (meminfo i : sub) {
	    if (!i.inc && i.parent==this) { sizesub+=i.size+i.calcsizesub();  }
	}
	return sizesub;
    }
    
    
    
    boolean maydescend(meminfo i) {
	if (i==null) return false;
	if (i.ob instanceof Class) return false;
//	if (i.o instanceof world || (i.o instanceof module && !(o instanceof world))) return false;
//	if (i.o instanceof interacob && !(o instanceof module || o instanceof world)) return false;
	return (i.parent==null || i.sublev>sublev+1);
    }
    
    void check() { if (ob instanceof Class) check((Class)ob); else check(ob.getClass()); }
    void check(Class c) {
	//deb("checking "+name+" object:"+ob+" class:"+c.getName());
	
	if (c.isArray()) {
	    if (ob instanceof Class) return;
	    int al=Array.getLength(ob);  //should amend acc to type
	    Class ac=c.getComponentType();
	    if (ac.isPrimitive()) size+=al*primsize(ac);
	    else  {
		size+=al;
		for (int j=0; j<al; j++) { Object ao=Array.get(ob, j); if (ao!=null) addob("["+j+"]", ao); }
	    }
	    return;
	}
	
	try {
	    if (ob instanceof Collection) {
		Collection co=(Collection)ob;
		int al=co.size();
		size+=10+al*2; //assume collections take 10+2 per object
		int j=0;
		for (Object coo : co ) { if (coo!=null) addob("{"+j+"}", coo); j++; }
		return;
	    }
	    
	    if (ob instanceof Map) {
		Map m=(Map)ob;
		int al=m.size();
		size+=20+al*4; //assume maps take 20+4 per object
		int j=0;
		for (Object mo : m.keySet())  {
		    addob("{key"+j+"}", mo);
		    if (m.get(mo)!=null) addob("{val"+j+"}", m.get(mo));
		    j++; 
		}
		return;
	    }
	} catch (Exception e) { //this catches ConcurrentModificationException when all and checkqueue  check themselves
	    deb(e, " in "+name); //+" object:"+ob
	    return;
	}
	
	//some more complex object...
	Field[] ff=c.getDeclaredFields();
	Field.setAccessible(ff, true);
	
	floop: for (Field f : ff) {
	    if ((ob instanceof Class)== Modifier.isStatic(f.getModifiers()))  { //for class, only do static fields, otherwise ignore them
		Class fc=f.getType();
		if (fc.isPrimitive()) { size+=primsize(fc); continue floop; }
		try {
		    Object fo=f.get((ob instanceof Class) ? null : ob);
		    size+=1; //for the reference
		    if (fo!=null) {
			addob((f.getName()!=null ? f.getName() : "(anon)"), fo);
		    }
		} catch (Exception e) {
		    //in principle there should not be exceptions here, but some seem to slip through
		    deb(e, " in "+name+" field: "+f.getName()+"{"+fc.getName()+"} object:"+ob);
		    continue floop;
		}
	    } //sf
	} //f
	
	//now continue with superclasses
	if (c!=Object.class) {
	    if (ob instanceof Class) get(c.getSuperclass()); //for class, record it separately as all subclasses share static fields
	    else check(c.getSuperclass()); //continue to record inside same info
	}
    } //check
    
    int primsize(Class c) {
	if (c==Boolean.TYPE || c==Byte.TYPE  ) return 1;
	if (c==Character.TYPE || c==Short.TYPE) return 2;
	if (c== Integer.TYPE || c== Float.TYPE) return 4;
	if (c== Long.TYPE || c== Double.TYPE) return 8;
	return 0;
    }
    
    String code() { //used as  html link reference -should be unique
	//note -used to use object hashcodes but some of these (esp Maps) cause crash
	//beware this must not contain spaces
	if (ob instanceof Class) return "#"+((Class)ob).getName();
	else return "#"+(parent!=null ? parent.name : "")+"_"+name+"_"+created; //_{"+ob.getClass().getName()+"}_
    }
    
    
    String report() {
	String code=code();
	Class c=ob instanceof Class ? (Class)ob : ob.getClass();
	String s=" <div id="+code+"><nobr> ";
	if ((size+sizesub) > 1000) s+="<b>";
	for (int j=0; j<sublev; j++) s+="--";
	if (sub!=null && sub.size()>0) 	s+=" <a href="+code+">["+(open ? "X" : "open")+"]</a> ";
	s+= " "+size+" ("+sizesub+") "	+name;
	if (ob instanceof String) s+= "\""+ob.toString()+"\"";
	else {
	    if (c.getPackage()!=null && c.getPackage().getName().startsWith("jcm"))  s+=" {<font color=red>"+c.getName()+"</font>} ";
	    else s+= " {"+c.getName()+"} ";
	    if (ob instanceof infob) s+="<i>"+((infob)ob).name+"</i>";
	    else if (ob instanceof Component) s+="<i>"+((Component)ob).getName()+"</i>";
	}
	if ((size+sizesub) > 1000) s+="</b>";
	return s+" </nobr> ";
    }
}

