 /*REGION MANAGER
all-static code for loading region definition data
 note region colors now in countrynames.csv
  */

package jcm.core.reg;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.tls.fileio;
import jcm.core.tls.txt;
import java.awt.*;
import jcm.gui.nav.filter;
import jcm.gui.plot.mapplot;
import jcm.gui.nav.showpan;
import jcm.gui.doc.label;
import jcm.gui.doc.labman;
import static  jcm.core.report.*;
import static jcm.gui.gen.colfont.*;


public class regman  {
    
    public static region allreg=new region("ALL");
    public static region world;
    public static region nations;
    
    
    static {
	loaddata();
	log("loaded region data ok");
	nations=allreg.findreg("NATIONS");
        world=allreg.findreg("world");
	log("made main region list ok");
    }
    
    public static param<region> makeregionparam(String name) { return makeregionparam(name, "JCM25"); }
    public static param<region> makeregionparam(String name, String init) {
	region mainlist=allreg.findreg("MAINLIST");
	region[] rr=mainlist.reg.toArray(new region[0]);
	param<region> p=new param(name, rr, allreg.findreg(init) );
	p.addAction(filter.filtertype.Maps, showpan.pan("Map", mapplot.class, p));
	for (String s : expert) p.setcomplexity(mainlist.findreg(s), complexity.expert);
	for (String s : experimental) p.setcomplexity(mainlist.findreg(s), complexity.experimental);
	return p;
    }
    
    static String[] expert={ "JCM50", "IMAGE",  "EDGAR",  "JCM12IMAGE",  "KYOTO", "RICE",  "CWS15",  "GEME18",  "HOUGHTON", "NICSLR"};
    static String[]experimental={ "TGCIA",  "GRID",  "GRIDLO" };
    
    //*****************************************************
    
    public static void loaddata() {
	
	String[][] tab=fileio.loadtab("data/countrynames.csv", "\t");
	for (String[] row : tab) if (row.length>1) {
	    region r=allreg.findormakereg(row[1], null);
	    
	    for (String s : row) if (!s.equals(row[1]) && s.trim().length()>0) {
		if (s.startsWith("#")) r.color=new Color(Integer.decode(s));
		else { r.altnames.add(s); r.simpaltnames.add(r.simplify(s)); }
	    }
	    //if (allreg.checkfind(row[1])) System.err.println("duplicate: "+row[0]);
	    
	    //added aug07
	    boolean orc=labman.recordchanged;
	    labman.recordchanged=false;
	    String name=labman.convertkey(row[0]);
	    if (!labman.gotLabelForKey(name)) labman.addLabel(name, new label(name, "reg"));
	    label lab=labman.getLabel(name);
	    lab.set(label.langcode.en, label.smd.s, row[1]);
	    lab.set(label.langcode.en, label.smd.m, row[0]);
	    labman.recordchanged=orc;
	}
	
	
	String poly=fileio.loadstring("data/regions.txt").trim();
	String[] line=txt.split(poly, "\n", true), item;
	for (int i=0; i<line.length-1; i++) {
	    item=txt.split(line[i], " ", true);
	    try {
		if (region.nsew(item[0])==0) {	//not nsew
		    region r=allreg.findormakereg(item[0], null);
		    if (item[1].equals("+")) r.addsub(item); //consists of following subregions
		    else if (item[1].equals("-")) r.subtract(item); //remove following subregions
		    else if (item[1].equals("&")) r.addset(item); //add set (expanding not recursive). can repeat an entry
		    else if (item[1].equals("L")) { r.defbox(item); r.sea=false; } //tgcia box ocean
		    else if (item[1].equals("O")) { r.defbox(item); r.sea=true; } //tgcia box ocean
		    else r.addedge(item); //add adge (with, from, to, corners)
		}
	    } catch (Exception e) {	deb(e, line[i]+" regload "+e); }
	}
	
	region oceans=allreg.findreg("OCEANS");
	for (region r : allreg.reg) if (oceans.contains(r)) r.sea=true;
	
    } //end loaddata
    
} //end regman





