/*each region can either be an individual polygonal area (such as a simple country, island, lake or ocean area), or a sum of other smaller regions */



package jcm.core.reg;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.*;

import jcm.core.*;
import jcm.core.ob.*;
import jcm.core.cur.*;
import jcm.gui.doc.autodoc;
import static jcm.core.report.*;


public class region extends infob  {
    
    /** List of subregions contained within this one*/
    public List<region> reg=new ArrayList();
    /** Vector of region-polygons for drawing this one */
    public Vector<regpoly> polyset=new Vector();
    
    boolean included=false,  fixedpoly=false, sea=false; //note fixedpoly used for TGCIA
    region superset=regman.allreg;
    ArrayList<String> altnames=new ArrayList(0);
    ArrayList<String> simpaltnames=new ArrayList(0);
    List<edge> edges=new LinkedList();
    edge startedge;
    float coast=0, area=0;
    
    //***************************************************
    //constructors
    public region() {}
    public region(String s) { name=s; }
    public region(String s, Color c) { name=s; color=c;}
    
    //***************************************************
    //NAME / COLOR / DOC
    
    /** sets colors of subregions */
    public void setcols(Color[] cols)  {	for (int i=0; i<reg.size(); i++ ) reg.get(i).color=cols[i]; }
    /** gets colors of subregions */
    public Color[] getcols() { Color[] cols=new Color[reg.size()+1]; for (int i=0; i<reg.size(); i++) cols[i]=reg.get(i).getColor(); cols[reg.size()]=Color.black; return cols; }
    
    /** if has alternative names (derived from countrynames data file), returns the first, otherwise returns the simple region-code name*/
    public String getName() {	return (altnames.size()>0) ?  altnames.get(0) : name; }
    /** gets names of subregions */
    public String[] getnames() {	String[] names=new String[reg.size()+1]; for (int i=0; i<reg.size(); i++) names[i]=reg.get(i).name; names[reg.size()]="world_total"; return names; }
    
    /** adds ££aboutregions tag */
    public String getExtraDoc() { return   docNotes()+docSubReg()+"££aboutregions"+"<hr>";     }
    
    /** html list of subregions and superregions, with colors and links */
    public String docSubReg() {
	String s="", s2="";
	//Set<region> subr= subreg(regman.nations);
	if  (reg.size()>1) { for (region r : reg) s+="<li>"+ r.hashcolor()+autodoc.link(r.name, r.getName())+"</font>"; s= "==£`subreg== <ul>"+s+"</ul>"; }
	Set<region> supr=new HashSet(); for (region r : regman.allreg.reg) if (r.reg.contains(this)) supr.add(r);
	if  (supr.size()>1) { for (region r : supr) s2+="<li>"+ r.hashcolor()+autodoc.link(r.name, r.getName())+"</font>"; s2= "==£`supreg== <ul>"+s2+"</ul>"; }
	return s+s2;
    }
    
    
    
    //***************************************************
    //SUBREGIONS
    
    /** true if contains at least one subregion */
    public boolean isset() { return reg.size()>0; }
    
    /** true if findreg(s) is not null*/
    public boolean checkfind(String s) {  return findreg(s)!=null;    }
    
    /** points to findormakereg - clearer to use that explicitly (or just findreg if you don't want to make any new regions)*/
    public region find(String s) { return findormakereg(s); }
    
    /** find a subregion of this one with the given name (also checks against alternative names in countrynames file, and tries to simplify )  - if no region is found will return null */
    public region findreg(String s) {
	for (region r : reg) if (r.name.equals(s)) return r;
	for (region r : reg) for (String an : r.altnames) if (an.equals(s)) return r;
	String s2=simplify(s);
	for (region r : reg) for (String an : r.simpaltnames) if (an.equals(s2)) return r;
	return null;
    }
    
    static String[] ignore=new String[]{ ",", " &",  "`", "'s ", " s ", " and", "the", " of", " is.", " isl.",  " isls", " islands", " island",  " rep.", " republic", "fr. ", "french ", "saint ", "st. ", "."  };
    static String[] spacer=new String[]{"-", "/", "  "};
    
    static String simplify(String s) {
	String s2=s.toLowerCase();
	for (String i : ignore) s2=s2.replace(i, "");
	for (String i : spacer) s2=s2.replace(i, " ");
	s2=s2.trim();
	return s2;
    }
    
    /**  first calls findreg, but if no region is found, makes a new region (as a subregion of this one) */
    public region findormakereg(String s) { return findormakereg(s, null); }
    
    /**  as findormakereg, but  if a new region was made, a warning starting with the info string is also reported */
    public region findormakereg(String s, String info) {
	region r=findreg(s);
	if (r==null) {
	    r=new region(s); reg.add(r);
	    if (info!=null) deb(info+": "+s+ " is not a known region name: made a new region!");
	}
	return r;
    }
    
   /*
    Map<String, String> check=new HashMap();
    if (!s.equals(r.name)){
	    if (check.containsKey(r.name) && !check.get(r.name).equals(s)) System.err.println(s+" => "+r.name+ " "+ check.get(r.name));
	    check.put(r.name, s);
	}
    */
    
    /** true if the given region is contained within this one -  searching recursively through all subregions */
    public boolean contains(region cr) {	//recursive
	if (cr==this) return true;
	if (isset()) for (region r: reg ) if (r.contains(cr)) return true;
	return false;
    }
    
    /** true if the Point (in  latlong (?) coordinates) is within any of this region's set of polygons  */
    public boolean contains(Point p) {	for (Polygon poly : polyset) if (poly.contains(p.x,p.y)) return true; return false; }
    
    //comparing order
    boolean lt(region r) {	return name.compareTo(r.name)<0; }
    boolean gt(region r) {	return name.compareTo(r.name)>0; }
    
    /** find a set of sub-regions of this one within the given region's regset  */
    public Set<region> subreg(region r) { return subreg(new HashSet(r.reg)); }
    /** find a set of sub-regions of this one within the qtset keyset */
    public Set<region> subreg(curveset qq) { return subreg(qq.map.keySet()); }
    
    /** find a set of sub-regions of this one within a destination set -used by histdata split,  people, interpolatereg */
    public Set<region> subreg(Set<Object> destset) {
	Set<region> set=new HashSet();
	for (region sr : reg) sr.addsubreg(set, destset);
	if(set.size()==0)  addsubreg(set, destset);
	if (destset.contains(this) && !set.contains(this)) set.add(this);
	// ((source.map.containsKey(r) && !subregs.contains(r)  )? source.get(r, y)*fac : 0));
	return set;
    }
    
    void addsubreg(Set<region> set, Set<Object> destset) {
	if (destset.contains(this)) set.add(this);
	else for (region sr : reg)  sr.addsubreg(set, destset); //recursive
    }
    
    
    //***************************************************
    //POLYGONS
    static String edgelist; static Set<edge> includededge=new HashSet(); //note assumes will never call two makepolys concurrently
    
    /** make polygon corresponding to a particular region*/
    public void makepolys() {
	if (!fixedpoly) { polyset.clear();  edgelist=" \n "+getName()+" edges from "; coast=0; includededge.clear(); addpoly(this); }
	//float area=calcarea();
	//if (coast!=0) System.err.println(edgelist+ " coast: "+coast); //"\ngetName()
	//System.err.println(" \n "+getName()+" coast="+coast+" area="+area+" ratio="+coast/area);
//	try {
//	    float ava=jcm.mod.luc.LUCdata.countryArcviewAreas.get(this).intValue();
//	    System.err.println(getName()+" area="+(int)area+" ava="+(int)ava+" err%="+(int)(100f*(area/ava-1f)));
//	} catch (Exception e) {}
    }
    
    //semi- recursive : poly and contains info always belongs to initial region
    //P1 for multi-country polygons, the last corner is always cut
    
    void addpoly(region ir) {
	String debug=" region "+ir.name;
	try {
	    if (ir.isset()) {
		for (region r : ir.reg) if (r!=ir) r.included=false;
		for (region r : ir.reg)  { debug+=" "+r.name; if (!r.included) { addpoly(r); debug+=":start "; } else  debug+=":inc "; }
	    } else {
		if (ir.fixedpoly) { //only for TGCIA boxes
		    polyset.add(ir.polyset.firstElement());
		    ir.included=true;
		}
		if (ir.startedge!=null && !includededge.contains(ir.startedge)) {
		    //(follow around the edges anticlockwise)
		    edge e=ir.startedge, eo=e;
		    region et, er, el; regpoly p=null; float len;
		    do {
			debug +=" \tEdge "+(e!=null ? e.info() : " null");
			//if not internal edge, add edge
			if ( !(contains(e.left) && contains(e.right)))  {
			    if (p==null) { eo=e; p=new regpoly(); polyset.add(p); p.wrapping=false;  }
			    p.addedge(e, e.left==ir);
			    includededge.add(e);
			    if ((e.left==ir && e.right.sea) || (e.right==ir && e.left.sea)) { len=e.length()*60f*1.852f;  coast+=len; edgelist+="   "+ir+"-"+(e.left==ir ? e.right : e.left)+" "+len;  }
			}
			//move on to next edge (/region)
			if (e.left==ir) {	et= e.to; er=e.right; el=e.left; } else {	et= e.from; er= e.left; el=e.right ; }
			if (contains(et)) {	ir=et; ir.included=true;  e= ir.lt(er)  ? ir.fef(er, el)   : er.fet(ir, el) ; } else {	e=   ir.lt(et)  ? ir.fef(et, er) : et.fet(ir, er) ; }
		    } while (e!=eo && (p==null || !p.wrapping)  && !includededge.contains(e));
		    //if (!mapproj.notwrap(fp.x,op.x)) {	p.wrapping=true; wrapping=true; }
		}
	    }
	} catch (RuntimeException ex) {	deb(ex, debug); }
    }
    
    //******************** AREA ************************
    /*
     general formula for area of any polygon (without holes), taken from Gauss-Green formula
     modified to take into account curvature of earth by scaling each x by cos latitude (note shearing will not change the area)
     this will be OK for most country-sized polygons in which internal curvature is not a big factor
     in principle could remove holes (lakes) if remove math.abs and make sure all polygons (inc holes) numbered with interior on left
     */
    float calcarea() {
	float sum=0; for (Polygon p : polyset) sum+=calcarea(p); return sum;
    }
    
    float calcarea(Polygon p) {
	float sum=0;
	for (int i=0; i< p.npoints; i++)  {
	    int j=(i+1) % p.npoints;
	    sum+=p.xpoints[i]*Math.cos((Math.PI*p.ypoints[i])/180.0)*p.ypoints[j] - p.xpoints[j]*Math.cos((Math.PI*p.ypoints[j])/180.0)*p.ypoints[i];
	}
	return Math.abs(sum/2f)*60f*60f*1.852f*1.852f;
    }
    
    
    //***************************************************
    //EDGES
    
    edge fef(region r, region f) {	for (edge e : edges) if (r==e.right && f==e.from) return e; return null; }
    edge fet(region r, region t) {	for (edge e : edges) if (r==e.right && t==e.to) return e; return null; }
    
    //should check if need all "ormake" below
    
    edge addedge(String r, String f, String t)	{
	startedge=new edge(this, superset.findormakereg(r), superset.findormakereg(f), superset.findormakereg(t));
	edges.add(startedge);
	superset.findormakereg(r).startedge=startedge;
	return startedge;
    }
    
    //*****************************************************
    //methods called by loaddata
    void addedge(String[] item) {
	edge e= addedge(item[1], item[2], item[3]);
	e.p=new Point[item.length-4];
	for (int j=4; j<item.length; j++) e.p[j-4]=parsepoint(item[j]);
    }
    
    //E, W, N, S edges, format of TGCIA regions - note this will trim the half degrees because Polygon only accepts ints
    void defbox(String[] s) {
	regpoly p=new regpoly();
	p.addPoint(pi(s[5]), pi(s[2]));
	p.addPoint(pi(s[5]), pi(s[3]));
	p.addPoint(pi(s[4]), pi(s[3]));
	p.addPoint(pi(s[4]), pi(s[2]));
	polyset.addElement(p); fixedpoly=true;
	superset.findormakereg("TGCIA").reg.add(this);
    }
    
    void addsub(String[] item) {	for (int j=2; j<item.length; j++) 	reg.add(superset.findormakereg(item[j])); }
    void subtract(String[] item) {	for (int j=2; j<item.length; j++) 	reg.remove(superset.findormakereg(item[j])); }
    void addset(String[] item) {	for (int j=2; j<item.length; j++) {	region rr= superset.findormakereg(item[j]); if (rr.isset()) for (region r : rr.reg ) reg.add(r); else reg.add(rr); }	}
    
    static int pi(String s) {	return Integer.parseInt(s.substring(0, s.length()-2)); }
    static Point parsepoint(String item) {
	int k=nsew(item.substring(0,1));
	return new Point(xs*Integer.parseInt(item.substring(k+2,item.length())), ys*Integer.parseInt(item.substring(k,k+2)) );
    }
    
    //interpret NSEW info in datafile
    static int xs=1, ys=1; //assume start N, E
    static int nsew(String c) {
	int k=1;
	if (c.equals("N"))  ys=1;
	else if (c.equals("S")) ys=-1;
	else if (c.equals("E")) xs=1;
	else if (c.equals("W")) xs=-1;
	else if (c.equals("!")); //to skip comments
	else k=0;
	return k;
    }
    //*****************************************************
    
    
} //end class




