 /*
Class param holds user-adjustable parameters
  
  */



package jcm.core.par;
import jcm.core.*;
import jcm.core.cur.curveset;
import jcm.core.itf.plotlink;
import jcm.core.cur.units;
import jcm.core.ob.interacob;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import jcm.gui.nav.filter;
import jcm.gui.nav.jcmAction;
import jcm.gui.nav.paramMenu;
import jcm.gui.nav.paramOption;
import jcm.gui.nav.paramValueChooser;
import jcm.gui.nav.jcmTree;
import java.awt.*;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.swing.*;
import java.util.Collection;
import javax.swing.event.*;
import jcm.gui.nav.filter.filtertype;
import jcm.gui.nav.jcmMenu;
import jcm.script.calcscript;
import jcm.core.tls.ref;
import static  jcm.core.report.*;
import static  jcm.core.complexity.*;


public class param<T> extends interacob {
    
    //*****************************
    //VARIABLES
    
    public enum Type {	menu, option, value, Xscale, Yscale, trigger}
    public Type type;
    
    //specific to types of param
    public T[] menulist; public T chosen, defchosen;   public int numitems;  Class listtype; public complexity[] itemcomplexity;
    public boolean flag, defflag; //for options
    public double val, defval, max, min;  public units units; public int dp=2; //for values
    
    public param pair;
    public static boolean reportchange=true;
    
    //  public static param filterenabled=new param("filterenabled", true);
    
    //***************************
    //CONSTRUCTORS
    
    
    public param(Object ... args) {
	int dc=0, sc=0; //counters
	mycomplexity=normal;
	
	argloop: for (Object a : args) {
	    
	    // for a menu param, first array argument sets the list, next argument instance of (original) array-type becomes the default choice
	    //could also add enum input directly rather than via collection
	    
	    if ((a instanceof Object[] || a instanceof Collection) && menulist==null) {
		type=type.menu;
		Object[] o=a instanceof Object[] ? (Object[])a : ((Collection)a).toArray();
		menulist=(T[]) o; //note objects are same, not copies, but arraytype is simple Object
		numitems=menulist.length;
		itemcomplexity=new complexity[menulist.length];
		listtype=a.getClass().getComponentType();
		continue argloop;
	    }
	    
	    if (menulist!=null && chosen==null && (listtype==null || listtype.isInstance(a)))  {
		chosen=(T)a; defchosen=(T)a;
		//log(name+" ("+listtype.getSimpleName()+")  def="+a.toString());
		continue argloop;
	    }
	    
	    if (a instanceof Type) { this.type=(Type)a; }
	    if (a instanceof Color) {	this.color=(Color) a; }
	    if (a instanceof Boolean) {	this.flag=(Boolean) a; defflag=flag; type=type.option; }
	    if (a instanceof param)	{	pair=((param)a); } //note swapped: may affect doc
	    
	    if (a instanceof complexity) { mycomplexity=(complexity)a;  }
	    if (a instanceof complexity[]) { itemcomplexity=(complexity[])a; }
	    
	    if (a instanceof Number) {
		if (type==null) type=type.value;
		double d=((Number) a).doubleValue();
		if (dc==0) {	val=d; defval=val; min=Double.MAX_VALUE; max=Double.MAX_VALUE; }
		if (dc==1) min=d;
		if (dc==2) max=d;
		if (dc==3) units.scales=d;
		if (dc==4) units.scaleu=d;
		dc++;
	    }
	    
	    if (a instanceof String) {
		String s=a.toString();
		if (sc==0) name=s;
		//if (sc==0) {	String[] ss=txt.split(s,"&"); name=ss[0]; if (ss.length>1) name2= "&"+ss[1]; }
		if (sc>=1)   units=new units(s);
		sc++;
	    }
	    if (a instanceof curveset) ((curveset)a).associate(this);
	    
	}
	if (units !=null) {
	    units.checkunitcancel();
	    units.checkunitfac(max-min);
	}
	register();
	
	addAction(filter.filtertype.Doc);

        priority=(mycomplexity==complexity.simplest) ? 1.1 :  (mycomplexity==complexity.normal) ? 1.0 : (mycomplexity==complexity.expert) ? 0.9 : 0.8;
        //output=true; //temporary experiment - not good - if only one param affected by a module (eg costs) then triggers all needed
    }
    
    //********** LOAD / SAVE ****************
    //called from setup
    
    public String save() {
	return getFullName()+"\t"+ ((type==type.menu) ? getchosenindex()+"\t"+chosen :  (type==type.option) ? flag : (type==type.value) ? val : "")+"\n";
    }
    
    public void load(String s) {
	if (type==type.menu) choose(Integer.parseInt(s));
	if (type==type.option) flag= s.equals("true");
	if (type==type.value) val=Double.valueOf(s).doubleValue();
	changed=true;
    }
    
    //********** SET  ********
    public void reset() { reset (false);  }
    
    public void reset(boolean allchange) {
	if (type==type.menu && (allchange || chosen!=defchosen)) {	chosen=defchosen; changed=true; }
	if (type==type.option && (allchange || flag!=defflag)) {	flag=defflag; changed=true; }
	if (type==type.value && (allchange || val!=defval)) {	val=defval; changed=true; }
	if (type==type.trigger) flag=defflag;
    }
    
    //P1 beware %numitems below won't work with varying complexity in menu
    public void next() { choose( (getchosenindex()+1) % numitems); }
    public void prev() { choose( (numitems +getchosenindex()-1) % numitems); }
    
    //amended to account for complexity:
    public void choose(int i) { if (type==type.menu)	{
	int j=0; for (T o : menulist) if (checkcomplexity(o)) { if (i==j) { chosen=o; return; }  j++; }
    }}
    
    public void choose(T c) { for (T o : menulist) if (c.equals(o)) chosen=o;    }
    
    public void putval(double val) {	this.val=val; }
    
    public void setcomplexity(T o, complexity c ) {
	for (int j=0; j<menulist.length; j++) if ( o.equals(menulist[j])) itemcomplexity[j]=c;
    }
    
    public void setlist(T[] newlist) {
	int n=newlist.length;
	itemcomplexity=new complexity[n];
	for (int j=0; j<n; j++) itemcomplexity[j]=mycomplexity;
	menulist=newlist;
    }
    
    
    //note only the set methods below call respond
    public void set(double d) {	    val=d; if(val<min) val=min; else if(val>max) val=max;  respond(); }
    public void set(boolean b) {	flag=b; respond(); }
    public void set(T o) {	choose(o); respond(); }
    public void set(int i) {	if (type==type.value) set((double)i); else {	choose(i); respond(); }}
    
    public void set(String s) {
	if (type==type.option) {	if (s.equals("false") || s.equals("f") || s.equals("F") || s.equals("off") || s.equals("dis") || s.equals("disabled")) flag=false; else flag=true; }
	if (type==type.menu) {   try { choose((T)s); } catch (Exception e) { deb("param "+name+" not same type as "+s); }}
	if (type==type.value) putval(Double.valueOf(s).doubleValue()); //beware not take into account units scaling factor!
	respond();
    }
    
    //****************** RESPOND ****************
    public void respond() {
	respond(!calcscript.delayloop());
    }
    
    public void respond(boolean domodloop) {
    report();	
    changed=true;
    if (domodloop)   loop.golater("Change "+name, type==type.value ? false : true);	//note value types set changeTreeStruc false
    }
    
    public void report() { if (reportchange) log(getFullName()+" set to: "+getstringval());}
    
    //***** LOOP and ENABLED *************
    
    public void precalc() {}
    //note this will be called by loop, if param needed and changed, before any module precalcs
    
    public boolean checkneededforplot() { return register.checkneededforplotexcept((param)this , jcmTree.class); }
    
//********* QUERY *******
    
    public boolean isdefault() {
	if (type==type.menu) return chosen==defchosen;
	if (type==type.option) return flag==defflag;
	if (type==type.value) return val==defval;
	return true;
    }
    
//used for interactions/enabled criteria
    public T getchosen() { return chosen; }
    
    public String getstringval() {	return ""+((type==type.option) ? ""+flag : (type==type.menu) ? chosen.toString() :  (type==type.value) ? ""+units.round(val) : ""); }
    
    public complexity getItemComplexity(T o) { 	if (itemcomplexity!=null) {
	try {
	    for (int j=0; j<menulist.length; j++) if ( o.equals(menulist[j])) return (itemcomplexity[j]!=null ? itemcomplexity[j] : complexity.simplest);
	} catch  (ArrayIndexOutOfBoundsException e) { deb("param item complexity error"); }
    }
    return mycomplexity;
    }
    
    public boolean checkcomplexity(T o) { return complexity.check(getItemComplexity(o)); }
    
    public double getval() {	return val; }
    public double getdef() {	return defval; }
    public double getfrac() {	return val/defval; }
    public boolean istrue() {	return flag; }
    public boolean isfalse() {	return !flag; }
    
    public float min() {	return (float)min; }
    public float  max() {	return (float)max; }
    public float  range() {	return (float)(max-min); }
    
    
    public boolean isnotdefault() {
	if (type==type.menu) return chosen!=defchosen;
	if (type==type.value) return val!=defval;
	if (type==type.option) return flag!=defflag;
	return false;
    }
    
    public String chosenname() { 	return chosen.toString();    }
    public String getname(int i) {	return menulist[i].toString(); }
    public String getname(Object o) {
	if (o instanceof String) return (String)o;
	try {return o.getClass().getField("name").get(o).toString(); } catch (Exception e) {}
	try {return o.getClass().getMethod("getName").invoke(o).toString(); } catch (Exception e) {}
	if (o instanceof interacob) return ((interacob) o).name;
	if (o instanceof Enum) return ((Enum)o).name() ;
	return o.getClass().getSimpleName();
    }
    
    public int getchosenindex() { //adapted to take into account changing complexity!
	int i=0; for (T o : menulist) { if (chosen.equals(o)) return i; if (checkcomplexity(o)) i++;   } return -1;
    }
    
    
    
//************************************
//LAB / DOC
    
    
    public String getinfo() {  return getLabel() +getstate() +addunits();    }
    
    public String addunits() { 	return  (type==type.value)? " \t\t"+ labman.getShort(units.units) : "";    }
    
    public String getstate() {
	if (type==type.menu) return (" \t\t"+labman.getTitle(chosen.toString())+" (def="+labman.getTitle(defchosen.toString())+") \n");
	if (type==type.option) return (" \t\t: "+(flag ? labman.getTitle("ena") : labman.getTitle("dis") )+" (def="+(defflag ? labman.getTitle("ena") : labman.getTitle("dis") )+") \n");
	if (type==type.value) return (" val="+units.round(val, dp)+ " (def="+ units.round(defval, dp)+") \n")	;
	if (type==type.Xscale || type==type.Yscale) return type+": "+units.round(min)+" - "+units.round(max) +" "+labman.getShort(units.units)+labman.getTitleIfDifferent(units.units);
	return "";
    }
    
    public String docSummary() {
	//should add the Slider / Box etc. here - how?
	return hashcolor()+(checkenabled(filtertype.AllParams) ? "" : " //(inactive)// ")+ autodoc.link(this) +"</font> "+ "£%"+labman.convertkey(name)+"<br>";
    }
    
    public String getExtraDoc() {
	if (type==type.Xscale || type==type.Yscale) return getinfo();
	return getInput()+moreinfo()+docNotes()+"<hr>"+docInteracs()+autodoc.javacode(this);
    }
    
    public String getInput() {
	return  " <object classid=jcm.gui.nav."+
		(type==type.option ? "paramOption" : type==type.menu ? "paramMenu" :  "paramValueChooser")
		+"><param name=paramName value='"+name+"'></param></option><br>";
    }
    
    public String moreinfo() {
	if (type==type.menu) {
	    String info2=""; for (int i=0; i<numitems; i++)  { String n=labman.convertkey(getname(i));  info2+="<li>"+ autodoc.link(n)+" £%"+n; }
	    return "<hr> £`moreinfo <ul>"+info2+"</ul>";
	}
	if (type==type.value && pair!=null) return   "<hr>"+pair.getInput()+pair.moreinfo();
	return "";
    }
    
    
  
    
       /*
    public String getInput() {
	String pi=" <br>%%?adju ��paraminterac %%<br>";
	if	(type==type.option) return  " <input type=checkbox "+(flag ? "checked" : "" )+" > " +pi;
	if   (type==type.value) return 	" <input type=text value="+ units.round(val, dp)+" > "
		+ ((units!=null) ? labman.getTitle(units.units) : "")
		+(isnotdefault() ? " (<i>�`default : "+ units.round(defval, dp)+"</i>) "  : "")+pi;
	
	if  (type==type.menu) {
	    String info=" <select>";
	    for (int i=0; i<numitems; i++) info+="<option "+getname(i)+(i==getchosenindex() ? " selected" : "")+" >"+ labman.getTitle(getname(i));
	    return info+"</select>"+pi;
	}
	if (type==type.trigger) return  " <input type=button value='"+labman.getShort(name)+"' > "+pi;
	return "";
    }
	*/
    
    
//******* COMPONENT, MENUITEM ***********
//P1 param getcomponent  is really gui code, could be merged into the choosers?
//is it possible to combine getComponent and getMenuItem?
//used mainly in trees
    public JComponent getComponent(Object ... args) {
	if (type==type.menu)  return new paramMenu(this, args);
	if (type==type.value)  return new paramValueChooser(this, args);
	if (type==type.option) return new paramOption(this, args);
	return super.getComponent();
    }
    
//used by topMenus, mapplot, docView etc.
    public JMenuItem getMenuItem() {
	if (type==type.menu) {
	    jcmMenu pm= new jcmMenu(name);
	    ButtonGroup group = new ButtonGroup();
	    for (final T o : menulist) if (complexity.check(getItemComplexity(o))) {
		JRadioButtonMenuItem rbmi=new JRadioButtonMenuItem(
			new jcmAction(getname(o), getItemComplexity(o) ) {    public void act() {	set(o); } }
		);
		group.add(rbmi);
		pm.add(rbmi);
		if (o==chosen) rbmi.setSelected(true);
	    }
	    return pm;
	}
	
	if (type==type.option) {   return new cb(this); }
	
	if (type==type.value) {
	    //to fix in mac! plots but not useable - maybe better since removed setArmed false
	    JMenuItem jm= new JMenuItem();
	    JComponent c= getComponent("menu");
	    jm.setLayout(null);  jm.setEnabled(true);
	    //jm.setArmed(false);
	    jm.add(c);    c.revalidate();
	    c.setLocation(0,0);     c.setSize(c.getPreferredSize());     jm.setPreferredSize(c.getPreferredSize());
	    return jm;
	    //jcmMenu pm= new jcmMenu(name); pm.add(jm);   return pm;
	}
	return null;
    }
    
    class cb extends JCheckBoxMenuItem implements plotlink, ChangeListener {
	public cb(param p) {
	    setText(name); setSelected(istrue()); setForeground(getColor());
	    addChangeListener(this); register.addlink(this, p);
	}
	public void doplot() {  if (changed) loop.golater("CB doplot"); setSelected(istrue());  setToolTipText(getinfo()); }
	public void stateChanged(ChangeEvent e) {	if (istrue() !=isSelected())  set(isSelected()); setText(param.this.getLabel()); setToolTipText(getinfo()); }
	public void addNotify() {super.addNotify();  doplot();  }
    }
    
    
}//end param class




