/**
a loopcalc contains some calculation methods 
it extends interacob, and is extended by module (which also contains other items)
note - loop will call calcstep for every year (slow!), so don't make interacobs into loopcalcs unecessarily
by default  a simple loopcalc will affect and be affectedby its containing module
 */

package jcm.core.ob;

import jcm.core.ob.*;
import jcm.core.register;
import static jcm.core.report.*;

public class loopcalc extends interacob {

    //*********** flags ****************
    public boolean affectsfutureonly = false;
    public boolean err; //used by loop to flag RuntimeExceptions

    //************ STATIC TIME ***************
    public static int year = 0; //time variable changed before loop calcstep - shared by all modules
    //constants specifying years: global start year, global end year,  future start year
    // gey is user-adjustable, fsy is changed occasionally as data is updated
    // at the moment, fsyog must equal fsyfos (otherwise other gas emissions don't calculate right...)
    // fossil extrapolation is available to same times as gdp, ie 2014, but for political reasons better to 
    static public int gsy = 1750,  fsypop=2005, fsygdp=2014, fsyfos = 2013,  fsyog = fsyfos,  fsyluc = 2003,  gey = 2300;

    //****** CONSTRUCTOR *************
    public loopcalc(String n) {   name=n;    }
    public loopcalc() { super(); }  
    
    //****** FOLLOWS *************
    public void follows(loopcalc lc) {
        follows(lc, true);
    }

    public void follows(loopcalc lc, boolean b) {
        register.follows(this, lc, b);
        setaffectedby((interacob) lc, b);
    //note: this should give a cast exception if the lc is not an interacob!
    }

    //******** LOOP methods ***********************
    //before main calc loop
    //note some params also have a precalc method, which runs before any loopcalc
    public void precalc() {
    }

    //calc just one timestep in time loop
    public void calcstep() {
    }

    //after main calc loop
    //note some curvesets also have a postcalc method, which runs after any loopcalc
    public void postcalc() {
    }

    //***************  OLD LOOP METHODS *********** 
    //restore start state in a certain year (for combination with save99
    public void startstate(int startyear) {
    }

    //save state in 1999 for calc future only
    public void save99() {
    }
    //***********      CHECK TIME SPENT ***************
    //to report info on slow calculations - currently usedonly by calclucemit
    //note interacob has timespent info 
    static long lasttimecheck = System.nanoTime(),  oldtime = lasttimecheck;

    public static void reporttime(String info) {
        lasttimecheck = System.nanoTime();
        deb("Time> "+ info + ": time since last report " + (lasttimecheck - oldtime) + " ms ");
        oldtime = lasttimecheck;
    }
} //end class
 
