/*
INTERACTION OBJECT CLASS
 Extends infob to add  interaction between model components
  Extended by: module(s), param,  qtset
 
 */



package jcm.core.ob;
import java.util.Vector;
import jcm.gui.doc.autodoc;
import jcm.gui.doc.labman;
import static jcm.core.register.*;
import static jcm.core.report.*;

public class interacob extends infob {
    
    
    //****************************
    //FLAGS
    public boolean
            
            changed=true,	//set true when parameter adjusted, all interacobs affectedby this will be set changed too, reset false by loop after recalcuated
            output=false, 	//needed for direct output, e.g. visible plot, table or parameter (which may need to replot in after loop calcs)
            needed=false,	//needed (maybe indirectly) because of output (and likewise everything which this is *affected by*)
            checked=false, 	//used within changed loop
            temporary=false,	//used to dispose of temporary interacobs, e.g. ratio qtsets -see baseplot
            skip=false;		    //if true, loop will skip calcs for this, will remain changed
    
    public long timespent=0; //for checking performance
    
    //*****************************
    //COLLECTIONS
    
    // all the other iobs this interacts with
    public Vector<interacob> vaffectedby =new Vector(), vaffects =new Vector();
    
    //*****************************
    //CONSTRUCTORS
    
    public interacob() { }
    public interacob(String n) {	name=n; }
    public interacob(String n, interacob i) {	name=n; owner=i; } //for iobs simply used as cause-effect logic links
    
    
    //****************************
    //INTERACTIONS
    
    //permanent effects
    public void setaffectedby(interacob ... iobs) { for (interacob i : iobs)	if (!vaffectedby.contains(i)) {	vaffectedby.addElement(i); i.vaffects.addElement(this); }}
    public void setaffects(interacob ... iobs) { for (interacob i : iobs)  if (!vaffects.contains(i)) {	vaffects.addElement(i); i.vaffectedby.addElement(this); }}
    public void setnotaffectedby(interacob ... iobs) {	for (interacob i : iobs) { vaffectedby.removeElement(i); i.vaffects.removeElement(this); }}
    public void setnotaffects(interacob ... iobs) {	 for (interacob i : iobs) { vaffects.removeElement(i); i.vaffectedby.removeElement(this); }}
    
    public void setaffectedby(boolean flag, interacob ... iobs) {	if (flag) setaffectedby(iobs); else setnotaffectedby(iobs); }
    public void setaffects(boolean flag, interacob ... iobs) {	if (flag) setaffects(iobs); else setnotaffects(iobs); }
    
    
    public void setaffectedby(interacob iob, boolean flag) {	if (flag) setaffectedby(iob); else setnotaffectedby(iob); }
    public void setaffects(interacob iob, boolean flag) {	if (flag) setaffects(iob); else setnotaffects(iob); }
    
    public boolean affectedby(interacob iob) {	return vaffectedby.contains(iob); }
    public boolean affects(interacob iob) {	return vaffects.contains(iob); }
    
    //setinteractions() of all modules and panels: called by loop,    this should contain affected, affectedby interactions as needed
    public void setinteractions() {	}
    
    //interacinfo not currently used but  maybe still useful for debugging
    public String interacinfo() {	String s= (output ? "O" : "") + (needed ? "N" : "") + (changed ? "C" : "") + " ";
    for (interacob i : vaffects) s+=">"+i.name+" ";
    for (interacob i : vaffectedby) s+="<"+i.name+" ";
    return s;
    }
    
    //***********************************
    public void changeendyear(int oldey, int newey) { changed=true; } //should be overridden by all interacobs that need to adjust data structure when endyear is changed
    
    //************************************
    //REGISTER
    public void register(){
        if (!alliobs.contains(this)) {
            alliobs.addElement(this);
            //System.out.println("R: "+(owner.getname().equals(name) ? "" : owner.getname()+"~")+name+" ");
                                /*
                                if (owner.getname()!=on) {	on=owner.getname(); if (checkreg) System.out.print("\n O:"+on+" "); }
                                newcn=getClass().getName().substring(8);
                                if (!newcn.equals(cn)) {	cn=newcn; *if (checkreg) { if (cn.equals(on)) System.out.print("(C) "); else System.out.print("\n (C:"+cn+") "); } }
                                if (on!=name)  if (checkreg) System.out.println(owner.getname()+"~"+name+" ");
                                 */
        }
    }
    
    
    
    //******** DISPOSE ****************************
    //extend infob method to also dispose all interacobs whose owner is this
    //be careful not to call this from inside a loop.go()! -e.g. must invoke later if response to a param
    
    // P3 CHECK static so dispose can adjust this from within loop! - may no longer be needed since we have no more iobloop - note this is never set, strange that disposethis works!
    static int iobdisp;
    
    public void disposethis() {
        super.disposethis(); //infob method: removes Obs and sets disposed true
        
        for (int i=0; i<alliobs.size(); i++) {
            interacob ii=alliobs.elementAt(i) ;
            if (ii.owner==this) {
                for (interacob j : alliobs) {	j.setnotaffectedby(ii); j.setnotaffects(ii); }
                if (ii!=this) {	ii.disposethis(); if (i<=iobdisp) iobdisp--; i--; } //recursive! note the i-- to step back because alliobs has changed!
            }
        }
        //if (checkreg) System.out.println( "disposing "+name);
        alliobs.removeElement(this);   plotlinkmap.remove(this);
    }
    
    
    //****************************
    //DOC
    
    public String getExtraDoc() {
        return labman.getDoc(name)+"----"+docNotes()+docInteracs()+autodoc.javacode(this);
    }
    
    
    public String docInteracs() {
        String affinfo= docaffectedby()+docaffects(); 
        //this works but is too long - don't want to read it for every item => instead make the title a hyperlink to this info
        //if (affinfo.length()>5) affinfo+=" £§interacs <br>"; 
        return "  == €€cogs @interacs ==" +docOwner()+affinfo+"";
    }
    public String docaffects() {
        String info=""; int c=0;
        for (interacob io : vaffects) if (io.owner==io && io.owner!=owner  && !io.disposed) {	c++; info+=(c>1 ? ", " : "") +autodoc.link(io.owner); }
        return (c>0 ? "<nobr>%% £`affects : "+info+" %%</nobr><br>" : "");
    }
    public String docaffectedby() {
        String info=""; int c=0;
        for (interacob io : vaffectedby)  if (io.owner==io /*&& io!=holder.owner*/ && !io.disposed) {	c++; info+=(c>1 ? ", " : "") +autodoc.link(io.owner); }
        return (c>0 ? "<nobr>%% £`affectedby : "+ info+" %%</nobr><br>" : "");
    }
    
    
    
} //end class

