
package jcm.core.data;

import java.io.*;
import java.util.*;
import jcm.core.*;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.reg.region;
import jcm.core.reg.regman;
import jcm.core.tls.fileio;
import static jcm.core.report.*;

public class loadtable {
    
    public interface combiner {  float[] combine(float[] in);      }
    
    
    /*
    loaddata assumes that first two rows are information only, to be ignored
    transposed means that names go across third row, otherwise down first column
    convreg means convert names to regions, and combine as necessary:
    when more than one value is  found for one region (typically with different aliases in countrynames, eg for small islands) values are added together
     
     to load several tables and combine the data, use the combiner interface
     */
    public static void loaddata(curveset qq, String filename, String separator, boolean transposed,  float scalar, int sy, int ey, int usefromy) { loaddata(qq, filename, separator, transposed, true, scalar, sy, ey, usefromy, 1); }
    
    public static void loaddata(curveset qq, String filename, String separator, boolean transposed, boolean convreg,  float scalar, int sy, int ey, int usefromy, int step) {
	
	
	String[][] tab=fileio.loadtab(filename, separator); //row, column
	
	int nreg=transposed ? tab[2].length-1 : tab.length-3;
	Set<curve> gotfirst=new HashSet();
	
	for (int i=0; i<nreg; i++) {
	    String regname=transposed ? tab[2][1+i] : tab[3+i][0];
	    curve q=qq.getOrAddCurve(convreg ? regman.allreg.findormakereg(regname, filename) : regname);
	    boolean first=!gotfirst.contains(q); gotfirst.add(q);
	    if (!first && !convreg) deb("warning: duplicate key name "+regname+":- values will be summed!");
	    
	    for (int y=usefromy; y<=ey; y+=step) try {
		float f, a;
		
		try {
		    f=Float.parseFloat(transposed ?  tab[3+(y-sy)/step][1+i] : tab[3+i][1+(y-sy)/step]);
		    if (f==-999f) deb("warning: -999 in data input file no longer interpreted as dud! - use text eg NaN");
		} catch (RuntimeException e) { f=curve.dud;  } // ignore parser errors
		
		if ( !Float.isNaN(f)){
		    f = scalar*f;
		    a= (first || !q.gotdata(y)) ? 0 :  q.get(y);  // old version prior to sep07 had extra condition f>0 - remove if seems ok:   a= first && f>0 ? 0 : q.get(y) == qt.dud ? 0 :  q.get(y);
		    q.set(y, f + a);
		}
		//else if (first) q.set(y, curve.dud);
		//if first added sep07: idea is to keep some data even if dud for a small extra subregion
		//but this prevents blending two data sets (one with gaps) into one qtset
		
	    } catch (RuntimeException e) { deb(e, filename+" "+q.name +" "+y); } //end timestep loop
	} //end region loop
    }
    
    
    public static void oldsplit(curveset qq) {
	//split emissions from former regions FSU, FYU, etc.
	
	for (region rs : regman.allreg.findreg("OLDSPLIT").reg) {
	    Set<region> sub=rs.subreg(qq);
	    //for (region r : sub) deb(r);
	    
	    //find y =last year of sr data, then calc frac of emissions y+1
	    Map<region, Float> frac=new HashMap(sub.size());
	    int y=2000; while (qq.getOrAddCurve(rs).get(y)<=0) y--;
	    float sum=0; for (region r : sub) sum+=qq.getOrAddCurve(r).get(y+1);
	    for (region r : sub) frac.put(r, qq.getOrAddCurve(r).get(y+1)/sum);
	    
	    float f; while ((f=qq.getOrAddCurve(rs).get(y))>0) {
		for (region r : sub) qq.getOrAddCurve(r).set(y,  f * frac.get(r)); //beware fill not add, so other contributions won't be counted!
		y--;
	    }
	    qq.map.remove(rs);
	}
    }
    
    
    
    
    
} //end class

