
package jcm.core.cur;

import java.awt.Color;
import java.util.*;
import javax.swing.JOptionPane;
import jcm.core.*;
import jcm.core.par.param;
import jcm.core.ob.*;
import jcm.gui.doc.autodoc;
import jcm.core.reg.region;
import jcm.core.itf.*;
import jcm.gui.nav.*;
import jcm.gui.nav.filter;
import jcm.gui.plot.*;
import jcm.gui.doc.labman;
import static  jcm.gui.gen.colfont.*;
import static jcm.core.report.*;
import static jcm.core.cur.curve.Type.*;

/**
  a set of curves from which a plot or table may be created
 <br>(see {@link curve})
 <br>all curves share the same units
 <br>curvesets are usually created and filled by modules
 <br>note extension {@link curvvar}
 */
public class curveset extends interacob implements menuFiller {
    
    
    // ****** FIELDS **********************
    /** reference to the curves */
    public Map<Object, curve> map=new LinkedHashMap();
    
    /** type of curve - used for derivatives -see {@link curvar} */
    public curve.Type type=normal;
    
    //note these ints are duplicated within curves (but maybe different)
    public int
	    /** start year */   sy=module.gsy,
	    /**end year */  ey=module.gey,
	    /** timestep */   xstep=1;
    
    /** Units: see {@link units} */
    public String units="nounits";
    
    /** flag to tell tree to restructure*/
    public boolean justadded=false;
    boolean gotmap=false; //used to add map action to tree
    
    /** associated parameters for draggable arrows*/
    public Set<param> assocparams;
    
    curve  totalcurve=null, selectedcurve=null;
    
    /** for use by datasets with uncertainty info */
    public enum prob { min, low2sd, low1sd, median, mean, hi1sd, hi2sd, max}
    //EnumSet<prob> probset=EnumSet.of(prob.mean);
    
    //******** CONSTRUCTOR ************
    /**
     curveset constructor can take any of these arguments:<ul>
     <li> Strings: a name (used to look up labels), and units see {@link units})
     <li> Integers: the start year, end year and x-step
     <li> a color,
     <li> a complexity level
     <li> a {@link curve.Type}
     <li> an interacob which affects it, and gives it a name
     <li> curves to add,
     </ul> note: to construct derivative curvesets see {@link curvar}
     */
    
    public curveset(Object ...args) {
	
	if (this instanceof curvar) return; //avoid use both constructors!
	color=null;
	
	int sc=0, ic=0;
	for (Object o : args) {
	    
	    if (o instanceof interacob) { owner=(interacob) o; setaffectedby((interacob) o); name=owner.name;    }
	    
	    if (o instanceof Color) { color=(Color)o; }
	    if (o instanceof complexity) { mycomplexity=(complexity)o; }
//	    if (o instanceof prob) { probset.add((prob)o); }
	    if (o instanceof curve.Type) type=(curve.Type)o;
	    
	    if (o instanceof curve[]) for (curve q : (curve[])o) addcurve(q);
	    if (o instanceof curve) addcurve((curve)o);
	    if (o instanceof String) {
		switch (sc) {
		    case 0: name=(String)o; break;
		    case 1: units=(String)o; break;
		}
		sc++;
	    }
	    if (o instanceof Number) { //duplicating curve!
		int i=((Number) o).intValue();
		switch (ic) {
		    case 0: sy=i; break;
		    case 1: ey=i; break;
		    case 2: xstep=i; break;
		}
		ic++;
	    }
	    
	} //o
	
	if (mycomplexity==null) { if  (map.size()>0) mincomplexity(map.values()); else mycomplexity=complexity.normal; }
        priority=(mycomplexity==complexity.simplest) ? 2.15 :  (mycomplexity==complexity.normal) ? 2.1 : (mycomplexity==complexity.expert) ? 2.05 : 2.0;

	if (color==null) color= rcol(owner.color);
	addActions();
	register();
    } //end constructor
    
    
//*************** ACTIONS / MENU *************************************
    
    //called from constructor
    void addActions() {
	addAction(filter.filtertype.Curves, showpan.pan("Plot", lineplot.class, this));
	addExtraPlotAction();
	addAction(filter.filtertype.Curves, showpan.pan("Table", datable.class, this));
	checkforMapAction();
	addAction(filter.filtertype.Doc);
    }
    
    void addExtraPlotAction() {} // used by curvesetvar
    void checkforMapAction() {
	if (!gotmap) for (Object o : map.keySet()) if (o instanceof region) { gotmap=true; addAction(filter.filtertype.Maps, showpan.pan("Map", mapplot.class, this));  return; }
    }
    
    /** makes the popup menu from the tree or from a plot (right-click) for all filter types */
    public void fillMenu(jcmMenu pop) { fillMenu(pop, filter.all()); }
    /** makes the popup menu from the tree or from a plot (right-click) for specific filter-type */
    public void fillMenu(jcmMenu pop, Set<filter.filtertype> fs) {
	checkforMapAction(); // can change due to adding regions
	super.fillMenu(pop, fs); //permanent actions
	pop.addSeparator();
	if (fs.contains(filter.filtertype.Curves))  pop.add(makederiv.makevariantmenu(this));
    }
    
    
    //************* MISC ****************
    
    /** associate parameters for showing draggable arrows*/
    public void associate(param ... pp) {
	if (assocparams==null) assocparams=new HashSet(3);
	for (param p : pp) assocparams.add(p);
    }
    
    /** note: changing end year is slow, as it has to change the data array structure inside each curve */
    public void changeendyear(int oldey, int newey) {
	if (ey==oldey) {
	    ey=newey;
	    for (curve q : map.values()) q.changeendyear(oldey, newey);
	    changed=true;
	}
    }
    
    
//********************** ADD / MAKE curve **************************
    /** add a curve with a specific key, resetting total and complexity */
    void addcurve(Object o, curve q) {
	map.put(o, q);
	if (o==jcm.core.reg.regman.world && q.type==normal) q.type=total;
	if (totalcurve==null && q.type==total) totalcurve=q; //note total is set to the first curve of type=total
	if (mycomplexity==null) mincomplexity(map.values());
	if (q.owner==q) q.owner=this;
    }
    
    /** add several curves, using the curves names as keys */
    public void addcurve(curve ... qq) { for (curve q : qq) addcurve(q.name, q);  }
    
    /** make  ( see {@link curveset#makecurve(Object)} ) , add, and return  a new curve for a specific key  */
    public curve addNewCurve(Object key) {
	curve q=makecurve(key);
	if (mycomplexity!=null && key instanceof region) q.mycomplexity=mycomplexity; //curveset compleity overrides region complexity
	addcurve(key, q); return q;
	//System.err.println("creating curve for "+r+" in "+name+" "+qqa.map.get(r) );
    }
    
    
    /** make a new curve for a specific key - using its name and color.  more variants are handled in {@link curvar#makecurve(Object)}   */
    public curve makecurve(Object key) { //overridden by curvevar
	if (key instanceof infob) {
	    infob io=(infob)key; return new curve(io.getName(), io.getColor(), sy, ey, xstep, this);
	} else return new curve(key.toString(), sy, ey, xstep, this);
    }
    
//******************** FIND OR MAKE curves ***************
    
    /** returns the curve for the specified key, or null if it doesn't exist*/
    public curve getcurve(Object key)  { return map.get(key); }
    
    /** selects one curve to use in subsequent simple get() methods -or calls {@link curveset#addNewcurve(Object) } if it doesn't exist */
    public void select(Object r) { selectedcurve=getOrAddCurve(r); }
    
    
    /** returns the curve for the specified key, or calls {@link curveset#addNewcurve(Object) } if it doesn't exist */
    public curve getOrAddCurve(Object key)  {
	if (map.containsKey(key)) return map.get(key);
	return addNewCurve(key);
    }
    
    /**extends infob method to find a curve if the name matches, used by autodoc */
    public infob find(String name) {
	infob o=super.find(name); if (o!=null) return o;
	for (Object oo : map.keySet()) if (oo.toString().equals(name)) return map.get(oo);
	return null;
    }
    
    
    //********************GET SET FIND ***************
    
// below are convenience combinations
// note the first two are overridden by curvesetvar
    
    /** true if get(r, year) will not return dud */
    public boolean gotdata(Object r, int year) {return  !Float.isNaN(get(r, year)); }
    /** gets value for key and year ( if key not found, returns curve.dud)  */
    public float get(Object r, int year) { try { return getcurve(r).get(year); } catch (NullPointerException e) { return curve.dud; }}
    /** gets value for key, in current module.year (if key not found, returns curve.dud ) */
    public float get(Object r) {try { return getcurve(r).get(); } catch (NullPointerException e) { return curve.dud; }}
    /** gets value for key set by {@link curveset#select(Object)},  and specified year  */
    public float get(int year) {return selectedcurve.get(year);}
    /** gets value for previously selected key,  and current module.year  */
    public float get() {return selectedcurve.get();}
    
    /** sets value for specified key and year (if key not found, makes a new curve first) */
    public void set(Object r, int year, float f) { getOrAddCurve(r).set(year, f); }
    /** sets value for specified key and current module.year  (if key not found, makes a new curve first )   */
    public void set(Object r,  float f) { getOrAddCurve(r).set( f); }
    /** sets value for key set by {@link curveset#select(Object)} and specified year*/
    public void set(int year, float f) { selectedcurve.set(year, f); }
    /** sets value for key set by {@link curveset#select(Object)} and  current module.year */
    public void set(float f) { selectedcurve.set(f); }
    
    /** adds value to that of specified key and year, if key not found makes new one, if one value dud just uses  the good one, if both dud, stays dud,  */
    public void add(Object r, int year, float f) {
	getOrAddCurve(r); 	float base=get(r, year);
	set(r, year, (Float.isNaN(f) ? (Float.isNaN(base) ? curve.dud : base) :  (Float.isNaN(base) ? f : f+base ) ));
    }
    /** multiplies value of  specified key and year by the float (if key not found, does nothing) */
    //seems to be a problem with this method?
    public void multiply(Object r, int year, float f) { if (getcurve(r)!=null) set(year, get(r, year)*f); }
    
    
//**************** SCALE, MINMAX, TOTAL ************
    
    /** get units (see {@link units})*/
    public String getunits() {	return units; }
    
    /** gets an x-scale adjustable parameter based on sy and ey */
    public param getxscale() {
	return new param(param.Type.Xscale,  "Xscale", "year", 0, Math.max(sy,1840), Math.min(ey,2160), 50);
    }
    
    /** gets an y-scale adjustable parameter based on calculated min and max */
    public param getyscale() { return getyscale(false); }
    public param getyscale(boolean stacked) {
	float min=getmin(), max=getmax(stacked);
	param p=new  param(param.Type.Yscale,  "Yscale", units,  0, min, max, 1);
	p.units.checkunitfac(max-min); p.units.checkunitcancel();
	return p;
    }
    
    /** maximum value of all curves visible at current complexity */
    public float getmax() {	float max=Float.MIN_VALUE; for (curve q : map.values()) if (q.checkcomplexity()) max=Math.max(max, q.getmax()); return max; }
    /** minimum value of all curves visible at current complexity */
    public float getmin() { float min=Float.MAX_VALUE; for (curve q : map.values()) if (q.checkcomplexity()) min=Math.min(min, q.getmin()); return min; }
    
    /** if parameter is true: maximum value of the total of all curves, if false, same as getmax() */
    public float getmax(boolean stacked) { //used by lineplot for scaling stacked plot: note this may be rather slow!
	if (!stacked) return getmax();
	float max=Float.MIN_VALUE; for (int year=sy; year<ey; year+=xstep) {
	    float tot=0; for (curve q : mapwithouttotal().values()) if(q.gotdata(year)) tot+=q.get(year); if (tot>max) max=tot;
	}
	return max;
    }
    
    /** calculates total for current module.year */
    public float calctot() { return calctot(module.year); }
    /** calculates total for a specific year - ignoring dud values, and also puts result in the total curve (making one if it doesn't exist yet)  */
    public float calctot(int year) {
	if (totalcurve==null) totalcurve=getOrAddCurve(jcm.core.reg.regman.world);
	float f, t=0;
	for (curve q : mapwithouttotal().values()) {f=q.get(year); if (!Float.isNaN(f)) t+=f; }
	totalcurve.set(year, t); 
        return totalcurve.get(year);
    }
    
    /**  scales all curves proportionally, such that the total is  equal to the specified value */
    public void topdownscale(float global) { topdownscale(global, false); }
    /**  as topdownscale(float), but excluding the curve  "bunker" if second param is true  */
    public void topdownscale(float global, boolean excludebunker) {
	float regtot=calctot(), f, r;
	if (excludebunker) {
           float b=get("bunker"); if(!Float.isNaN(b)) { regtot-=b; global-=b;  }
        }
        r=global/regtot;
	if (regtot>0) for (curve q : map.values()) if ( !(excludebunker && q.name.equals("bunker"))) { f=q.get(); if (!Float.isNaN(f)) q.set(f*r); }
    }
    
    /** get a map of curves, exlcuding any whose type is  set to 'total'  */
    //note some curvesets eg aerosol have more than one total
    public Map<Object, curve> mapwithouttotal() {
	Map<Object, curve>  m=new LinkedHashMap();
	for (Map.Entry<Object, curve> me : map.entrySet()) if (me.getValue().type!=total) m.put(me.getKey(), me.getValue());
	return m;
    }
    
    /** recalculates integral - called by loop*/
    public void postcalc() {
	//if (total!=null) for (int y=sy; y<=ey; y+=xstep) calctot(y); //for plots - BUT causes big problem with carbon cycle totemit!
	if (type==integral) {
	    for (curve q : map.values()) q.calcintegral();
	}
    }
    
    
//****************** AUTO-DOC *********************************
    
    /** wiki doc: units, curves, interactions, code-link */
    public String getExtraDoc() {
	return docUnits()+docCurves()+"----"+docNotes()+docInteracs()+autodoc.javacode(this);
    }
    
    /**  wiki documentation about units (for autodoc) **/
    public String docUnits() {
	String s="==Units==";
	s+="units: "+labman.getTitle(units)+"<br>";
	s+="timescale (years) "+sy+"-"+ey +" (step "+xstep+")<br>";
	return s;
    }
    
    /** wiki documentation about curves (for autodoc) */
    public String docCurves() {
	String s="==Curves==";
	if (map.size()==0) s+="£§nocurvesyet";
	else {
	    s+="<ul>"; for (curve q : map.values()) if (q.checkcomplexity()) s+="<li>"+q.docSummary(); s+="</ul>";
	}
	return s;
    }
    
    
//***********************************************************
} //end class


