/*
 Start JCM class
Opens the main frame, Makes main menus, Initiates modules
 
 P2 Note all labels are loading, before MF shows!
 */

package jcm;
import java.text.SimpleDateFormat;
import java.util.Date;
import jcm.core.*;
import jcm.core.ob.loopcalc;
import jcm.core.report;
import jcm.core.ob.root;
import jcm.gui.doc.*;
import jcm.gui.gen.*;
import jcm.gui.nav.showpan;
import jcm.gui.nav.jcmTree;
import static jcm.core.report.*;

public class StartJCM {
    
      /*P4  update revision date - also in update.js for webdoc
         Change this date before final compliation to put online (maybethis should be incorporated into build script - how?)
         Will affect splash, titlebar, sourceview, doc welcome page, ...
         */ 
    public static String revisiondate="25th Jan 2009";
    

    // ********** MAIN **********
    public static void main(String[] args) {
	
	report.start(); //captures errors and log info
        //note getting System property like gives permission denied in "safe" jnlp mode!
        String s="not available"; try {s=System.getProperty("java.runtime.version"); } catch (Exception e) {}; 
        log("java runtime version = "+ s);
	//*************** SHOW SPLASH **********************
	splash splash=new splash();
	loopcalc.reporttime("created splash screen ");
	
	//*************** EXPLORE PACKAGE *******************
	splash.report("Explore Package Roots");
	root.makeroot();
	
	//**************** LABELS *************************
	splash.report("Load labels");
	
	//temporarily moved to start, to check menus
	labman.loaddefaultchanges(); //should do before show any doc with setup!
	
	
	//************* RESTORE SETUP ****************************
        //note this will also trigger the world to setup - which adds lots of messages to the log file
	boolean succeeded=false;
	if (args.length>0 && args[0] !=null && args[0].length()>0) try {
	    splash.report("Loading Setup: "+args[0]);
	    succeeded=setup.loadpacksetup(args[0]);
	} catch (Exception e) { deb(e, "error in loading package setup "+args[0]); }
	
	if (!succeeded || setup.restart) {
	    splash.report("Restoring Previous Setup");
	    setup.loadcurrentsetup();
	}
	
	// ************** CHECK MF EXISTS, ADD TREE IF NONE **********
	if  (showpan.mf==null) showpan.makeMainframeDefSize();
	
	//showpan.show(startdialog.b, "JCM Startup Info"); //used to call "toFront', but now layout has changed this doesn't work
	if (register.getComponentsOfType(jcmTree.class).size()==0) showpan.makepan(jcmTree.class, null);
	//if (register.getComponentsOfType(docview.class).size()==0) showpan.makepan(docview.class, null);
	
	
	//************* LAZY LOADING****************************
	/*
	 The point of below is to stimulate download of the other jars  (especially if using JWS),
	 */
        loopcalc.reporttime(" JCM ready to use ");
        
        logn("========================== Lazy Loading =================================================");
	splash.message("<html><font color=orange>JCM is now ready to use<p> Meanwhile some extra data will continue to load" );
	
	splash.report("Loading documentation");
	try { deb("-preloaded: "+register.class.getResource("/labdoc/doc_base_en.txt").getPath()); } catch (Exception e) { deb("no documentation"); }
	splash.report("Loading source");
	try { deb("-preloaded: "+register.class.getResource("/src/jcm/StartJCM.java").getPath()); } catch (Exception e) { deb("no source package"); }
	splash.report("Loading GCM-data");
	try { deb("-preloaded: "+register.class.getResource("/gcmdata/basehad3.pre.dat").getPath()); } catch (Exception e) { deb("no GCM-data"); }
	
        /* below no longer useful since world setup has already triggered it (even if no plots visible - see note in LUCdata.java)
        splash.report("Loading CalcLucEmit data");
	LUCdata.getdata(); //so that plots open faster. note, this should not clash with event despatching thread
	*/
        
	if (setup.restart) {
	    splash.report("Restoring Previous Setup");
	    setup.loadcurrentsetup();
	}
	
	//************ REMOVE SPLASH ********************
	splash.end();
        loopcalc.reporttime("end startup ");
        logn("======================= End of Startup ====================================================");
	
    } //end main
    
    
}//end class








