/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regimp;

import java.awt.Color;
import javax.swing.JLabel;
import jcm.core.complexity;
import jcm.core.cur.units;
import jcm.core.loop;
import jcm.core.ob.interacob;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.core.reg.region;
import jcm.core.report;
import jcm.gui.gen.processdialog;
import jcm.gui.nav.filter;
import jcm.gui.nav.showpan;
import jcm.gui.plot.colormap;
import jcm.gui.plot.mapplot;
import jcm.mod.cli.glotemp;
import jcm.mod.regimp.mapdata;
import jcm.mod.regimp.regseacli;

public class regcli
extends module
implements Runnable,
colormap {
    public String[] datasets = new String[]{"had3_A2_80", "had3_A2_50", "had3_A2_20", "hhgsax80", "hhgsax20", "eegga180", "gggsa150", "jjgsa180", "basehad3", "baseline", "both1", "both2", "ratio1", "ratio2"};
    public String[] quantities = new String[]{"tmp", "tmn", "tmx", "dtr", "pre", "cld", "vap", "wnd", "rad", "slp", "hum", "mix&tmx&tmn&pre", "mix&experimental"};
    public String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    complexity[] datacomplex = new complexity[]{complexity.simplest, complexity.normal, complexity.normal, complexity.normal, complexity.normal, complexity.normal, complexity.normal, complexity.normal, complexity.simplest, complexity.expert, complexity.simplest, complexity.expert, complexity.experimental, complexity.experimental};
    complexity[] quantcomplex = new complexity[]{complexity.simplest, complexity.normal, complexity.normal, complexity.normal, complexity.simplest, complexity.normal, complexity.normal, complexity.normal, complexity.normal, complexity.normal, complexity.normal, complexity.expert, complexity.experimental};
    public param dataset = new param(new Object[]{"dataset", this.datasets, "had3_A2_80", this.datacomplex, complexity.simplest}){

        public void precalc() {
            regcli.this.checkdoublerequest();
        }
    };
    public param quantity = new param(new Object[]{"quantity", this.quantities, "tmp", this.quantcomplex, complexity.simplest}){

        public void precalc() {
            regcli.this.checkdoublerequest();
        }
    };
    public param month = new param(new Object[]{"month", this.months, "jan", complexity.simplest});
    public param scale = new param("scaletojcm", false);
    public param scaleyear = new param("regcliyear", "yr", 2080, 1750, 2300);
    String oldqd = "";
    public boolean gotdata = false;
    public boolean ready = false;
    public boolean needtorescale = true;
    public boolean hasresetscale = false;
    boolean both;
    boolean ratio;
    boolean hadbase;
    public mapdata d1 = new mapdata();
    public mapdata d2 = new mapdata();
    public mapdata d3 = new mapdata();
    public mapdata d4 = new mapdata();
    public mapdata d5 = new mapdata();
    public mapdata d6 = new mapdata();
    public double dataav;
    public int om = -1;
    public int[] land;
    double min;
    double range;

    public void setinteractions() {
        this.setaffectedby((interacob)this.gm(glotemp.class), this.scale.istrue());
        this.setaffectedby((interacob)this.scaleyear, this.scale.istrue());
    }

    void checkdoublerequest() {
        if (!this.oldqd.equals(this.dataset.chosenname() + this.quantity.chosenname())) {
            this.oldqd = this.dataset.chosenname() + this.quantity.chosenname();
            this.gotdata = false;
        }
    }

    public void initsetup() {
        this.makeland();
        this.om = -1;
        this.addAction(filter.filtertype.Maps, showpan.pan("Map", mapplot.class, this));
        this.mycomplexity = complexity.simplest;
        super.initsetup();
    }

    public void postcalc() {
        this.ready = false;
        if (this.quantity.changed) {
            this.needtorescale = true;
        }
        if (this.gotdata) {
            report.deb("regcli postcalc gotdata");
            this.calc();
            if (this.needtorescale) {
                this.resetscale();
            }
        }
        if (!this.gotdata) {
            processdialog processdialog2 = new processdialog(this, "Loading GCM Data", new JLabel("<html>Loading GCM Data<p>please wait..."));
        }
    }

    public void run() {
        loop.waitUntilLoopDone();
        report.deb("regcli getdata");
        this.getdata();
        this.om = -1;
        this.calc();
        if (this.needtorescale) {
            this.resetscale();
        }
        report.deb("regcli run calls loop go");
        this.changed = true;
        loop.golater("RegCli Run", false);
    }

    public void calc() {
        if (this.om != this.month.getchosenindex()) {
            this.om = this.month.getchosenindex();
        }
        if (this.quantity.chosenname().startsWith("mix")) {
            if (this.both || this.ratio) {
                this.d1.restore(this.om);
                this.d2.restore(this.om);
                this.d3.restore(this.om);
                this.d4.restore(this.om);
                this.d5.restore(this.om);
                this.d6.restore(this.om);
                if (this.scale.istrue()) {
                    this.d4.scaledata((double)this.modelav() / this.dataav);
                    this.d5.scaledata((double)this.modelav() / this.dataav);
                    this.d6.scaledata((double)this.modelav() / this.dataav);
                }
                this.combine(this.d1, this.d1, this.d4);
                this.combine(this.d2, this.d2, this.d5);
                this.combine(this.d3, this.d3, this.d6);
            } else {
                this.d1.restore(this.om);
                this.d2.restore(this.om);
                this.d3.restore(this.om);
                if (this.scale.istrue() && !this.dataset.chosenname().startsWith("base")) {
                    this.d1.scaledata((double)this.modelav() / this.dataav);
                    this.d2.scaledata((double)this.modelav() / this.dataav);
                    this.d3.scaledata((double)this.modelav() / this.dataav);
                }
            }
            if (this.quantity.chosen == "mix&experimental") {
                this.mix(this.d1, this.d1, this.d2);
            }
        } else if (this.both || this.ratio) {
            this.d2.restore(this.om);
            this.d1.restore(this.om);
            if (this.scale.istrue()) {
                this.d2.scaledata((double)this.modelav() / this.dataav);
            }
            if (!this.gm(regseacli.class).ratiochangebase.istrue()) {
                this.combine(this.d1, this.d1, this.d2);
            }
        } else {
            this.d1.restore(this.om);
            if (this.scale.istrue() && !this.dataset.chosenname().startsWith("base")) {
                this.d1.scaledata((double)this.modelav() / this.dataav);
            }
        }
        this.ready = true;
    }

    public void combine(mapdata dest, mapdata d1, mapdata d2) {
        for (int i = 0; i < d1.nlat; ++i) {
            for (int j = 0; j < d1.nlon; ++j) {
                int k = i * d1.nlon + j;
                int k2 = (int)((double)i * ((double)d2.nlat / (double)d1.nlat)) * d2.nlon + (int)((double)j * ((double)d2.nlon / (double)d1.nlon));
                if (mapdata.dud(d1.r[k]) || mapdata.dud(d2.r[k2])) {
                    dest.r[k] = Float.NaN;
                    continue;
                }
                dest.r[k] = this.ratio ? (d1.r[k] != 0.0f ? d2.r[k2] / d1.r[k] : Float.NaN) : d2.r[k2] + d1.r[k];
            }
        }
    }

    public void getdata() {
        this.both = this.dataset.chosenname().startsWith("both");
        this.ratio = this.dataset.chosenname().startsWith("ratio");
        this.hadbase = this.dataset.chosenname().endsWith("1");
        this.gotdata = false;
        if (this.quantity.chosenname().startsWith("mix")) {
            if (this.both || this.ratio) {
                if (this.hadbase) {
                    this.d1.getdata("basehad3", "tmx");
                    this.d2.getdata("basehad3", "pre");
                    this.d3.getdata("basehad3", "tmn");
                } else {
                    this.d1.getdata("baseline", "tmx");
                    this.d2.getdata("baseline", "pre");
                    this.d3.getdata("baseline", "tmn");
                }
                this.d4.getdata("had3_A2_80", "tmx");
                this.d5.getdata("had3_A2_80", "pre");
                this.d6.getdata("had3_A2_80", "tmn");
            } else {
                this.d1.getdata(this.dataset.chosenname(), "tmx");
                this.d2.getdata(this.dataset.chosenname(), "pre");
                this.d3.getdata(this.dataset.chosenname(), "tmn");
            }
        } else if (this.both || this.ratio) {
            this.d1.getdata(this.hadbase ? "basehad3" : "baseline", this.quantity.chosenname());
            this.d2.getdata("had3_A2_80", this.quantity.chosenname());
        } else {
            this.d1.getdata(this.dataset.chosenname(), this.quantity.chosenname());
        }
        if (this.quantity.chosenname() == "tmp") {
            if (this.both || this.ratio) {
                this.dataav = this.d2.av;
            } else if (this.dataset.chosen != "baseline") {
                this.dataav = this.d1.av;
            }
        }
        this.gotdata = true;
    }

    public float modelav() {
        return this.gm(glotemp.class).avchange.get((int)this.scaleyear.val) - this.gm(glotemp.class).avchange.get(1975);
    }

    void makeland() {
        int[] hadoc = new int[]{363, 4, 5, 6, 78, 20, 31, 2, 43, 4, 2, 13, 29, 7, 41, 3, 6, 10, 24, 1, 2, 13, 28, 4, 4, 5, 6, 9, 11, 3, 9, 25, 11, 3, 6, 6, 2, 7, 4, 8, 10, 7, 3, 37, 2, 22, 2, 2, 3, 6, 12, 2, 1, 41, 5, 21, 3, 2, 4, 3, 5, 2, 5, 3, 1, 42, 5, 19, 6, 1, 4, 2, 13, 3, 2, 35, 2, 1, 8, 18, 5, 2, 22, 1, 2, 31, 5, 1, 16, 12, 4, 4, 15, 1, 3, 1, 2, 31, 5, 2, 17, 13, 2, 5, 14, 2, 1, 36, 4, 1, 19, 13, 1, 6, 12, 40, 25, 19, 14, 13, 2, 23, 25, 10, 1, 5, 2, 1, 14, 8, 3, 2, 1, 23, 1, 1, 24, 10, 2, 4, 17, 1, 2, 1, 1, 3, 3, 2, 1, 22, 2, 1, 24, 15, 16, 3, 5, 8, 1, 20, 3, 1, 24, 14, 17, 2, 8, 6, 1, 17, 2, 1, 2, 1, 26, 12, 18, 5, 7, 22, 4, 2, 26, 12, 19, 5, 6, 23, 32, 10, 19, 15, 1, 19, 33, 9, 19, 15, 2, 18, 34, 4, 22, 19, 2, 14, 36, 3, 22, 13, 1, 5, 3, 12, 37, 3, 4, 1, 16, 14, 1, 5, 4, 3, 2, 4, 39, 3, 1, 1, 3, 2, 14, 15, 1, 3, 5, 3, 3, 3, 40, 4, 19, 15, 1, 2, 6, 2, 5, 3, 2, 1, 39, 2, 18, 17, 8, 1, 5, 3, 3, 1, 39, 1, 18, 18, 7, 1, 5, 2, 4, 1, 40, 1, 1, 4, 13, 17, 19, 1, 41, 6, 12, 3, 2, 11, 14, 1, 3, 1, 44, 6, 12, 2, 3, 10, 14, 1, 2, 2, 44, 7, 16, 9, 15, 1, 2, 2, 43, 8, 16, 8, 16, 2, 1, 3, 4, 1, 37, 10, 15, 7, 17, 1, 8, 2, 36, 12, 13, 7, 27, 2, 35, 12, 13, 7, 65, 11, 13, 7, 25, 1, 39, 10, 14, 7, 2, 1, 20, 3, 1, 1, 37, 10, 14, 7, 2, 1, 19, 6, 38, 9, 14, 6, 3, 1, 19, 7, 38, 8, 14, 6, 2, 1, 18, 10, 37, 7, 15, 6, 2, 1, 18, 10, 37, 6, 17, 4, 22, 10, 37, 6, 17, 4, 22, 10, 36, 6, 18, 3, 23, 3, 2, 5, 36, 6, 50, 4, 36, 5, 52, 2, 37, 4, 62, 1, 29, 3, 62, 1, 30, 2, 62, 1, 31, 2, 94, 2, 94, 1, 95, 1, 96, 1, 384, 1, 29, 3, 7, 16, 39, 2, 24, 35, 34, 3, 16, 45, 32, 3, 13, 48, 15, 20, 10, 53, 4, 29, 8, 54, 5, 94, 5, 330};
        this.land = new int[7008];
        int k = 0;
        int l = -1;
        for (int i = 0; i < hadoc.length; ++i) {
            for (int j = 0; j < hadoc[i]; ++j) {
                this.land[k] = l;
                ++k;
            }
            l = -l;
        }
    }

    public void mix(mapdata dest, mapdata d1, mapdata d2) {
        for (int i = 0; i < d1.nlat; ++i) {
            for (int j = 0; j < d1.nlon; ++j) {
                int k = i * d1.nlon + j;
                dest.r[k] = 16 * (4 * ((double)d1.r[k] < d1.av - 0.5 * d1.sd ? 0 : ((double)d1.r[k] < d1.av ? 1 : ((double)d1.r[k] < d1.av + 0.5 * d1.sd ? 2 : 3))) + ((double)d2.r[k] < d2.av - 0.5 * d2.sd ? 0 : ((double)d2.r[k] < d2.av ? 1 : ((double)d2.r[k] < d2.av + 0.5 * d2.sd ? 2 : 3))));
            }
        }
    }

    public void resetscale() {
        this.min = this.d1.fac * (this.d1.av - 2.0 * this.d1.sd);
        this.range = this.d1.fac * (6.0 * this.d1.sd);
        if (this.gotdata) {
            this.needtorescale = false;
        }
        this.hasresetscale = true;
        report.deb("resetscale " + this.min + "-" + (this.min + this.range));
    }

    public boolean hasresetscale() {
        report.deb("hasresetscale " + this.hasresetscale);
        if (this.hasresetscale) {
            this.hasresetscale = false;
            return true;
        }
        return false;
    }

    public boolean gotscale() {
        return true;
    }

    public double getmin() {
        return this.min;
    }

    public double getrange() {
        return this.range;
    }

    public String getMapInfo(region r) {
        return units.dp(this.d1.avg(r), 100.0f) + "    ";
    }

    public float getValue(region r) {
        return this.d1.avg(r);
    }

    public Color mixregcolor(region r) {
        return this.mixcolor(this.d1, this.d2, this.d3, this.d1.avg(r), this.d2.avg(r), this.d3.avg(r));
    }

    public Color mixcolor(mapdata d1, mapdata d2, mapdata d3, float v, float v2, float v3) {
        int b;
        int g;
        if (mapdata.dud(v) || mapdata.dud(v2) || mapdata.dud(v3)) {
            return Color.white;
        }
        int r = (int)(((double)v - (d1.av - 2.0 * d1.sd)) * (128.0 / (2.0 * d1.sd)));
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if ((g = (int)(Math.log(1.0 + ((double)v2 - d2.min) / (d2.av - d2.min)) * 256.0 / Math.log(1.0 + (3.0 * d2.av - d2.min) / (d2.av - d2.min)))) < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if ((b = (int)((d3.av + 2.0 * d3.sd - (double)v3) * (128.0 / (2.0 * d3.sd)))) < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }
}

