/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.regimp;

import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.EOFException;
import jcm.core.reg.region;
import jcm.core.reg.regpoly;
import jcm.core.report;
import jcm.core.tls.fileio;

public class mapdata {
    public byte[][] o;
    public float[] r;
    public int nmon;
    public int nlon;
    public int nlat;
    public int tot;
    public double max;
    public double min;
    public double range;
    public double fac = 1.0;
    public double av;
    public double sd;
    public double sum;
    public double sumsq;
    public double area;
    public boolean gettingdata = false;

    public boolean getdata(String dataset, String quantity) {
        if (!this.gettingdata) {
            this.gettingdata = true;
            boolean gotduds = dataset.equals("baseline");
            String filename = dataset + "." + quantity + ".dat";
            try {
                String srcdir = filename.equals("had3_A2_80.tmp.dat") ? "data/" : "";
                DataInputStream datain = fileio.getDIS(srcdir + "gcmdata/" + filename);
                this.nmon = datain.readShort();
                this.nlat = datain.readShort();
                this.nlon = datain.readShort();
                this.min = datain.readFloat();
                this.max = datain.readFloat();
                this.tot = this.nlon * this.nlat;
                this.range = this.max - this.min;
                this.o = new byte[this.nmon][this.tot + 1];
                this.r = new float[this.tot + 1];
                if (gotduds) {
                    int i = 0;
                    int m = 0;
                    int j = 0;
                    try {
                        int q = 0;
                        boolean dud = false;
                        do {
                            if (dud && j < q) {
                                this.o[m][i] = -1;
                                ++i;
                                ++j;
                            } else if (q == 255) {
                                dud = true;
                                j = 0;
                                q = datain.readUnsignedByte();
                            } else {
                                if (dud) {
                                    dud = false;
                                } else {
                                    this.o[m][i] = (byte)q;
                                    ++i;
                                }
                                q = datain.readUnsignedByte();
                            }
                            if (i != this.nlat * this.nlon) continue;
                            i = 0;
                            ++m;
                        } while (m < this.nmon);
                    }
                    catch (EOFException e) {
                        report.deb("EOF m:" + m + " i:" + i);
                    }
                } else {
                    for (int i = 0; i < this.nmon; ++i) {
                        int got = 0;
                        while ((got += datain.read(this.o[i], got, this.tot - got)) < this.tot) {
                        }
                    }
                }
                datain.close();
                this.stats();
                report.log("loaded " + filename + " av=" + this.av + " sd=" + this.sd + " min=" + this.min + " max=" + this.max);
                this.gettingdata = false;
                return true;
            }
            catch (Exception e) {
                report.log("Mapdata Loading Problem: " + filename + e.getMessage());
                report.log("Mapdata Loading Problem" + filename);
                for (int i = 0; i < this.tot; ++i) {
                    for (int m = 0; m < this.nmon; ++m) {
                        this.o[m][i] = -1;
                    }
                }
                this.gettingdata = false;
                return false;
            }
        }
        return false;
    }

    public void restore(int m) {
        double f = this.range / 254.0;
        for (int i = 0; i < this.tot; ++i) {
            this.r[i] = this.o[m][i] == -1 ? Float.NaN : (float)(this.min + f * (double)(this.o[m][i] >= 0 ? this.o[m][i] : 256 + this.o[m][i]));
        }
        this.fac = 1.0;
    }

    public void stats() {
        this.sum = 0.0;
        this.sumsq = 0.0;
        this.area = 0.0;
        for (int m = 0; m < this.nmon; ++m) {
            this.restore(m);
            for (int i = 0; i < this.nlat; ++i) {
                double cosnlat = Math.sin((0.5 + (double)i) * Math.PI / (double)this.nlat);
                for (int j = 0; j < this.nlon; ++j) {
                    int k = this.nlon * i + j;
                    if (!mapdata.notdud(this.r[k])) continue;
                    this.area += cosnlat;
                    this.sum += cosnlat * (double)this.r[k];
                    this.sumsq += cosnlat * (double)this.r[k] * (double)this.r[k];
                }
            }
        }
        this.av = this.sum / this.area;
        this.sd = Math.pow(this.sumsq / this.area - this.av * this.av, 0.5);
    }

    public void scaledata(double newfac) {
        double fac2 = newfac / this.fac;
        this.fac = newfac;
        for (int i = 0; i < this.tot; ++i) {
            if (!mapdata.notdud(this.r[i])) continue;
            int n = i;
            this.r[n] = (float)((double)this.r[n] * fac2);
        }
    }

    public static boolean notdud(float f) {
        return f >= -999.0f && !Float.isNaN(f);
    }

    public static boolean dud(float f) {
        return f <= -999.0f || Float.isNaN(f);
    }

    public float avg(region reg) {
        if (reg.name.startsWith("PAC_") && reg.name.length() == 6) {
            return Float.NaN;
        }
        double area = 0.0;
        double sum = 0.0;
        double sumarea = 0.0;
        double dudarea = 0.0;
        for (regpoly p : reg.polyset) {
            Rectangle box = p.getBoundingBox();
            int step = 5;
            for (int xo = box.x; xo < box.x + box.width; xo += step) {
                int xd = Math.min(box.x + box.width - xo, step);
                for (int yo = box.y; yo < box.y + box.height; yo += step) {
                    int yd = Math.min(box.y + box.height - yo, step);
                    if (!p.intersects(xo, yo, xd, yd)) continue;
                    boolean inbox = p.contains(xo, yo, xd, yd);
                    for (int yi = yo; yi < yo + yd; ++yi) {
                        area = Math.cos(Math.PI * (double)yi / 180.0);
                        for (int xi = xo; xi < xo + xd; ++xi) {
                            if (!inbox && !p.contains(xi, yi)) continue;
                            int cell2 = this.findcell(xi, yi);
                            try {
                                if (mapdata.notdud(this.r[cell2])) {
                                    sum += (double)this.r[cell2] * area;
                                    sumarea += area;
                                    continue;
                                }
                                dudarea += area;
                                continue;
                            }
                            catch (NullPointerException e) {
                                dudarea += area;
                            }
                        }
                    }
                }
            }
        }
        if (sumarea > dudarea) {
            return (float)(sum / sumarea);
        }
        return Float.NaN;
    }

    int findcell(int x, int y) {
        int xx = (int)(0.5 + (double)(this.nlon * ((x + 360) % 360)) / 360.0);
        int yy = (int)(0.5 + (double)(this.nlat * (90 - y)) / 180.0);
        return yy * this.nlon + xx;
    }
}

