/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.ogas;

import java.util.EnumMap;
import java.util.EnumSet;
import jcm.core.complexity;
import jcm.core.cur.curve;
import jcm.core.cur.curveset;
import jcm.core.ob.module;
import jcm.core.par.param;
import jcm.gui.gen.colfont;
import jcm.mod.carbon.carboncycle;
import jcm.mod.cli.radfor;
import jcm.mod.obj.globco2emit;
import jcm.mod.ogas.gas;
import jcm.mod.regemit.AviaShipEmit;

public class AviationForcing
extends module {
    static int sy = AviaShipEmit.sy;
    AviaShipEmit ase;
    public curve rfi = new curve("Radiative Forcing Index", sy, colfont.black);
    public curve rfnonco2 = new curve("Aviation_Non-CO2", colfont.olive);
    public curve noxemit = new curve("nox-emit", "mega&ton&no2", sy);
    public curveset gasrf = new curveset("Aviation Radiative Forcing", "watt&per&m2", sy);
    public curveset rfis = new curveset("Radiative Forcing Index", this.rfi, sy);
    public param horizon = new param(new Object[]{"RFI time-horizon", "yr", 50, 1, 100, complexity.expert, colfont.red});
    public param tradeoff = new param(new Object[]{"Update_TRADEOFF03", true, complexity.expert, colfont.dkgreen});
    public param inccirrus = new param(new Object[]{"Include Cirrus", true, complexity.expert, colfont.dkblue});
    static final EnumSet<gas> aviagas = EnumSet.of(gas.co2, new gas[]{gas.o3avia, gas.ch4avia, gas.h2oavia, gas.sulphate, gas.bc, gas.contrails, gas.cirrus});
    static final EnumSet<gas> scalebynox = EnumSet.of(gas.o3avia, gas.ch4avia);
    static final EnumSet<gas> scalebyco2 = EnumSet.of(gas.contrails, gas.h2oavia, gas.bc, gas.sulphate);
    static final EnumMap<gas, float[]> rf_fa1 = new EnumMap(gas.class);
    static final EnumMap<gas, Float> tof = new EnumMap(gas.class);
    float cumco2 = 0.0f;
    float[] acccbox = new float[4];
    float[] fa1_co2conc = new float[]{0.9f, 1.5f, 2.5f, 3.5f, 6.0f};
    float scaledown;

    public void initsetup() {
        this.ase = this.gm(AviaShipEmit.class);
        this.follows(this.ase);
        this.follows(this.gm(carboncycle.class));
        this.setaffectedby(this.gm(radfor.class).excavia);
        this.setaffectedby(this.gm(radfor.class).applyefficacy);
        for (gas g : aviagas) {
            this.gasrf.getOrAddCurve((Object)((Object)g)).color = g.col;
            if (!g.name().startsWith("tot")) continue;
            this.gasrf.getOrAddCurve((Object)((Object)g)).type = curve.Type.total;
        }
    }

    public void calcstep() {
        if (year >= sy) {
            this.radfor();
        }
    }

    public void postcalc() {
        this.rfi();
    }

    public void changeendyear(int oldey, int newey) {
        this.noxemit.changeendyear(oldey, newey);
        super.changeendyear(oldey, newey);
    }

    void radfor() {
        int i;
        carboncycle carboncycle2 = this.gm(carboncycle.class);
        float totaviaemit = this.ase.sem.get((Object)AviaShipEmit.sec.tot_Avia);
        this.scaledown = this.ase.tranlongterm.chosen == AviaShipEmit.longterm.mitigate_for_stabilisation && year >= fsyfos ? carboncycle2.fossil.get(year) / this.gm(globco2emit.class).fossilbase.get() : 1.0f;
        if (year == sy) {
            this.cumco2 = 0.0f;
            for (int i2 = 0; i2 < 4; ++i2) {
                this.acccbox[i2] = 0.0f;
            }
        }
        this.cumco2 = 1.25f * carboncycle2.acccmod(this.acccbox, totaviaemit);
        this.gasrf.set((Object)gas.co2, carboncycle2.co2rf.get(year - 1) * this.cumco2 / (carboncycle2.co2atppm.get(year - 1) - 278.0f));
        int scy = year;
        for (i = 1; scy > AviaShipEmit.scen.y[i] && i < AviaShipEmit.scen.y.length - 1; ++i) {
        }
        AviaShipEmit.scen sc = (AviaShipEmit.scen)((Object)this.ase.aviascen.chosen);
        int scycalc = scy < (int)this.ase.endgrowth.getval() ? scy : (int)this.ase.endgrowth.getval();
        float fac = ((float)(scycalc - AviaShipEmit.scen.y[i - 1]) * sc.nox[i] + (float)(AviaShipEmit.scen.y[i] - scycalc) * sc.nox[i - 1]) / (float)(AviaShipEmit.scen.y[i] - AviaShipEmit.scen.y[i - 1]);
        if (scy > 1990) {
            this.noxemit.set(this.scaledown * fac);
        } else {
            this.noxemit.set(sc.nox[0] * totaviaemit / this.ase.sem.get((Object)AviaShipEmit.sec.tot_Avia, 1990));
        }
        for (gas g : scalebyco2) {
            float rfpce = scy > 1990 ? ((float)(scy - AviaShipEmit.scen.y[i - 1]) * rf_fa1.get((Object)g)[i] / AviaShipEmit.scen.Fa1.co2[i] + (float)(AviaShipEmit.scen.y[i] - scy) * rf_fa1.get((Object)g)[i - 1] / AviaShipEmit.scen.Fa1.co2[i - 1]) / (float)(AviaShipEmit.scen.y[i] - AviaShipEmit.scen.y[i - 1]) : rf_fa1.get((Object)g)[0] / AviaShipEmit.scen.Fa1.co2[0];
            this.gasrf.set((Object)g, totaviaemit * (rfpce / 1000.0f) * this.gm(radfor.class).getefficacy(g));
        }
        for (gas g : scalebynox) {
            float rfpne = scy > 1990 ? ((float)(scycalc - AviaShipEmit.scen.y[i - 1]) * rf_fa1.get((Object)g)[i] / AviaShipEmit.scen.Fa1.nox[i] + (float)(AviaShipEmit.scen.y[i] - scycalc) * rf_fa1.get((Object)g)[i - 1] / AviaShipEmit.scen.Fa1.nox[i - 1]) / (float)(AviaShipEmit.scen.y[i] - AviaShipEmit.scen.y[i - 1]) : rf_fa1.get((Object)g)[0] / AviaShipEmit.scen.Fa1.nox[0];
            this.gasrf.set((Object)g, this.noxemit.get() * rfpne * this.gm(radfor.class).getefficacy(g));
        }
        this.gasrf.set((Object)gas.cirrus, this.inccirrus.istrue() ? this.gasrf.get((Object)gas.contrails) : 0.0f);
        if (this.tradeoff.istrue()) {
            for (gas g : aviagas) {
                this.gasrf.set((Object)g, this.gasrf.get((Object)g) * tof.get((Object)g).floatValue());
            }
        }
        float totnonco2 = 0.0f;
        for (gas g : aviagas) {
            if (g == gas.co2) continue;
            totnonco2 += this.gasrf.get((Object)g);
        }
        if (totnonco2 >= 0.0f) {
            this.rfnonco2.set(this.gm(radfor.class).excavia.istrue() ? 0.0f : totnonco2);
        }
    }

    void rfi() {
        float totg = 0.0f;
        float totc = 0.0f;
        for (int y = sy; y < gey; ++y) {
            if ((double)y > (double)gey - this.horizon.val) {
                this.rfi.set(y, Float.NaN);
            }
            int yh = y + (int)this.horizon.val;
            if (y == sy) {
                for (int yy = y; yy <= yh; ++yy) {
                    totc += this.gasrf.get((Object)gas.co2, yy);
                    for (gas g : aviagas) {
                        totg += this.gasrf.get((Object)g, yy);
                    }
                }
            } else {
                totc += this.gasrf.get((Object)gas.co2, yh) - this.gasrf.get((Object)gas.co2, y - 1);
                for (gas g : aviagas) {
                    totg += this.gasrf.get((Object)g, yh) - this.gasrf.get((Object)g, y - 1);
                }
            }
            this.rfi.set(y, totg / totc);
        }
    }

    static {
        rf_fa1.put(gas.co2, new float[]{0.016f, 0.025f, 0.038f, 0.048f, 0.074f});
        tof.put(gas.co2, Float.valueOf(1.0f));
        rf_fa1.put(gas.o3avia, new float[]{0.024f, 0.029f, 0.04f, 0.046f, 0.06f});
        tof.put(gas.o3avia, Float.valueOf(0.79310346f));
        rf_fa1.put(gas.ch4avia, new float[]{-0.015f, -0.018f, -0.027f, -0.032f, -0.045f});
        tof.put(gas.ch4avia, Float.valueOf(0.47368422f));
        rf_fa1.put(gas.h2oavia, new float[]{0.002f, 0.002f, 0.003f, 0.003f, 0.004f});
        tof.put(gas.h2oavia, Float.valueOf(1.0f));
        rf_fa1.put(gas.sulphate, new float[]{-0.003f, -0.004f, -0.006f, -0.007f, -0.009f});
        tof.put(gas.sulphate, Float.valueOf(0.8f));
        rf_fa1.put(gas.bc, new float[]{0.003f, 0.004f, 0.006f, 0.007f, 0.009f});
        tof.put(gas.bc, Float.valueOf(0.6f));
        rf_fa1.put(gas.contrails, new float[]{0.021f, 0.034f, 0.06f, 0.071f, 0.1f});
        tof.put(gas.contrails, Float.valueOf(0.25f));
        tof.put(gas.cirrus, Float.valueOf(1.8571428f));
    }
}

