/*
 * Decompiled with CFR 0.152.
 */
package jcm.mod.obj;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import jcm.core.complexity;
import jcm.core.cur.curveset;
import jcm.core.data.loadtable;
import jcm.core.itf.dataholder;
import jcm.core.ob.module;
import jcm.core.report;

public class sresdata
extends module
implements dataholder {
    public static EnumSet<scen> sresscen = EnumSet.of(scen.A1B, new scen[]{scen.A1T, scen.A1F, scen.A2, scen.B1, scen.B2});
    public static EnumSet<scen> popscen = EnumSet.of(scen.A1, scen.A2, scen.B2);
    public static EnumSet<scen> gdpscen = EnumSet.of(scen.A1, scen.A2, scen.B1, scen.B2);
    public static Map<scen, curveset> sres_image_popn = new HashMap<scen, curveset>();
    public static Map<scen, curveset> sres_image_gdp = new HashMap<scen, curveset>();
    public static Map<scen, curveset> sres_image_fos = new HashMap<scen, curveset>();
    static boolean gotimagedata = false;
    public static float[][] fosemit = new float[8][11];
    public static float[][] lucemit = new float[8][11];
    public static float[][] soxemit = new float[8][11];
    public static float[][] ch4emit = new float[8][11];
    public static float[][] n2oemit = new float[8][11];
    public static float[][] noxemit = new float[8][11];
    public static float[][] coemit = new float[8][11];
    public static float[][] vocemit = new float[8][11];
    public static float[][][] hfcemit = new float[12][7][11];
    public static float[][][] sres4luc = new float[5][6][12];
    public static float[][][] sres4ch4 = new float[5][6][12];
    public static float[][][] sres4n2o = new float[5][6][12];
    public static float[][][] rfdata = new float[10][7][11];
    public static float[][][] sldata = new float[7][6][11];
    public static float[][] bernmid = new float[7][11];
    public static float[][] tempchange = new float[7][11];

    public void initsetup() {
        if (!gotimagedata) {
            sresdata.loadImageData();
        }
        this.addcurvesets();
    }

    static void loadImageData() {
        curveset q;
        report.deb("loading image data");
        for (scen s : popscen) {
            q = new curveset(new Object[]{"pop_" + (Object)((Object)s), "mega&person", 1995, 2100, 5, complexity.expert});
            sres_image_popn.put(s, q);
            loadtable.loaddata(q, "data/sres/POP" + (Object)((Object)s) + ".csv", "\t", false, true, 1.0f, 1995, 2100, 1995, 5);
        }
        for (scen s : gdpscen) {
            q = new curveset(new Object[]{"gdp_" + (Object)((Object)s), "mega&dollar", 1995, 2100, 5, complexity.expert});
            sres_image_gdp.put(s, q);
            loadtable.loaddata(q, "data/sres/GDP" + (Object)((Object)s) + ".csv", "\t", false, true, 1.0f, 1995, 2100, 1995, 5);
            curveset pop = sres_image_popn.get((Object)(s == scen.B1 ? scen.A1 : s));
            for (Object o : q.map.keySet()) {
                for (int y = 1995; y <= 2100; y += 5) {
                    try {
                        q.set(o, y, pop.get(o, y) * q.get(o, y));
                        continue;
                    }
                    catch (Exception e) {
                        report.deb(e);
                    }
                }
            }
        }
        for (scen s : sresscen) {
            q = new curveset(new Object[]{"fos_" + (Object)((Object)s), "giga&ton&carbon", 1995, 2100, 5, complexity.expert});
            sres_image_fos.put(s, q);
            loadtable.loaddata(q, "data/sres/FOS" + (Object)((Object)s) + ".csv", "\t", false, true, 1.0f, 1995, 2100, 1995, 5);
        }
        gotimagedata = true;
    }

    void addcurvesets() {
        for (curveset q : sres_image_popn.values()) {
            this.curvesets.add(q);
            this.addOb(q);
            q.owner = this;
        }
        for (curveset q : sres_image_gdp.values()) {
            this.curvesets.add(q);
            this.addOb(q);
            q.owner = this;
        }
        for (curveset q : sres_image_fos.values()) {
            this.curvesets.add(q);
            this.addOb(q);
            q.owner = this;
        }
    }

    public static float interp(float[][] data, int sc, int year) {
        int bk = (year - 2000) / 10;
        int by = year % 10;
        try {
            return (float)(bk < 10 || sc == 7 && bk < 30 ? ((double)(10 - by) * (double)data[sc][bk] + (double)by * (double)data[sc][bk + 1]) / 10.0 : (sc == 7 ? (double)data[sc][30] : (double)data[sc][10]));
        }
        catch (Exception e) {
            report.log(e, "sres interp error: " + data + " sc=" + sc + " bk=" + bk + " by=" + by);
            return 0.0f;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum scen {
        A1B,
        A1T,
        A1F,
        A2,
        B1,
        B2,
        A1,
        IS92A,
        TGCIA450,
        CPI,
        none;

    }
}

